/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.Collection;
import org.jetbrains.android.dom.animation.AndroidAnimationUtils;
import org.jetbrains.android.dom.animator.AndroidAnimatorUtil;
import org.jetbrains.android.dom.color.AndroidColorDomUtil;
import org.jetbrains.android.dom.drawable.AndroidDrawableDomUtil;
import org.jetbrains.android.dom.transition.TransitionDomUtil;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.MoveFileQuickFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlWrongFileTypeInspection
extends LocalInspectionTool {
    private static ImmutableMultimap<String, ResourceFolderType> ourResourceFolderTypeMap;
    private static final Function<ResourceFolderType, String> TYPE_NAME_FUNCTION;

    @NotNull
    public static ImmutableCollection<ResourceFolderType> determineResourceFolderTypeByRootTag(@NotNull AndroidFacet facet2, @NotNull String tagName) {
        if (ourResourceFolderTypeMap == null) {
            ImmutableMultimap.Builder builder2 = ImmutableMultimap.builder();
            for (String tag : AndroidAnimationUtils.getPossibleRoots()) {
                builder2.put((Object)tag, (Object)ResourceFolderType.ANIM);
            }
            for (String tag : AndroidAnimatorUtil.getPossibleRoots()) {
                builder2.put((Object)tag, (Object)ResourceFolderType.ANIMATOR);
            }
            for (String tag : AndroidXmlResourcesUtil.getPossibleRoots(facet2)) {
                builder2.put((Object)tag, (Object)ResourceFolderType.XML);
            }
            for (String tag : AndroidDrawableDomUtil.getPossibleRoots(facet2)) {
                builder2.put((Object)tag, (Object)ResourceFolderType.DRAWABLE);
            }
            for (String tag : TransitionDomUtil.getPossibleRoots()) {
                builder2.put((Object)tag, (Object)ResourceFolderType.TRANSITION);
            }
            for (String tag : AndroidColorDomUtil.getPossibleRoots()) {
                builder2.put((Object)tag, (Object)ResourceFolderType.COLOR);
            }
            ourResourceFolderTypeMap = builder2.build();
        }
        return ourResourceFolderTypeMap.get((Object)tagName);
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String resourceQualifier;
        String resourceType;
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)file2;
        XmlTag rootTag = xmlFile.getRootTag();
        if (rootTag == null) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return null;
        }
        DomFileDescription description2 = DomManager.getDomManager((Project)file2.getProject()).getDomFileDescription(xmlFile);
        if (description2 != null) {
            return null;
        }
        PsiDirectory directory = file2.getContainingDirectory();
        if (directory == null) {
            return null;
        }
        if (!IdeResourcesUtil.isResourceSubdirectory(directory, null, true)) {
            return null;
        }
        String name = rootTag.getName();
        ImmutableCollection<ResourceFolderType> folderTypes = XmlWrongFileTypeInspection.determineResourceFolderTypeByRootTag(facet2, name);
        if (folderTypes.isEmpty()) {
            return null;
        }
        String directoryName = directory.getName();
        int dashIndex = directoryName.indexOf(45);
        if (dashIndex != -1) {
            resourceType = directoryName.substring(0, dashIndex);
            resourceQualifier = directoryName.substring(dashIndex + 1);
        } else {
            resourceType = directoryName;
            resourceQualifier = null;
        }
        Object folderEnumeration = AndroidTextUtils.generateCommaSeparatedList((Collection)Collections2.transform(folderTypes, TYPE_NAME_FUNCTION), (String)"or");
        if (folderTypes.size() > 1) {
            folderEnumeration = "either " + (String)folderEnumeration;
        }
        String message2 = String.format("<%1$s> XML file should be in %2$s, not \"%3$s\"", name, folderEnumeration, resourceType);
        ASTNode node = XmlChildRole.START_TAG_NAME_FINDER.findChild(rootTag.getNode());
        LocalQuickFix[] quickFixes = new LocalQuickFix[folderTypes.size()];
        int i = 0;
        for (ResourceFolderType type : folderTypes) {
            String resultFolder = resourceQualifier == null ? type.getName() : type.getName() + "-" + resourceQualifier;
            quickFixes[i++] = new MoveFileQuickFix(resultFolder, xmlFile);
        }
        ProblemDescriptor descriptor2 = manager.createProblemDescriptor((PsiElement)(node == null ? rootTag : node.getPsi()), message2, isOnTheFly, quickFixes, ProblemHighlightType.GENERIC_ERROR);
        return new ProblemDescriptor[]{descriptor2};
    }

    static {
        TYPE_NAME_FUNCTION = new Function<ResourceFolderType, String>(){

            @NotNull
            public String apply(ResourceFolderType input2) {
                return "\"" + input2.getName() + "\"";
            }
        };
    }
}

