/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class CreateValueResourceQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private final AndroidFacet myFacet;
    private final ResourceType myResourceType;
    private final String myResourceName;
    private final PsiFile myFile;
    private final boolean myChooseName;

    public CreateValueResourceQuickFix(@NotNull AndroidFacet facet2, @NotNull ResourceType resourceType, @NotNull String resourceName, @NotNull PsiFile file2, boolean chooseName) {
        this.myFacet = facet2;
        this.myResourceType = resourceType;
        this.myResourceName = resourceName;
        this.myFile = file2;
        this.myChooseName = chooseName;
    }

    @NotNull
    public String getName() {
        return AndroidBundle.message("create.value.resource.quickfix.name", this.myResourceName, IdeResourcesUtil.getDefaultResourceFileName(this.myResourceType));
    }

    @NotNull
    public String getText() {
        return AndroidBundle.message("create.value.resource.intention.name", this.myResourceType, this.myResourceName);
    }

    @NotNull
    public String getFamilyName() {
        return AndroidBundle.message("quick.fixes.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.doInvoke();
    }

    protected boolean doInvoke() {
        Project project = this.myFile.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String fileName = IdeResourcesUtil.getDefaultResourceFileName(this.myResourceType);
            assert (fileName != null);
            VirtualFile resourceDir = ResourceFolderManager.getInstance(this.myFacet).getPrimaryFolder();
            assert (resourceDir != null);
            if (!IdeResourcesUtil.createValueResource(project, resourceDir, this.myResourceName, this.myResourceType, fileName, Collections.singletonList("values"), "a")) {
                return false;
            }
        } else {
            VirtualFile defaultFile;
            DomFileDescription description2;
            String value2 = this.myResourceType == ResourceType.STYLEABLE || this.myResourceType == ResourceType.ATTR ? "\n" : null;
            VirtualFile defaultFileToCreate = null;
            if (this.myFile instanceof XmlFile && this.myFile.isWritable() && this.myFile.getManager().isInProject((PsiElement)this.myFile) && (description2 = DomManager.getDomManager((Project)project).getDomFileDescription((XmlFile)this.myFile)) instanceof ResourcesDomFileDescription && (defaultFile = this.myFile.getVirtualFile()) != null) {
                defaultFileToCreate = defaultFile;
            }
            CreateXmlResourceDialog dialog2 = new CreateXmlResourceDialog(this.myFacet.getModule(), this.myResourceType, this.myResourceName, value2, this.myChooseName, defaultFileToCreate, this.myFile.getVirtualFile());
            dialog2.setTitle("New " + StringUtil.capitalize((String)this.myResourceType.getDisplayName()) + " Value Resource");
            if (!dialog2.showAndGet()) {
                return false;
            }
            VirtualFile resourceDir = dialog2.getResourceDirectory();
            if (resourceDir == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", this.myFacet.getModule()));
                return false;
            }
            String fileName = dialog2.getFileName();
            List<String> dirNames = dialog2.getDirNames();
            String resValue = dialog2.getValue();
            String resName = dialog2.getResourceName();
            if (!IdeResourcesUtil.createValueResource(project, resourceDir, resName, this.myResourceType, fileName, dirNames, resValue)) {
                return false;
            }
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UndoUtil.markPsiFileForUndo((PsiFile)this.myFile);
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
    }
}

