/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageFeatureProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidLanguageFeatureProvider
implements LanguageFeatureProvider {
    @NotNull
    public ThreeState isFeatureSupported(@NotNull JavaFeature feature, @NotNull PsiFile file2) {
        if (JavaFeature.MULTI_CATCH == feature) {
            return ThreeState.fromBoolean((boolean)AndroidLanguageFeatureProvider.isApiLevelAtLeast(file2, 19, true));
        }
        if (JavaFeature.STREAMS == feature || JavaFeature.ADVANCED_COLLECTIONS_API == feature) {
            return ThreeState.fromBoolean((boolean)AndroidLanguageFeatureProvider.isApiLevelAtLeast(file2, 24, true));
        }
        if (JavaFeature.THREAD_LOCAL_WITH_INITIAL == feature) {
            return ThreeState.fromBoolean((boolean)AndroidLanguageFeatureProvider.isApiLevelAtLeast(file2, 26, true));
        }
        return ThreeState.UNSURE;
    }

    public static boolean isApiLevelAtLeast(PsiFile file2, int minApiLevel, boolean defaultValue) {
        AndroidFacet facet2;
        if (file2 != null && (facet2 = AndroidFacet.getInstance((PsiElement)file2)) != null && !facet2.isDisposed()) {
            AndroidModuleInfo info2 = AndroidModuleInfo.getInstance(facet2);
            return info2.getMinSdkVersion().getApiLevel() >= minApiLevel;
        }
        return defaultValue;
    }
}

