/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.sdklib.SdkVersionInfo;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.AndroidDeprecationInspection;
import org.jetbrains.android.inspections.VersionChecks;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDeprecationFilter
extends AndroidDeprecationInspection.DeprecationFilter {
    private static final String ACTION_BAR_ACTIVITY = "android.support.v7.app.ActionBarActivity";
    private static final String APP_COMPAT_ACTIVITY = "android.support.v7.app.AppCompatActivity";

    @NotNull
    private static ApiConstraint getDeprecatedIn(@Nullable Project project, @NotNull PsiElement deprecatedElement) {
        PsiClass containingClass;
        if (project == null) {
            return ApiConstraint.UNKNOWN;
        }
        ApiLookup apiLookup = LintIdeClient.getApiLookup((Project)project);
        if (apiLookup == null) {
            return ApiConstraint.UNKNOWN;
        }
        if (deprecatedElement instanceof PsiClass) {
            String owner = ((PsiClass)deprecatedElement).getQualifiedName();
            if (owner != null) {
                return apiLookup.getClassDeprecatedInVersions(owner);
            }
        } else if (deprecatedElement instanceof PsiMember && (containingClass = ((PsiMember)deprecatedElement).getContainingClass()) != null) {
            DefaultJavaEvaluator evaluator = new DefaultJavaEvaluator(project, null);
            String owner = containingClass.getQualifiedName();
            if (owner != null) {
                if (deprecatedElement instanceof PsiField) {
                    String name = ((PsiField)deprecatedElement).getName();
                    return apiLookup.getFieldDeprecatedInVersions(owner, name);
                }
                if (deprecatedElement instanceof PsiMethod) {
                    PsiMethod method2 = (PsiMethod)deprecatedElement;
                    String name = Lint.getInternalMethodName((PsiMethod)method2);
                    String desc = evaluator.getMethodDescription(method2, false, false);
                    if (desc != null) {
                        return apiLookup.getMethodDeprecatedInVersions(owner, name, desc);
                    }
                }
            }
        }
        return ApiConstraint.UNKNOWN;
    }

    @Override
    public boolean isExcluded(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
        Project project = referenceElement.getProject();
        ApiConstraint deprecatedInVersions = AndroidDeprecationFilter.getDeprecatedIn(project, deprecatedElement);
        if (deprecatedInVersions != ApiConstraint.UNKNOWN) {
            int deprecatedIn = deprecatedInVersions.min();
            AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)referenceElement);
            if (facet2 != null && !facet2.isDisposed() && AndroidModuleInfo.getInstance(facet2).getMinSdkVersion().getApiLevel() < deprecatedIn) {
                return !VersionChecks.isPrecededByVersionCheckExit(referenceElement, deprecatedIn) && !VersionChecks.isWithinVersionCheckConditional(referenceElement, deprecatedIn);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public String getDeprecationMessage(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName, @NotNull String defaultMessage) {
        if (ACTION_BAR_ACTIVITY.equals(symbolName)) {
            return "ActionBarActivity is deprecated; use `AppCompatActivity` instead";
        }
        ApiConstraint version2 = AndroidDeprecationFilter.getDeprecatedIn(referenceElement.getProject(), deprecatedElement);
        if (version2 != ApiConstraint.UNKNOWN) {
            ApiConstraint.SdkApiConstraint sdk = version2.findSdk(0, false);
            if (sdk != null) {
                return defaultMessage + " as of " + SdkVersionInfo.getAndroidName((int)sdk.min());
            }
            return defaultMessage + " as of " + version2.min();
        }
        return defaultMessage;
    }

    @Override
    @NotNull
    public LocalQuickFix[] getQuickFixes(@NotNull PsiElement deprecatedElement, @NotNull PsiElement referenceElement, @Nullable String symbolName) {
        if (ACTION_BAR_ACTIVITY.equals(symbolName)) {
            return new LocalQuickFix[]{new ReplaceSuperClassFix(referenceElement, APP_COMPAT_ACTIVITY)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static class ReplaceSuperClassFix
    implements LocalQuickFix {
        private final String myQualifiedName;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> myElement;

        public ReplaceSuperClassFix(@NotNull PsiElement element2, @NotNull String qualifiedName) {
            this.myQualifiedName = qualifiedName;
            this.myElement = SmartPointerManager.getInstance((Project)element2.getProject()).createSmartPsiElementPointer(element2);
        }

        @Nls
        @NotNull
        public String getName() {
            return "Replace With " + this.myQualifiedName.substring(this.myQualifiedName.lastIndexOf(46) + 1);
        }

        @NotNull
        public String getFamilyName() {
            return "Replace deprecated code";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement replace2 = this.myElement.getElement();
            if (replace2 == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory elementFactory = facade.getElementFactory();
            boolean androidX = MigrateToAndroidxUtil.isAndroidx(project);
            String newName2 = androidX ? AndroidxNameUtils.getNewName((String)this.myQualifiedName) : this.myQualifiedName;
            PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(newName2, replace2);
            newReference = replace2.replace((PsiElement)newReference);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)newReference);
        }
    }
}

