/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.android.formatter.AndroidAttributeOrder;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.android.formatter.AndroidXmlRearranger;
import org.jetbrains.annotations.NotNull;

public class AndroidXmlPredefinedCodeStyle
extends PredefinedCodeStyle {
    public AndroidXmlPredefinedCodeStyle() {
        super("Android", (Language)XMLLanguage.INSTANCE);
    }

    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)XmlFileType.INSTANCE);
        indentOptions.CONTINUATION_INDENT_SIZE = indentOptions.INDENT_SIZE;
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class);
        xmlSettings.XML_ALIGN_ATTRIBUTES = false;
        xmlSettings.XML_SPACE_INSIDE_EMPTY_TAG = true;
        xmlSettings.XML_KEEP_LINE_BREAKS = false;
        AndroidXmlCodeStyleSettings androidSettings = AndroidXmlCodeStyleSettings.getInstance(settings);
        androidSettings.USE_CUSTOM_SETTINGS = true;
        androidSettings.LAYOUT_SETTINGS = new AndroidXmlCodeStyleSettings.LayoutSettings();
        androidSettings.MANIFEST_SETTINGS = new AndroidXmlCodeStyleSettings.ManifestSettings();
        androidSettings.VALUE_RESOURCE_FILE_SETTINGS = new AndroidXmlCodeStyleSettings.ValueResourceFileSettings();
        androidSettings.OTHER_SETTINGS = new AndroidXmlCodeStyleSettings.OtherSettings();
        AndroidXmlPredefinedCodeStyle.applyArrangementSettings(settings.getCommonSettings((Language)XMLLanguage.INSTANCE));
    }

    public static void applyArrangementSettings(@NotNull CommonCodeStyleSettings xmlCommonSettings) {
        ArrayList<StdArrangementMatchRule> rules2 = new ArrayList<StdArrangementMatchRule>();
        rules2.add(AndroidXmlRearranger.newAttributeRule("xmlns:android", "^$", StdArrangementTokens.Order.KEEP));
        rules2.add(AndroidXmlRearranger.newAttributeRule("xmlns:.*", "^$", StdArrangementTokens.Order.BY_NAME));
        rules2.add(AndroidXmlRearranger.newAttributeRule(".*:id", "http://schemas.android.com/apk/res/android", StdArrangementTokens.Order.KEEP));
        rules2.add(AndroidXmlRearranger.newAttributeRule(".*:name", "http://schemas.android.com/apk/res/android", StdArrangementTokens.Order.KEEP));
        rules2.add(AndroidXmlRearranger.newAttributeRule("name", "^$", StdArrangementTokens.Order.KEEP));
        rules2.add(AndroidXmlRearranger.newAttributeRule("style", "^$", StdArrangementTokens.Order.KEEP));
        rules2.add(AndroidXmlRearranger.newAttributeRule(".*", "^$", StdArrangementTokens.Order.BY_NAME));
        rules2.add(AndroidXmlRearranger.newAttributeRule(".*", "http://schemas.android.com/apk/res/android", (ArrangementSettingsToken)AndroidAttributeOrder.INSTANCE));
        rules2.add(AndroidXmlRearranger.newAttributeRule(".*", ".*", StdArrangementTokens.Order.BY_NAME));
        xmlCommonSettings.setArrangementSettings((ArrangementSettings)StdArrangementSettings.createByMatchRules(Collections.emptyList(), rules2));
        xmlCommonSettings.FORCE_REARRANGE_MODE = 1;
    }
}

