/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.io.IdeFileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ModalityUiUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.compiler.artifact.ApkSigningSettingsForm;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageUtil;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GenerateSignedApkSettings;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class KeystoreStep
extends ExportSignedPackageWizardStep
implements ApkSigningSettingsForm {
    public static final String MODULE_PROPERTY = "ExportedModule";
    @VisibleForTesting
    static final String KEY_STORE_PASSWORD_KEY = "KEY_STORE_PASSWORD";
    @VisibleForTesting
    static final String KEY_PASSWORD_KEY = "KEY_PASSWORD";
    private JPanel myContentPanel;
    private JButton myCreateKeyStoreButton;
    private JBCheckBox myExportKeysCheckBox;
    private HyperlinkLabel myGoogleAppSigningLabel;
    private JPasswordField myKeyStorePasswordField;
    private JPasswordField myKeyPasswordField;
    private TextFieldWithBrowseButton.NoPathCompletion myKeyAliasField;
    private JTextField myKeyStorePathField;
    private JButton myLoadKeyStoreButton;
    private JBCheckBox myRememberPasswordCheckBox;
    @VisibleForTesting
    JComboBox<AndroidFacet> myModuleCombo;
    private JPanel myGradlePanel;
    private JBLabel myGradleWarning;
    private JBLabel myKeyStorePathLabel;
    private JBLabel myKeyStorePasswordLabel;
    private JBLabel myKeyAliasLabel;
    private JBLabel myKeyPasswordLabel;
    private JPanel myExportKeyPanel;
    @VisibleForTesting
    JBLabel myExportKeyPathLabel;
    @VisibleForTesting
    TextFieldWithBrowseButton myExportKeyPathField;
    private final ExportSignedPackageWizard myWizard;
    private final boolean myUseGradleForSigning;
    private boolean myIsBundle;
    @VisibleForTesting
    AndroidFacet mySelection;
    @VisibleForTesting
    final List<AndroidFacet> myFacets;

    public KeystoreStep(@NotNull ExportSignedPackageWizard wizard, boolean useGradleForSigning, @NotNull List<AndroidFacet> facets) {
        this.myWizard = wizard;
        this.myFacets = facets;
        this.myUseGradleForSigning = useGradleForSigning;
        this.$$$setupUI$$$();
        Project project = wizard.getProject();
        GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(project);
        this.myKeyStorePathField.setText(settings.KEY_STORE_PATH);
        this.myKeyAliasField.setText(settings.KEY_ALIAS);
        this.myRememberPasswordCheckBox.setSelected(settings.REMEMBER_PASSWORDS);
        if (settings.REMEMBER_PASSWORDS) {
            this.tryLoadSavedPasswords();
        }
        this.myModuleCombo.setRenderer((ListCellRenderer<AndroidFacet>)SimpleListCellRenderer.create((label, value2, index2) -> {
            if (value2 == null) {
                return;
            }
            Module module2 = value2.getModule();
            label.setText(module2.getName());
            label.setIcon(ModuleType.get((Module)module2).getIcon());
        }));
        this.myGradleWarning.setIcon(StudioIcons.Common.WARNING_INLINE);
        this.myGradlePanel.setVisible(false);
        this.myModuleCombo.addActionListener(e -> this.updateSelection((AndroidFacet)this.myModuleCombo.getSelectedItem()));
        this.myExportKeysCheckBox.addActionListener(e -> {
            this.myExportKeyPathLabel.setVisible(this.myExportKeysCheckBox.isSelected());
            this.myExportKeyPathField.setVisible(this.myExportKeysCheckBox.isSelected());
        });
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myExportKeyPathField.addBrowseFolderListener("Select Encrypted Key Destination Folder", null, this.myWizard.getProject(), descriptor2);
        VirtualFile desktopDir = IdeFileUtils.getDesktopDirectoryVirtualFile();
        if (desktopDir != null) {
            this.myExportKeyPathField.setText(desktopDir.getPath());
        }
        ExportSignedPackageUtil.initSigningSettingsForm(project, this);
    }

    public void _init() {
        super._init();
        this.myIsBundle = this.myWizard.getTargetType().equals("bundle");
        this.updateModuleDropdown();
        if (this.myIsBundle) {
            GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(this.myWizard.getProject());
            this.myExportKeysCheckBox.setSelected(settings.EXPORT_PRIVATE_KEY);
            this.myGoogleAppSigningLabel.setHyperlinkText("Google Play App Signing");
            this.myGoogleAppSigningLabel.setHyperlinkTarget("https://support.google.com/googleplay/android-developer/answer/7384423");
            this.myGoogleAppSigningLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.myExportKeysCheckBox.setVisible(true);
            this.myGoogleAppSigningLabel.setVisible(true);
            this.myExportKeyPathLabel.setVisible(this.myExportKeysCheckBox.isVisible() && this.myExportKeysCheckBox.isSelected());
            this.myExportKeyPathField.setVisible(this.myExportKeysCheckBox.isVisible() && this.myExportKeysCheckBox.isSelected());
        } else {
            this.myExportKeysCheckBox.setVisible(false);
            this.myGoogleAppSigningLabel.setVisible(false);
            this.myExportKeyPathLabel.setVisible(false);
            this.myExportKeyPathField.setVisible(false);
        }
        this.myKeyStorePathField.addActionListener(action2 -> this.keyStoreSelected());
        this.myKeyAliasField.getTextField().addActionListener(action2 -> this.keyAliasSelected());
    }

    private void updateModuleDropdown() {
        List<AndroidFacet> facets = this.myIsBundle ? this.filteredFacets(this.myFacets) : this.myFacets;
        this.mySelection = null;
        this.myModuleCombo.setEnabled(facets.size() > 1);
        if (!facets.isEmpty()) {
            String savedModuleName = PropertiesComponent.getInstance((Project)this.myWizard.getProject()).getValue(KeystoreStep.getModuleProperty(this.myIsBundle));
            Optional<AndroidFacet> optionalFacet = facets.stream().filter(facet2 -> facet2.getModule().getName().equals(savedModuleName)).findFirst();
            this.mySelection = optionalFacet.orElse(facets.get(0));
            this.myModuleCombo.setModel((ComboBoxModel<AndroidFacet>)new CollectionComboBoxModel(facets, (Object)this.mySelection));
            this.updateSelection(this.mySelection);
        }
    }

    private List<AndroidFacet> filteredFacets(List<AndroidFacet> facets) {
        return facets.stream().filter(f -> !InstantApps.isInstantAppApplicationModule(f)).collect(Collectors.toList());
    }

    private void updateSelection(@Nullable AndroidFacet selectedItem) {
        PropertiesComponent.getInstance((Project)this.myWizard.getProject()).setValue(KeystoreStep.getModuleProperty(this.myIsBundle), selectedItem == null ? "" : selectedItem.getModule().getName());
        this.mySelection = selectedItem;
        this.showGradleError(!this.isGradleValid(this.myWizard.getTargetType()));
    }

    @NotNull
    static String getModuleProperty(boolean isBundle) {
        return isBundle ? "BundleExportedModule" : "ApkExportedModule";
    }

    private boolean isGradleValid(@NotNull String targetType) {
        if (!targetType.equals("bundle")) {
            return true;
        }
        if (this.mySelection == null) {
            return true;
        }
        return GradleProjectSystemUtil.supportsBundleTask(this.mySelection.getModule());
    }

    private void showGradleError(boolean showError2) {
        this.myKeyStorePasswordField.setVisible(!showError2);
        this.myKeyPasswordField.setVisible(!showError2);
        this.myKeyAliasField.setVisible(!showError2);
        this.myKeyStorePathField.setVisible(!showError2);
        this.myCreateKeyStoreButton.setVisible(!showError2);
        this.myLoadKeyStoreButton.setVisible(!showError2);
        this.myRememberPasswordCheckBox.setVisible(!showError2);
        this.myKeyStorePasswordLabel.setVisible(!showError2);
        this.myKeyPasswordLabel.setVisible(!showError2);
        this.myKeyAliasLabel.setVisible(!showError2);
        this.myKeyStorePathLabel.setVisible(!showError2);
        this.myExportKeyPanel.setVisible(!showError2);
        this.myExportKeyPathLabel.setVisible(!showError2);
        this.myExportKeyPathField.setVisible(!showError2);
        this.myGradlePanel.setVisible(showError2);
    }

    @Override
    public void keyStoreSelected() {
        this.myKeyStorePasswordField.setText(null);
        this.myKeyPasswordField.setText(null);
        this.tryLoadSavedPasswords();
    }

    @Override
    public void keyStoreCreated() {
    }

    @Override
    public void keyAliasSelected() {
        this.myKeyPasswordField.setText(null);
        this.tryLoadSavedPasswords();
    }

    @Override
    public void keyAliasCreated() {
    }

    private void tryLoadSavedPasswords() {
        String keyStorePath = this.myKeyStorePathField.getText();
        String keyAlias2 = this.myKeyAliasField.getText();
        this.executeInBackground(() -> {
            String keyStorePasswordKey = KeystoreStep.makePasswordKey(KEY_STORE_PASSWORD_KEY, keyStorePath, null);
            String keyPasswordKey = KeystoreStep.makePasswordKey(KEY_PASSWORD_KEY, keyStorePath, keyAlias2);
            try {
                PasswordSafe passwordSafe = PasswordSafe.getInstance();
                KeystoreStep.retrievePassword(passwordSafe, Arrays.asList(KeystoreStep.credentialAttributesForKey(keyStorePasswordKey), KeystoreStep.createKeystoreDeprecatedAttributesPre_2021_1_1_3(keyStorePasswordKey), KeystoreStep.createDeprecatedAttributesPre_3_2(keyStorePasswordKey))).map(Credentials::getPassword).ifPresent(password -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> {
                    if (this.myKeyStorePasswordField.getPassword().length == 0) {
                        this.myKeyStorePasswordField.setText(password.toString());
                    }
                }));
                KeystoreStep.retrievePassword(passwordSafe, Arrays.asList(KeystoreStep.credentialAttributesForKey(keyPasswordKey), KeystoreStep.createKeyDeprecatedAttributesPre_2021_1_1_3(keyPasswordKey), KeystoreStep.createDeprecatedAttributesPre_3_2(keyPasswordKey))).map(Credentials::getPassword).ifPresent(password -> ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> {
                    if (this.myKeyPasswordField.getPassword().length == 0) {
                        this.myKeyPasswordField.setText(password.toString());
                    }
                }));
            }
            catch (Throwable t) {
                Logger.getInstance(KeystoreStep.class).error("Unable to use password safe", t);
            }
        });
    }

    private void executeInBackground(Runnable runnable2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        }
    }

    @Slow
    @NotNull
    private static @NotNull Optional<@NotNull Credentials> retrievePassword(@NotNull PasswordSafe passwordSafe, @NotNull @NotNull List<@NotNull CredentialAttributes> credentialAttributesToTry) {
        return credentialAttributesToTry.stream().map(attributes -> Optional.ofNullable(passwordSafe.get(attributes))).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    @VisibleForTesting
    static void trySavePasswords(@NotNull String keyStoreLocation, char[] keyStorePassword, @NotNull String keyAlias2, char[] keyPassword2, boolean rememberPasswords) {
        String keyStorePasswordKey = KeystoreStep.makePasswordKey(KEY_STORE_PASSWORD_KEY, keyStoreLocation, null);
        String keyPasswordKey = KeystoreStep.makePasswordKey(KEY_PASSWORD_KEY, keyStoreLocation, keyAlias2);
        try {
            PasswordSafe passwordSafe = PasswordSafe.getInstance();
            if (rememberPasswords) {
                passwordSafe.set(KeystoreStep.credentialAttributesForKey(keyStorePasswordKey), new Credentials(keyStorePasswordKey, keyStorePassword));
                passwordSafe.set(KeystoreStep.credentialAttributesForKey(keyPasswordKey), new Credentials(keyPasswordKey, keyPassword2));
            } else {
                passwordSafe.set(KeystoreStep.credentialAttributesForKey(keyStorePasswordKey), null);
                passwordSafe.set(KeystoreStep.credentialAttributesForKey(keyPasswordKey), null);
            }
            passwordSafe.set(KeystoreStep.createDeprecatedAttributesPre_3_2(keyStorePasswordKey), null);
            passwordSafe.set(KeystoreStep.createDeprecatedAttributesPre_3_2(keyPasswordKey), null);
            passwordSafe.set(KeystoreStep.createKeystoreDeprecatedAttributesPre_2021_1_1_3(keyStorePasswordKey), null);
            passwordSafe.set(KeystoreStep.createKeyDeprecatedAttributesPre_2021_1_1_3(keyPasswordKey), null);
        }
        catch (Throwable t) {
            Logger.getInstance(KeystoreStep.class).error("Unable to use password safe", t);
        }
    }

    @NotNull
    private static CredentialAttributes credentialAttributesForKey(@NotNull String key) {
        String serviceName = CredentialAttributesKt.generateServiceName((String)"APK Signing Keystore Step", (String)key);
        return new CredentialAttributes(serviceName);
    }

    @NotNull
    private static CredentialAttributes createDeprecatedAttributesPre_3_2(@NotNull String key) {
        return new CredentialAttributes(KeystoreStep.class.getName(), key);
    }

    @NotNull
    private static CredentialAttributes createKeystoreDeprecatedAttributesPre_2021_1_1_3(@NotNull String key) {
        return new CredentialAttributes("org.jetbrains.android.exportSignedPackage.KeystoreStep$KeyStorePasswordRequestor", key);
    }

    @NotNull
    private static CredentialAttributes createKeyDeprecatedAttributesPre_2021_1_1_3(@NotNull String key) {
        return new CredentialAttributes("org.jetbrains.android.exportSignedPackage.KeystoreStep$KeyPasswordRequestor", key);
    }

    @VisibleForTesting
    static String makePasswordKey(@NotNull String prefix, @NotNull String keyStorePath, @Nullable String keyAlias2) {
        return prefix + "__" + keyStorePath + (String)(keyAlias2 != null ? "__" + keyAlias2 : "");
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myKeyStorePathField.getText().isEmpty()) {
            return this.myKeyStorePathField;
        }
        if (this.myKeyStorePasswordField.getPassword().length == 0) {
            return this.myKeyStorePasswordField;
        }
        if (this.myKeyAliasField.getText().isEmpty()) {
            return this.myKeyAliasField;
        }
        if (this.myKeyPasswordField.getPassword().length == 0) {
            return this.myKeyPasswordField;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    @Override
    public String getHelpId() {
        return "org.jetbrains.android.studio/publish/app-signing#generate-key";
    }

    @Override
    protected void commitForNext() throws CommitStepException {
        boolean rememberPasswords;
        if (!this.isGradleValid(this.myWizard.getTargetType())) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.bundle.gradle.error", new Object[0]));
        }
        String keyStoreLocation = this.myKeyStorePathField.getText().trim();
        if (keyStoreLocation.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.keystore.location.error", new Object[0]));
        }
        char[] keyStorePassword = this.myKeyStorePasswordField.getPassword();
        if (keyStorePassword.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.store.password.error", new Object[0]));
        }
        String keyAlias2 = this.myKeyAliasField.getText().trim();
        if (keyAlias2.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.alias.error", new Object[0]));
        }
        char[] keyPassword2 = this.myKeyPasswordField.getPassword();
        if (keyPassword2.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.password.error", new Object[0]));
        }
        if (this.myUseGradleForSigning) {
            this.myWizard.setGradleSigningInfo(new GradleSigningInfo(keyStoreLocation, keyStorePassword, keyAlias2, keyPassword2));
        } else {
            KeyStore keyStore = this.loadKeyStore(new File(keyStoreLocation));
            if (keyStore == null) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.keystore.error.title", new Object[0]));
            }
            this.loadKeyAndSaveToWizard(keyStore, keyAlias2, keyPassword2);
        }
        Project project = this.myWizard.getProject();
        GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(project);
        settings.KEY_STORE_PATH = keyStoreLocation;
        settings.KEY_ALIAS = keyAlias2;
        settings.REMEMBER_PASSWORDS = rememberPasswords = this.myRememberPasswordCheckBox.isSelected();
        if (this.myWizard.getTargetType().equals("bundle")) {
            boolean exportPrivateKey;
            settings.EXPORT_PRIVATE_KEY = exportPrivateKey = this.myExportKeysCheckBox.isSelected();
            this.myWizard.setExportPrivateKey(exportPrivateKey);
            if (exportPrivateKey) {
                String keyFolder = this.myExportKeyPathField.getText().trim();
                if (keyFolder.isEmpty()) {
                    throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.missing.destination", this.myWizard.getTargetType()));
                }
                File f = new File(keyFolder);
                if (!f.isDirectory() || !f.canWrite()) {
                    throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.invalid.destination", new Object[0]));
                }
                this.myWizard.setExportKeyPath(keyFolder);
            }
        }
        KeystoreStep.trySavePasswords(keyStoreLocation, keyStorePassword, keyAlias2, keyPassword2, rememberPasswords);
        this.myWizard.setFacet(this.getSelectedFacet());
    }

    private KeyStore loadKeyStore(File keystoreFile) throws CommitStepException {
        KeyStore keyStore;
        char[] password = this.myKeyStorePasswordField.getPassword();
        FileInputStream fis = null;
        AndroidUtils.checkPassword(password);
        if (!keystoreFile.isFile()) {
            throw new CommitStepException(AndroidBundle.message("android.cannot.find.file.error", keystoreFile.getPath()));
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(keystoreFile);
            keyStore.load(fis, password);
        }
        catch (Exception e) {
            throw new CommitStepException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            Arrays.fill(password, '\u0000');
        }
        return keyStore;
    }

    private void loadKeyAndSaveToWizard(KeyStore keyStore, String alias, char[] keyPassword2) throws CommitStepException {
        KeyStore.PrivateKeyEntry entry;
        try {
            assert (keyStore != null);
            entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(keyPassword2));
        }
        catch (Exception e) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.error.0.message", e.getLocalizedMessage()));
        }
        if (entry == null) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", alias));
        }
        PrivateKey privateKey = entry.getPrivateKey();
        Certificate certificate = entry.getCertificate();
        if (privateKey == null || certificate == null) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", alias));
        }
        this.myWizard.setPrivateKey(privateKey);
        this.myWizard.setCertificate((X509Certificate)certificate);
    }

    private AndroidFacet getSelectedFacet() {
        return (AndroidFacet)this.myModuleCombo.getSelectedItem();
    }

    @Override
    public JButton getLoadKeyStoreButton() {
        return this.myLoadKeyStoreButton;
    }

    @Override
    public JTextField getKeyStorePathField() {
        return this.myKeyStorePathField;
    }

    @Override
    public JPanel getPanel() {
        return this.myContentPanel;
    }

    @Override
    public JButton getCreateKeyStoreButton() {
        return this.myCreateKeyStoreButton;
    }

    @Override
    public JPasswordField getKeyStorePasswordField() {
        return this.myKeyStorePasswordField;
    }

    @Override
    public TextFieldWithBrowseButton getKeyAliasField() {
        return this.myKeyAliasField;
    }

    @Override
    public JPasswordField getKeyPasswordField() {
        return this.myKeyPasswordField;
    }

    @VisibleForTesting
    JBCheckBox getExportKeysCheckBox() {
        return this.myExportKeysCheckBox;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        HyperlinkLabel hyperlinkLabel2;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        JBCheckBox jBCheckBox2;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JPasswordField jPasswordField;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JPasswordField jPasswordField2;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JPanel jPanel3;
        this.myContentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Module");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myModuleCombo = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel3.add((Component)jSeparator, new GridConstraints(1, 0, 1, 2, 0, 1, 6, 0, new Dimension(-1, 1), new Dimension(-1, 24), new Dimension(-1, 1)));
        this.myKeyStorePathLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Key store path");
        jBLabel6.setDisplayedMnemonic('K');
        jBLabel6.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyStorePasswordLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Key store password");
        jBLabel5.setDisplayedMnemonic('P');
        jBLabel5.setDisplayedMnemonicIndex(10);
        jPanel3.add((Component)jBLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyStorePasswordField = jPasswordField2 = new JPasswordField();
        jPanel3.add((Component)jPasswordField2, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myKeyAliasLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Key alias");
        jBLabel4.setDisplayedMnemonic('E');
        jBLabel4.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jBLabel4, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyPasswordLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Key password");
        jBLabel3.setDisplayedMnemonic('W');
        jBLabel3.setDisplayedMnemonicIndex(8);
        jPanel3.add((Component)jBLabel3, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyPasswordField = jPasswordField = new JPasswordField();
        jPanel3.add((Component)jPasswordField, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myKeyAliasField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel3.add((Component)noPathCompletion, new GridConstraints(6, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myKeyStorePathField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myCreateKeyStoreButton = jButton2 = new JButton();
        jButton2.setText("Create new...");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myLoadKeyStoreButton = jButton = new JButton();
        jButton.setText("Choose existing...");
        jButton.setMnemonic('H');
        jButton.setDisplayedMnemonicIndex(1);
        jPanel4.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRememberPasswordCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Remember passwords");
        jBCheckBox2.setMnemonic('R');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(8, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExportKeyPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(9, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myExportKeysCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.bundle.key.export"));
        jPanel2.add((Component)jBCheckBox, "West");
        this.myGoogleAppSigningLabel = hyperlinkLabel2 = new HyperlinkLabel();
        hyperlinkLabel2.setIconTextGap(2);
        hyperlinkLabel2.setVisible(true);
        jPanel2.add((Component)hyperlinkLabel2, "Center");
        this.myGradlePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(false);
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        this.myGradleWarning = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.bundle.gradle.error"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myExportKeyPathLabel = jBLabel = new JBLabel();
        jBLabel.setText("Encrypted key export path");
        jPanel3.add((Component)jBLabel, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExportKeyPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(10, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jBLabel6.setLabelFor(jTextField);
        jBLabel5.setLabelFor(jPasswordField2);
        jBLabel4.setLabelFor((Component)noPathCompletion);
        jBLabel3.setLabelFor(jPasswordField);
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

