/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class GradleSignStep
extends ExportSignedPackageWizardStep {
    @NonNls
    private static final String PROPERTY_APK_PATH = "ExportApk.ApkPath";
    @NonNls
    private static final String PROPERTY_BUNDLE_PATH = "ExportBundle.BundlePath";
    @NonNls
    private static final String PROPERTY_BUILD_VARIANTS = "ExportApk.BuildVariants";
    private JPanel myContentPanel;
    private TextFieldWithBrowseButton myApkPathField;
    private JBList<String> myBuildVariantsList;
    private final ExportSignedPackageWizard myWizard;
    private final DefaultListModel<String> myBuildVariantsListModel;
    private GradleAndroidModel myAndroidModel;

    public GradleSignStep(@NotNull ExportSignedPackageWizard exportSignedPackageWizard) {
        this.$$$setupUI$$$();
        this.myBuildVariantsListModel = new DefaultListModel();
        this.myWizard = exportSignedPackageWizard;
        this.myBuildVariantsList.setModel(this.myBuildVariantsListModel);
        this.myBuildVariantsList.setEmptyText(AndroidBundle.message("android.apk.sign.gradle.no.variants", new Object[0]));
        new ListSpeedSearch(this.myBuildVariantsList);
    }

    public void _init() {
        this.myAndroidModel = GradleAndroidModel.get(this.myWizard.getFacet());
        PropertiesComponent properties2 = PropertiesComponent.getInstance((Project)this.myWizard.getProject());
        this.myBuildVariantsListModel.clear();
        ArrayList<String> buildVariants = new ArrayList<String>();
        if (this.myAndroidModel != null) {
            buildVariants.addAll(this.myAndroidModel.getVariantNames());
            Collections.sort(buildVariants);
        }
        TIntArrayList lastSelectedIndices = new TIntArrayList(buildVariants.size());
        List cachedVariants = properties2.getList(PROPERTY_BUILD_VARIANTS);
        HashSet lastSelectedVariants = cachedVariants == null ? Collections.emptySet() : Sets.newHashSet((Iterable)cachedVariants);
        for (int i = 0; i < buildVariants.size(); ++i) {
            String variant2 = (String)buildVariants.get(i);
            this.myBuildVariantsListModel.addElement(variant2);
            if (!lastSelectedVariants.contains(variant2)) continue;
            lastSelectedIndices.add(i);
        }
        this.myBuildVariantsList.setSelectedIndices(lastSelectedIndices.toNativeArray());
        String moduleName2 = this.myAndroidModel.getModuleName();
        String targetType = this.myWizard.getTargetType();
        this.myApkPathField.setText(FileUtil.toSystemDependentName((String)this.getInitialPath(properties2, moduleName2, targetType)));
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myApkPathField.addBrowseFolderListener("Select APK Destination Folder", null, this.myWizard.getProject(), descriptor2);
    }

    @Override
    public String getHelpId() {
        return "org.jetbrains.android.studio/publish/app-signing";
    }

    @Override
    protected void commitForNext() throws CommitStepException {
        if (this.myAndroidModel == null) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.no.model", new Object[0]));
        }
        String apkFolder = this.myApkPathField.getText().trim();
        if (apkFolder.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.missing.destination", this.myWizard.getTargetType()));
        }
        File f = new File(apkFolder);
        if (!f.isDirectory() || !f.canWrite()) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.invalid.destination", new Object[0]));
        }
        int[] selectedVariantIndices = this.myBuildVariantsList.getSelectedIndices();
        if (this.myBuildVariantsList.isEmpty() || selectedVariantIndices.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.missing.variants", new Object[0]));
        }
        List buildVariants = this.myBuildVariantsList.getSelectedValuesList();
        this.myWizard.setApkPath(apkFolder);
        this.myWizard.setGradleOptions(this.myBuildVariantsList.getSelectedValuesList());
        PropertiesComponent properties2 = PropertiesComponent.getInstance((Project)this.myWizard.getProject());
        properties2.setValue(this.getApkPathPropertyName(this.myAndroidModel.getModuleName(), this.myWizard.getTargetType()), apkFolder);
        properties2.setList(PROPERTY_BUILD_VARIANTS, (Collection)buildVariants);
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    @VisibleForTesting
    String getInitialPath(@NotNull PropertiesComponent properties2, @NotNull String moduleName2, @NotNull String targetType) {
        String lastApkFolderPath = properties2.getValue(this.getApkPathPropertyName(moduleName2, targetType));
        if (!Strings.isNullOrEmpty((String)lastApkFolderPath)) {
            return lastApkFolderPath;
        }
        if (this.myAndroidModel == null) {
            return this.myWizard.getProject().getBaseDir().getPath();
        }
        return this.myAndroidModel.getRootDirPath().getPath();
    }

    @VisibleForTesting
    String getApkPathPropertyName(String moduleName2, String targetType) {
        return (targetType.equals("apk") ? PROPERTY_APK_PATH : PROPERTY_BUNDLE_PATH) + (String)(Strings.isNullOrEmpty((String)moduleName2) ? "" : "For" + moduleName2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Destination Folder:");
        jBLabel.setDisplayedMnemonic('D');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myApkPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Build Variants:");
        jBLabel2.setDisplayedMnemonic('B');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBuildVariantsList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

