/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.resources.PublicResource;
import org.jetbrains.android.dom.resources.PublicResourceNameConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/android/dom/resources/PublicResourceNameConverter;", "Lcom/intellij/util/xml/ResolvingConverter$StringConverter;", "()V", "getVariants", "", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "resolve", "Lcom/intellij/psi/PsiElement;", "resourceName", "intellij.android.core"})
public final class PublicResourceNameConverter
extends ResolvingConverter.StringConverter {
    @Nullable
    public PsiElement resolve(@Nullable String resourceName, @Nullable ConvertContext context2) {
        if (resourceName == null) {
            return null;
        }
        ConvertContext convertContext = context2;
        if (convertContext == null || (convertContext = convertContext.getXmlElement()) == null) {
            return null;
        }
        ConvertContext element2 = convertContext;
        ResourceNamespace resourceNamespace = IdeResourcesUtil.getResourceNamespace((PsiElement)element2);
        if (resourceNamespace == null) {
            return null;
        }
        ResourceNamespace resourceNamespace2 = resourceNamespace;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element2), XmlTag.class);
        if (xmlTag == null) {
            return null;
        }
        XmlTag tag = xmlTag;
        XmlAttribute xmlAttribute = tag.getAttribute("type");
        if (xmlAttribute == null) {
            return null;
        }
        XmlAttribute xmlAttribute2 = xmlAttribute;
        String string = xmlAttribute2.getValue();
        if (string == null) {
            return null;
        }
        String attributeValue = string;
        ResourceType resourceType = ResourceType.fromXmlValue((String)attributeValue);
        if (resourceType == null) {
            return null;
        }
        ResourceType resourceType2 = resourceType;
        return (PsiElement)new ResourceReferencePsiElement((PsiElement)element2, new ResourceReference(resourceNamespace2, resourceType2, resourceName), false, 4, null);
    }

    @NotNull
    public Collection<String> getVariants(@Nullable ConvertContext context2) {
        Collection collection2;
        ConvertContext convertContext = context2;
        DomElement domElement = convertContext != null && (convertContext = convertContext.getInvocationElement()) != null ? convertContext.getParent() : null;
        PublicResource publicResource = domElement instanceof PublicResource ? (PublicResource)domElement : null;
        if (publicResource == null) {
            return CollectionsKt.emptyList();
        }
        PublicResource element2 = publicResource;
        Module module2 = context2.getModule();
        if (module2 == null) {
            return CollectionsKt.emptyList();
        }
        Module module3 = module2;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module3);
        if (androidFacet == null) {
            return CollectionsKt.emptyList();
        }
        AndroidFacet facet2 = androidFacet;
        GenericAttributeValue<ResourceType> genericAttributeValue = element2.getType();
        ResourceType elementType = genericAttributeValue != null ? (ResourceType)genericAttributeValue.getValue() : null;
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getInstance(facet2).getModuleResources();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)localResourceRepository), (String)"getInstance(facet).moduleResources");
        LocalResourceRepository moduleResources = localResourceRepository;
        if (elementType == null) {
            List list2 = moduleResources.getAllResources().stream().map(getVariants.1.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"{\n      // No type attri\u2026ollectors.toList())\n    }");
            collection2 = list2;
        } else {
            Set<String> set = moduleResources.getResourceNames(ResourceNamespace.RES_AUTO, elementType);
            Intrinsics.checkNotNullExpressionValue(set, (String)"{\n      // User has alre\u2026_AUTO, elementType)\n    }");
            collection2 = set;
        }
        return collection2;
    }
}

