/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.navigation;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002\u001a \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"findStartDestination", "Lcom/intellij/psi/xml/XmlTag;", "root", "getStartDestLayoutId", "", "navResourceId", "project", "Lcom/intellij/openapi/project/Project;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "intellij.android.core"})
public final class NavXmlHelperKt {
    @Nullable
    public static final String getStartDestLayoutId(@NotNull String navResourceId, @NotNull Project project, @NotNull ResourceResolver resourceResolver2) {
        Intrinsics.checkNotNullParameter((Object)navResourceId, (String)"navResourceId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resourceResolver2, (String)"resourceResolver");
        if (!StringsKt.startsWith$default((String)navResourceId, (String)"@navigation/", (boolean)false, (int)2, null)) {
            return null;
        }
        ResourceValue resourceValue = resourceResolver2.findResValue(navResourceId, false);
        String string = resourceValue != null ? resourceValue.getValue() : null;
        if (string == null) {
            return null;
        }
        String fileName = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)file2);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psiFile2 = xmlFile;
        return (String)ApplicationManager.getApplication().runReadAction(new Computable(psiFile2){
            final /* synthetic */ XmlFile $psiFile;
            {
                this.$psiFile = $psiFile;
            }

            public final String compute() {
                XmlTag xmlTag = NavXmlHelperKt.access$findStartDestination(this.$psiFile.getRootTag());
                return xmlTag != null ? xmlTag.getAttributeValue("layout", "http://schemas.android.com/tools") : null;
            }
        });
    }

    private static final XmlTag findStartDestination(XmlTag root) {
        XmlTag current = root;
        while (true) {
            Object v6;
            block7: {
                String string;
                block9: {
                    block8: {
                        XmlTag xmlTag = current;
                        if (!Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"navigation")) break;
                        string = current.getAttributeValue("startDestination", "http://schemas.android.com/apk/res-auto");
                        if (string == null) break block8;
                        String p0 = string;
                        boolean bl = false;
                        String string2 = ResourcesUtil.stripPrefixFromId((String)p0);
                        string = string2;
                        if (string2 != null) break block9;
                    }
                    return null;
                }
                String startDestId = string;
                PsiElement[] psiElementArray = current.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"current\n      .children");
                Iterable $this$firstOrNull$iv = ArraysKt.filterIsInstance((Object[])psiElementArray, XmlTag.class);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String string3;
                    String string4;
                    XmlTag it = (XmlTag)element$iv;
                    boolean bl = false;
                    String string5 = string4 = it.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
                    if (string5 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAttributeValue(ATTR_ID, ANDROID_URI)");
                        String p0 = string4;
                        boolean bl2 = false;
                        string3 = ResourcesUtil.stripPrefixFromId((String)p0);
                    } else {
                        string3 = null;
                    }
                    if (!Intrinsics.areEqual(string3, (Object)startDestId)) continue;
                    v6 = element$iv;
                    break block7;
                }
                v6 = null;
            }
            current = v6;
        }
        return current;
    }

    public static final /* synthetic */ XmlTag access$findStartDestination(XmlTag root) {
        return NavXmlHelperKt.findStartDestination(root);
    }
}

