/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.AndroidManifestXmlFile;
import org.jetbrains.android.dom.manifest.CompatibleScreensScreen;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a1\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00130\u0002\"\u0004\b\u0000\u0010\u0013*\u00020\n2\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\b\u0017\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0016*\u00020\n\"=\u0010\u0000\u001a1\u0012(\u0012&\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003 \u0005*\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"=\u0010\u0007\u001a1\u0012(\u0012&\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003 \u0005*\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"CUSTOM_PERMISSIONS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "CUSTOM_PERMISSION_GROUPS", "getCustomPermissionGroups", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getCustomPermissions", "isRequiredAttribute", "", "attrName", "Lcom/intellij/util/xml/XmlName;", "element", "Lcom/intellij/util/xml/DomElement;", "cachedValueFromPrimaryManifest", "T", "valueSelector", "Lkotlin/Function1;", "Lorg/jetbrains/android/dom/manifest/AndroidManifestXmlFile;", "Lkotlin/ExtensionFunctionType;", "getPrimaryManifestXml", "intellij.android.core"})
@JvmName(name="AndroidManifestUtils")
public final class AndroidManifestUtils {
    @NotNull
    private static final Key<CachedValue<Collection<String>>> CUSTOM_PERMISSIONS;
    @NotNull
    private static final Key<CachedValue<Collection<String>>> CUSTOM_PERMISSION_GROUPS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRequiredAttribute(@NotNull XmlName attrName, @NotNull DomElement element2) {
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof CompatibleScreensScreen)) return false;
        if (!Intrinsics.areEqual((Object)attrName.getNamespaceKey(), (Object)"http://schemas.android.com/apk/res/android")) return false;
        String string = attrName.getLocalName();
        switch (string.hashCode()) {
            case -417399155: {
                if (string.equals("screenSize")) return true;
                return false;
            }
            case -1360635172: {
                if (!string.equals("screenDensity")) return false;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static final Collection<String> getCustomPermissions(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        try {
            return (Collection)DumbService.getInstance((Project)facet2.getModule().getProject()).runReadActionInSmartMode(new Computable(facet2){
                final /* synthetic */ AndroidFacet $facet;
                {
                    this.$facet = $facet;
                }

                public final Collection<String> compute() {
                    return AndroidManifestIndexQueryUtils.queryCustomPermissionsFromManifestIndex(this.$facet);
                }
            });
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            CachedValue cachedValue2 = AndroidManifestUtils.cachedValueFromPrimaryManifest(facet2, getCustomPermissions.cachedValue.1.INSTANCE);
            return (Collection)((CachedValue)facet2.putUserDataIfAbsent(CUSTOM_PERMISSIONS, cachedValue2)).getValue();
        }
    }

    @Nullable
    public static final Collection<String> getCustomPermissionGroups(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        try {
            return (Collection)DumbService.getInstance((Project)facet2.getModule().getProject()).runReadActionInSmartMode(new Computable(facet2){
                final /* synthetic */ AndroidFacet $facet;
                {
                    this.$facet = $facet;
                }

                public final Collection<String> compute() {
                    return AndroidManifestIndexQueryUtils.queryCustomPermissionGroupsFromManifestIndex(this.$facet);
                }
            });
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            CachedValue cachedValue2 = AndroidManifestUtils.cachedValueFromPrimaryManifest(facet2, getCustomPermissionGroups.cachedValue.1.INSTANCE);
            return (Collection)((CachedValue)facet2.putUserDataIfAbsent(CUSTOM_PERMISSION_GROUPS, cachedValue2)).getValue();
        }
    }

    @NotNull
    public static final <T> CachedValue<T> cachedValueFromPrimaryManifest(@NotNull AndroidFacet $this$cachedValueFromPrimaryManifest, @NotNull Function1<? super AndroidManifestXmlFile, ? extends T> valueSelector) {
        Intrinsics.checkNotNullParameter((Object)$this$cachedValueFromPrimaryManifest, (String)"<this>");
        Intrinsics.checkNotNullParameter(valueSelector, (String)"valueSelector");
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)$this$cachedValueFromPrimaryManifest.getModule().getProject()).createCachedValue(new CachedValueProvider($this$cachedValueFromPrimaryManifest, valueSelector){
            final /* synthetic */ AndroidFacet $this_cachedValueFromPrimaryManifest;
            final /* synthetic */ Function1<AndroidManifestXmlFile, T> $valueSelector;
            {
                this.$this_cachedValueFromPrimaryManifest = $receiver;
                this.$valueSelector = $valueSelector;
            }

            @Nullable
            public final CachedValueProvider.Result<T> compute() {
                CachedValueProvider.Result result2;
                AndroidFacet androidFacet = this.$this_cachedValueFromPrimaryManifest;
                boolean $i$f$runReadAction2 = false;
                AndroidManifestXmlFile primaryManifest = (AndroidManifestXmlFile)ApplicationManager.getApplication().runReadAction(new Computable(androidFacet){
                    final /* synthetic */ AndroidFacet $this_cachedValueFromPrimaryManifest$inlined;
                    {
                        this.$this_cachedValueFromPrimaryManifest$inlined = androidFacet;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)AndroidManifestUtils.getPrimaryManifestXml(this.$this_cachedValueFromPrimaryManifest$inlined);
                    }
                });
                if (primaryManifest == null) {
                    Object[] $i$f$runReadAction2 = new Object[]{ModificationTracker.EVER_CHANGED};
                    CachedValueProvider.Result result3 = CachedValueProvider.Result.create(null, (Object[])$i$f$runReadAction2);
                    result2 = result3;
                    Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"{\n      CachedValueProvi\u2026acker.EVER_CHANGED)\n    }");
                } else {
                    Object[] objectArray = this.$valueSelector;
                    boolean $i$f$runReadAction3 = false;
                    Object result4 = ApplicationManager.getApplication().runReadAction(new Computable((Function1)objectArray, primaryManifest){
                        final /* synthetic */ Function1 $valueSelector$inlined;
                        final /* synthetic */ AndroidManifestXmlFile $primaryManifest$inlined;
                        {
                            this.$valueSelector$inlined = function1;
                            this.$primaryManifest$inlined = androidManifestXmlFile;
                        }

                        public final T compute() {
                            boolean bl = false;
                            return (T)this.$valueSelector$inlined.invoke((Object)this.$primaryManifest$inlined);
                        }
                    });
                    objectArray = new Object[]{primaryManifest};
                    CachedValueProvider.Result result5 = CachedValueProvider.Result.create((Object)result4, (Object[])objectArray);
                    result2 = result5;
                    Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"{\n      val result = run\u2026t, primaryManifest)\n    }");
                }
                return result2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"T> AndroidFacet.cachedVa\u2026rimaryManifest)\n    }\n  }");
        return cachedValue2;
    }

    @Nullable
    public static final AndroidManifestXmlFile getPrimaryManifestXml(@NotNull AndroidFacet $this$getPrimaryManifestXml) {
        AndroidManifestXmlFile androidManifestXmlFile;
        PsiFile psiFile;
        VirtualFile it;
        Intrinsics.checkNotNullParameter((Object)$this$getPrimaryManifestXml, (String)"<this>");
        if ($this$getPrimaryManifestXml.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile = SourceProviderManager.Companion.getInstance($this$getPrimaryManifestXml).getMainManifestFile();
        if (virtualFile != null) {
            it = virtualFile;
            boolean bl = false;
            psiFile = AndroidPsiUtils.getPsiFileSafely((Project)$this$getPrimaryManifestXml.getModule().getProject(), (VirtualFile)it);
        } else {
            psiFile = null;
        }
        PsiFile psiFile2 = psiFile;
        XmlFile xmlFile = psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
        if (xmlFile != null) {
            it = xmlFile;
            boolean bl = false;
            XmlTag xmlTag = it.getRootTag();
            androidManifestXmlFile = Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"manifest") ? new AndroidManifestXmlFile((XmlFile)it) : (AndroidManifestXmlFile)null;
        } else {
            androidManifestXmlFile = null;
        }
        return androidManifestXmlFile;
    }

    static {
        Key key = Key.create((String)"merged.manifest.custom.permissions");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<CachedValue<Colle\u2026fest.custom.permissions\")");
        CUSTOM_PERMISSIONS = key;
        Key key2 = Key.create((String)"merged.manifest.custom.permission.groups");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create<CachedValue<Colle\u2026ustom.permission.groups\")");
        CUSTOM_PERMISSION_GROUPS = key2;
    }
}

