/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.lint;

import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueIdConverter
extends ResolvingConverter<Issue> {
    private static ImmutableMap<String, Issue> ourIssues = null;

    @NotNull
    public static ImmutableMap<String, Issue> getIdSet() {
        if (ourIssues == null) {
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            for (Issue issue2 : new BuiltinIssueRegistry().getIssues()) {
                builder2.put((Object)issue2.getId(), (Object)issue2);
            }
            ourIssues = builder2.build();
        }
        return ourIssues;
    }

    @NotNull
    public Collection<Issue> getVariants(ConvertContext context2) {
        return IssueIdConverter.getIdSet().values();
    }

    @Nullable
    public Issue fromString(@Nullable @NonNls String s, ConvertContext context2) {
        return (Issue)IssueIdConverter.getIdSet().get((Object)s);
    }

    @Nullable
    public String toString(@Nullable Issue issue2, ConvertContext context2) {
        return issue2 == null ? null : issue2.getId();
    }

    @Nullable
    public LookupElement createLookupElement(Issue issue2) {
        return LookupElementBuilder.create((Object)issue2, (String)issue2.getId());
    }
}

