/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.inspections;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.imports.MavenClassRegistryManager;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.inspections.MavenClassResolverUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u000eH\u0017J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getDisplayName", "", "getGroupDisplayName", "getShortName", "isRelevantFile", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "Lcom/intellij/psi/xml/XmlFile;", "MyVisitor", "intellij.android.core"})
public final class AndroidUnresolvableTagInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.inspections.group.name\")");
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.unresolvable.tag", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.inspections.unresolvable.tag\")");
        return string;
    }

    @NotNull
    public String getShortName() {
        return "AndroidUnresolvableTag";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file2 instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)((PsiElement)file2));
        if (androidFacet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = androidFacet;
        Module module2 = facet2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        if (!AndroidModuleSystem.canRegisterDependency$default(ProjectSystemUtil.getModuleSystem(module2), null, 1, null).isSupported()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (this.isRelevantFile(facet2, (XmlFile)file2)) {
            MyVisitor visitor2 = new MyVisitor(manager, isOnTheFly);
            file2.accept((PsiElementVisitor)visitor2);
            Collection $this$toTypedArray$iv = visitor2.getMyResult();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ProblemDescriptor[] problemDescriptorArray = thisCollection$iv.toArray(new ProblemDescriptor[0]);
            if (problemDescriptorArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return problemDescriptorArray;
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private final boolean isRelevantFile(AndroidFacet facet2, XmlFile file2) {
        ResourceFolderType resourceType = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().getFileResourceFolderType((PsiFile)file2);
        return resourceType != null ? resourceType == ResourceFolderType.LAYOUT || resourceType == ResourceFolderType.MENU : false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/android/dom/inspections/AndroidUnresolvableTagInspection$MyVisitor;", "Lcom/intellij/psi/XmlRecursiveElementVisitor;", "myInspectionManager", "Lcom/intellij/codeInspection/InspectionManager;", "myOnTheFly", "", "(Lcom/intellij/codeInspection/InspectionManager;Z)V", "mavenClassRegistryManager", "Lcom/android/tools/idea/imports/MavenClassRegistryManager;", "getMavenClassRegistryManager", "()Lcom/android/tools/idea/imports/MavenClassRegistryManager;", "myResult", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getMyResult", "()Ljava/util/List;", "getTagNameRange", "Lcom/intellij/psi/PsiElement;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "visitXmlTag", "", "findChildToken", "targetType", "Lcom/intellij/psi/tree/IElementType;", "intellij.android.core"})
    private static final class MyVisitor
    extends XmlRecursiveElementVisitor {
        @NotNull
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        @NotNull
        private final List<ProblemDescriptor> myResult;
        @NotNull
        private final MavenClassRegistryManager mavenClassRegistryManager;

        public MyVisitor(@NotNull InspectionManager myInspectionManager, boolean myOnTheFly) {
            Intrinsics.checkNotNullParameter((Object)myInspectionManager, (String)"myInspectionManager");
            this.myInspectionManager = myInspectionManager;
            this.myOnTheFly = myOnTheFly;
            this.myResult = new ArrayList();
            this.mavenClassRegistryManager = MavenClassRegistryManager.Companion.getInstance();
        }

        @NotNull
        public final List<ProblemDescriptor> getMyResult() {
            return this.myResult;
        }

        @NotNull
        public final MavenClassRegistryManager getMavenClassRegistryManager() {
            return this.mavenClassRegistryManager;
        }

        public void visitXmlTag(@NotNull XmlTag tag) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                super.visitXmlTag(tag);
                String string = tag.getNamespace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tag.namespace");
                if (((CharSequence)string).length() > 0) {
                    return;
                }
                PsiReference[] psiReferenceArray = tag.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"tag.references");
                PsiReference psiReference = (PsiReference)ArraysKt.lastOrNull((Object[])psiReferenceArray);
                if (psiReference == null) {
                    return;
                }
                PsiReference reference = psiReference;
                if (reference.resolve() != null) break block4;
                String string2 = tag.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag.name");
                String className = string2;
                Project project = tag.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"tag.project");
                Collection<LocalQuickFix> fixes = MavenClassResolverUtils.collectFixesFromMavenClassRegistry(this.mavenClassRegistryManager, className, project);
                PsiElement psiElement = this.getTagNameRange(tag);
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{className};
                    Collection<LocalQuickFix> $this$toTypedArray$iv = fixes;
                    boolean $i$f$toTypedArray = false;
                    Collection<LocalQuickFix> thisCollection$iv = $this$toTypedArray$iv;
                    LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                    if (localQuickFixArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    ProblemDescriptor problemDescriptor = this.myInspectionManager.createProblemDescriptor(it, AndroidBundle.message("element.cannot.resolve", objectArray), this.myOnTheFly, localQuickFixArray, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                    Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"myInspectionManager.crea\u2026NOWN_SYMBOL\n            )");
                    this.myResult.add(problemDescriptor);
                }
            }
        }

        private final PsiElement getTagNameRange(XmlTag tag) {
            PsiElement psiElement = tag.getFirstChild();
            Object object = psiElement != null ? psiElement.getNextSibling() : null;
            if (object == null) {
                return null;
            }
            PsiElement range = object;
            IElementType iElementType = XmlTokenType.XML_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"XML_NAME");
            PsiElement psiElement2 = this.findChildToken(range, iElementType);
            if (psiElement2 == null) {
                psiElement2 = range;
            }
            return psiElement2;
        }

        private final PsiElement findChildToken(PsiElement $this$findChildToken, IElementType targetType) {
            PsiElement curr;
            for (curr = $this$findChildToken.getFirstChild(); !(curr == null || curr instanceof XmlToken && Intrinsics.areEqual((Object)((XmlToken)curr).getTokenType(), (Object)targetType)); curr = curr.getNextSibling()) {
            }
            return curr;
        }
    }
}

