/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.inspections;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidAnyTagDescriptor;
import org.jetbrains.android.dom.inspections.AndroidUnknownAttributeInspection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.TagFromClassDescriptor;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidElementNotAllowedInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return AndroidBundle.message("android.inspections.group.name", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return AndroidBundle.message("android.inspections.element.not.allowed.name", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "AndroidElementNotAllowed";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!(file2 instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (AndroidUnknownAttributeInspection.isMyFile(facet2, (XmlFile)file2)) {
            MyVisitor visitor2 = new MyVisitor(manager, isOnTheFly);
            file2.accept((PsiElementVisitor)visitor2);
            return visitor2.myResult.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static boolean isUnknownCustomView(XmlTag tag) {
        ResourceFolderType type;
        PsiFile file2 = tag.getContainingFile();
        return file2 != null && (type = IdeResourcesUtil.getFolderType(file2)) == ResourceFolderType.LAYOUT && tag.getName().indexOf(46) != -1;
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(InspectionManager inspectionManager, boolean onTheFly) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
        }

        public void visitXmlTag(XmlTag tag) {
            XmlElementDescriptor descriptor2;
            super.visitXmlTag(tag);
            if (tag.getNamespace().isEmpty() && ((descriptor2 = tag.getDescriptor()) instanceof AndroidAnyTagDescriptor || descriptor2 instanceof TagFromClassDescriptor && ((TagFromClassDescriptor)descriptor2).getClazz() == null)) {
                XmlToken endTagNameElement;
                XmlToken startTagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                if (startTagNameElement != null && !AndroidElementNotAllowedInspection.isUnknownCustomView(tag)) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)startTagNameElement, XmlAnalysisBundle.message((String)"xml.inspections.element.is.not.allowed.here", (Object[])new Object[]{tag.getName()}), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
                if ((endTagNameElement = XmlTagUtil.getEndTagNameElement((XmlTag)tag)) != null && !AndroidElementNotAllowedInspection.isUnknownCustomView(tag)) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)endTagNameElement, XmlAnalysisBundle.message((String)"xml.inspections.element.is.not.allowed.here", (Object[])new Object[]{tag.getName()}), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
            }
        }
    }
}

