/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.utils.OffsetTrackingDecodedXmlValue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.android.dom.converters.DataBindingConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingVariableTypeConverter
extends DataBindingConverter {
    public String getErrorMessage(@Nullable String type, @NotNull ConvertContext context2) {
        PsiTypeElement typeElement = DataBindingVariableTypeConverter.createTypeElement(type, context2);
        if (typeElement != null) {
            PsiType unresolved = DataBindingVariableTypeConverter.findUnresolvedType(typeElement.getType());
            if (unresolved == null) {
                return null;
            }
            type = unresolved.getPresentableText();
        }
        return super.getErrorMessage(type, context2);
    }

    @Override
    @Nullable
    public PsiElement fromString(@Nullable String type, @NotNull ConvertContext context2) {
        if (type == null) {
            return null;
        }
        PsiElement element2 = super.fromString(type, context2);
        if (element2 != null) {
            return element2;
        }
        PsiTypeElement typeElement = DataBindingVariableTypeConverter.createTypeElement(type, context2);
        if (typeElement != null && DataBindingVariableTypeConverter.findUnresolvedType(typeElement.getType()) != null) {
            return null;
        }
        return typeElement;
    }

    @Nullable
    private static PsiTypeElement createTypeElement(@Nullable String type, @NotNull ConvertContext context2) {
        if (type == null) {
            return null;
        }
        BindingXmlIndex.Entry indexEntry = DataBindingVariableTypeConverter.getBindingIndexEntry(context2);
        if (indexEntry == null) {
            return null;
        }
        Project project = context2.getProject();
        type = DataBindingUtil.getQualifiedType(project, type, indexEntry.getData(), false);
        if (type == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiJavaParserFacade parser2 = facade.getParserFacade();
        try {
            return parser2.createTypeElementFromText(type, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private static PsiType findUnresolvedType(@NotNull PsiType psiType) {
        final PsiType[] result2 = new PsiType[1];
        psiType.accept((PsiTypeVisitor)new DataBindingUtil.ClassReferenceVisitor(){

            @Override
            public void visitClassReference(@NotNull PsiClassReferenceType classType) {
                PsiClassType rawType;
                if (result2[0] == null && (rawType = classType.rawType()).resolve() == null) {
                    result2[0] = rawType;
                }
            }
        });
        return result2[0];
    }

    @Override
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiElement> value2, final PsiElement element2, final ConvertContext context2) {
        PsiType psiType;
        assert (element2 instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element2;
        final OffsetTrackingDecodedXmlValue decodedValue = new OffsetTrackingDecodedXmlValue((CharSequence)attrValue.getValue());
        String typeStr = decodedValue.getDecodedCharacters().toString();
        final ArrayList<PsiReferenceBase.Immediate> result2 = new ArrayList<PsiReferenceBase.Immediate>();
        final int valueOffset = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element2.getProject());
        PsiJavaParserFacade parser2 = psiFacade.getParserFacade();
        try {
            psiType = parser2.createTypeFromText(typeStr, null);
        }
        catch (IncorrectOperationException e) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiType instanceof PsiPrimitiveType) {
            result2.add(new PsiReferenceBase.Immediate(element2, true, element2));
        } else {
            psiType.accept((PsiTypeVisitor)new DataBindingUtil.ClassReferenceVisitor(){

                @Override
                public void visitClassReference(@NotNull PsiClassReferenceType classReference) {
                    PsiJavaCodeReferenceElement reference = classReference.getReference();
                    int offset = reference.getTextRange().getStartOffset();
                    offset = decodedValue.getEncodedOffset(offset);
                    DataBindingConverter.createReferences(element2, DataBindingVariableTypeConverter.getName(reference), true, valueOffset + offset, context2, result2);
                }
            });
        }
        return result2.toArray(PsiReference.EMPTY_ARRAY);
    }

    @Nullable
    private static String getName(PsiJavaCodeReferenceElement reference) {
        return reference.isQualified() ? reference.getQualifiedName() : reference.getReferenceName();
    }
}

