/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMissingClassQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiPackage> myPackage;
    @NotNull
    private final String myClassName;
    @NotNull
    private final Module myModule;
    private final String myBaseClassFqcn;

    CreateMissingClassQuickFix(@NotNull PsiPackage aPackage, @NotNull String className, @NotNull Module module2, @Nullable String baseClassFqcn) {
        this.myPackage = SmartPointerManager.getInstance((Project)aPackage.getProject()).createSmartPsiElementPointer((PsiElement)aPackage);
        this.myClassName = className;
        this.myModule = module2;
        this.myBaseClassFqcn = baseClassFqcn;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nls
    @NotNull
    public String getName() {
        return String.format("Create class '%s'", this.myClassName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Create class";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiDirectory directory;
        PsiPackage aPackage = (PsiPackage)this.myPackage.getElement();
        if (aPackage == null) {
            return;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)this.myModule);
        if (facet2 == null) {
            return;
        }
        IdeaSourceProvider sources = SourceProviderManager.getInstance(facet2).getSources();
        Iterable sourceDirs = Iterables.concat(sources.getJavaDirectories(), sources.getKotlinDirectories());
        PsiDirectory[] directories2 = aPackage.getDirectories();
        ArrayList filteredDirectories = Lists.newArrayListWithExpectedSize((int)directories2.length);
        block4: for (PsiDirectory directory2 : directories2) {
            for (VirtualFile file2 : sourceDirs) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)directory2.getVirtualFile(), (boolean)true)) continue;
                filteredDirectories.add(directory2);
                continue block4;
            }
        }
        switch (filteredDirectories.size()) {
            case 0: {
                directory = null;
                break;
            }
            case 1: {
                directory = (PsiDirectory)filteredDirectories.get(0);
                break;
            }
            default: {
                PsiDirectory[] array = filteredDirectories.toArray(PsiDirectory.EMPTY_ARRAY);
                directory = DirectoryChooserUtil.selectDirectory((Project)aPackage.getProject(), (PsiDirectory[])array, (PsiDirectory)((PsiDirectory)filteredDirectories.get(0)), (String)"");
            }
        }
        if (directory == null) {
            return;
        }
        PsiClass aClass = (PsiClass)WriteCommandAction.writeCommandAction((Project)project).compute(() -> {
            PsiModifierList modifierList;
            PsiClass parentClass;
            PsiClass psiClass = JavaDirectoryService.getInstance().createClass(directory, this.myClassName);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiReferenceList list2 = psiClass.getExtendsList();
            if (list2 != null && this.myBaseClassFqcn != null && (parentClass = facade.findClass(this.myBaseClassFqcn, GlobalSearchScope.allScope((Project)project))) != null) {
                list2.add((PsiElement)facade.getElementFactory().createClassReferenceElement(parentClass));
            }
            if ((modifierList = psiClass.getModifierList()) != null) {
                modifierList.setModifierProperty("public", true);
            }
            return psiClass;
        });
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, aClass.getContainingFile().getVirtualFile());
        FileEditorManager.getInstance((Project)project).openEditor(fileDescriptor, true);
    }
}

