/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.ApiMember;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.android.dom.RemovedApiField;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPermissionConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    private static final String PERMISSION_CLASS_NAME = "android.Manifest.permission";
    private static final String PERMISSION_CLASS_NAME_FOR_API_LOOKUP = "android/Manifest$permission";
    private static final String PERMISSION_PREFIX = "android.permission.";

    public String fromString(@Nullable @NonNls String str, ConvertContext context2) {
        return str;
    }

    public String toString(@Nullable String value2, ConvertContext context2) {
        return value2;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull GenericDomValue<String> value2, @NotNull PsiElement element2, @NotNull ConvertContext context2) {
        AndroidModel model2;
        AndroidFacet facet2;
        DomElement domElement = context2.getInvocationElement();
        Module module2 = context2.getModule();
        GlobalSearchScope scope2 = module2 != null ? GlobalSearchScope.allScope((Project)module2.getProject()) : domElement.getResolveScope();
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)context2.getPsiManager().getProject());
        PsiClass permissionClass = javaFacade.findClass(PERMISSION_CLASS_NAME, scope2);
        if (permissionClass == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        int minVersion = 1;
        int maxVersion = Integer.MAX_VALUE;
        if (module2 != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null && (model2 = AndroidModel.get(facet2)) != null) {
            AndroidVersion version2 = model2.getMinSdkVersion();
            if (version2 != null) {
                minVersion = version2.getApiLevel();
            }
            if ((version2 = model2.getTargetSdkVersion()) != null) {
                maxVersion = version2.getApiLevel();
            }
        }
        return new PsiReference[]{new MyReference(element2, permissionClass, minVersion, maxVersion)};
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiClass myPermissionClass;
        private final int myMinVersion;
        private final int myMaxVersion;

        public MyReference(@NotNull PsiElement element2, @NotNull PsiClass permissionClass, int minVersion, int maxVersion) {
            super(element2, true);
            this.myPermissionClass = permissionClass;
            this.myMinVersion = minVersion;
            this.myMaxVersion = maxVersion;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                @Nullable
                public PsiElement resolve(@NotNull PsiReference reference, boolean incompleteCode) {
                    return this.resolveInner();
                }
            }, false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            String qualifiedName = this.getValue();
            if (!qualifiedName.startsWith(AndroidPermissionConverter.PERMISSION_PREFIX)) {
                return null;
            }
            String name = qualifiedName.substring(AndroidPermissionConverter.PERMISSION_PREFIX.length());
            Map<String, PsiElement> permissions = this.getPermissions(Collections.singleton(name));
            return permissions.get(name);
        }

        @NotNull
        public Object[] getVariants() {
            Map<String, PsiElement> permissions = this.getPermissions(null);
            ArrayList<LookupElementBuilder> result2 = new ArrayList<LookupElementBuilder>(permissions.size());
            for (Map.Entry<String, PsiElement> entry : permissions.entrySet()) {
                String name = entry.getKey();
                String qualifiedName = AndroidPermissionConverter.PERMISSION_PREFIX + name;
                LookupElementBuilder builder2 = LookupElementBuilder.create((Object)entry.getValue(), (String)qualifiedName).withCaseSensitivity(true);
                builder2 = builder2.withLookupString(name);
                result2.add(builder2);
            }
            return ArrayUtil.toObjectArray(result2);
        }

        @NotNull
        private Map<String, PsiElement> getPermissions(@Nullable Set<String> filter2) {
            Map<String, ApiMember> removedFieldMap;
            List<ApiMember> removedFields;
            Project project = this.getElement().getProject();
            ApiLookup apiLookup = LintIdeClient.getApiLookup((Project)project);
            Collection<Object> collection2 = removedFields = apiLookup == null ? Collections.emptyList() : apiLookup.getRemovedFields(AndroidPermissionConverter.PERMISSION_CLASS_NAME_FOR_API_LOOKUP);
            if (removedFields == null || removedFields.isEmpty()) {
                removedFieldMap = Collections.emptyMap();
            } else {
                removedFieldMap = new HashMap();
                for (ApiMember field2 : removedFields) {
                    removedFieldMap.put(field2.getSignature(), field2);
                }
            }
            TreeMap<String, PsiElement> result2 = new TreeMap<String, PsiElement>();
            for (PsiField field3 : this.myPermissionClass.getFields()) {
                String fieldName;
                ApiMember removedField;
                if (!field3.hasModifierProperty("static") || !field3.hasModifierProperty("public") || !((removedField = (ApiMember)removedFieldMap.remove(fieldName = field3.getName())) == null ? this.isApplicable(field3, apiLookup) : this.isApplicable(removedField)) || filter2 != null && !filter2.contains(fieldName)) continue;
                result2.put(fieldName, (PsiElement)field3);
            }
            for (ApiMember removedField : removedFieldMap.values()) {
                if (!this.isApplicable(removedField)) continue;
                String fieldName = removedField.getSignature();
                if (filter2 != null && !filter2.contains(fieldName)) continue;
                RemovedApiField field2 = new RemovedApiField(fieldName, this.myPermissionClass, removedField.getSince(), removedField.getRemovedIn(), removedField.getRemovedIn());
                result2.put(fieldName, (PsiElement)field2);
            }
            return result2;
        }

        private boolean isApplicable(@NotNull ApiMember removedField) {
            return removedField.getSince() <= this.myMaxVersion && removedField.getRemovedIn() > this.myMinVersion;
        }

        private boolean isApplicable(@NotNull PsiField field2, @Nullable ApiLookup apiLookup) {
            return apiLookup == null || apiLookup.getFieldVersions(AndroidPermissionConverter.PERMISSION_CLASS_NAME_FOR_API_LOOKUP, field2.getName()).min() <= this.myMaxVersion;
        }
    }
}

