/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceRepositoryToPsiResolver;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.dom.converters.AndroidConstraintIdsConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J5\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0016\u0010\f\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e\u0018\u00010\rH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0014J'\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/android/dom/converters/AndroidConstraintIdsConverter;", "Lcom/intellij/util/xml/converters/DelimitedListConverter;", "Lcom/android/ide/common/rendering/api/ResourceReference;", "()V", "convertString", "string", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "getReferenceVariants", "", "", "genericDomValue", "Lcom/intellij/util/xml/GenericDomValue;", "", "(Lcom/intellij/util/xml/ConvertContext;Lcom/intellij/util/xml/GenericDomValue;)[Ljava/lang/Object;", "getUnresolvedMessage", "value", "pickMostRelevantId", "Lcom/intellij/psi/ResolveResult;", "resolveResultList", "([Lcom/intellij/psi/ResolveResult;Lcom/intellij/util/xml/ConvertContext;)Lcom/intellij/psi/ResolveResult;", "resolveReference", "Lcom/intellij/psi/PsiElement;", "resourceReference", "toString", "intellij.android.core"})
public final class AndroidConstraintIdsConverter
extends DelimitedListConverter<ResourceReference> {
    public AndroidConstraintIdsConverter() {
        super(", ");
    }

    @Nullable
    protected ResourceReference convertString(@Nullable String string, @Nullable ConvertContext context2) {
        if (string == null) {
            return null;
        }
        return new ResourceReference(ResourceNamespace.RES_AUTO, ResourceType.ID, string);
    }

    @Nullable
    protected String toString(@Nullable ResourceReference value2) {
        ResourceReference resourceReference = value2;
        return resourceReference != null ? resourceReference.getName() : null;
    }

    @NotNull
    protected Object[] getReferenceVariants(@Nullable ConvertContext context2, @Nullable GenericDomValue<? extends List<ResourceReference>> genericDomValue) {
        ConvertContext convertContext = context2;
        if (convertContext == null || (convertContext = convertContext.getFile()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)DelimitedListConverter.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return DelimitedListConverter.EMPTY_ARRAY;
        }
        ConvertContext file2 = convertContext;
        Object[] objectArray = IdeResourcesUtil.findIdUrlsInFile((PsiFile)file2).stream().map(getReferenceVariants.1.INSTANCE).toArray();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findIdUrlsInFile(file).s\u2026ate(name)\n    }.toArray()");
        return objectArray;
    }

    @Nullable
    protected PsiElement resolveReference(@Nullable ResourceReference resourceReference, @Nullable ConvertContext context2) {
        if (resourceReference == null || context2 == null || context2.getReferenceXmlElement() == null) {
            return null;
        }
        Module module2 = context2.getModule();
        if (module2 == null || (module2 = ModuleExtensionsKt.getAndroidFacet((Module)module2)) == null) {
            return null;
        }
        Module facet2 = module2;
        AndroidResourceToPsiResolver androidResourceToPsiResolver = AndroidResourceToPsiResolver.getInstance();
        ResourceRepositoryToPsiResolver resourceRepositoryToPsiResolver = androidResourceToPsiResolver instanceof ResourceRepositoryToPsiResolver ? (ResourceRepositoryToPsiResolver)androidResourceToPsiResolver : null;
        if (resourceRepositoryToPsiResolver == null) {
            return null;
        }
        ResourceRepositoryToPsiResolver resourceToPsiResolver = resourceRepositoryToPsiResolver;
        XmlElement xmlElement = context2.getReferenceXmlElement();
        Intrinsics.checkNotNull((Object)xmlElement);
        ResolveResult[] resolveResultList = resourceToPsiResolver.resolveReference(resourceReference, (PsiElement)xmlElement, (AndroidFacet)facet2, false);
        ResolveResult resolveResult = this.pickMostRelevantId(resolveResultList, context2);
        return resolveResult != null ? resolveResult.getElement() : null;
    }

    @NotNull
    protected String getUnresolvedMessage(@Nullable String value2) {
        Object[] objectArray = new Object[]{value2};
        String string = AnalysisBundle.message((String)"error.cannot.resolve.default.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"error.cannot.re\u2026.default.message\", value)");
        return string;
    }

    private final ResolveResult pickMostRelevantId(ResolveResult[] resolveResultList, ConvertContext context2) {
        Sequence sequence = ArraysKt.asSequence((Object[])resolveResultList);
        Comparator comparator2 = Comparator.comparing(new Function(context2){
            final /* synthetic */ ConvertContext $context;
            {
                this.$context = $context;
            }

            public final Boolean apply(ResolveResult it) {
                PsiElement psiElement = it.getElement();
                return !Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getContainingFile() : null), (Object)this.$context.getFile());
            }
        }).thenComparing(Comparator.comparing(pickMostRelevantId.2.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"context: ConvertContext)\u2026ROID + RESOURCE_CLZ_ID })");
        return (ResolveResult)SequencesKt.minWithOrNull((Sequence)sequence, comparator2);
    }
}

