/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.base.CommentTrackingXmlPullParser;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.attrs.StyleableDefinitionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class AttributeDefinitionsImpl
implements AttributeDefinitions {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl");
    private static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').trimResults();
    @NotNull
    private final Map<ResourceReference, AttributeDefinition> myAttrs = new HashMap<ResourceReference, AttributeDefinition>();
    @NotNull
    private final Map<ResourceReference, StyleableDefinitionImpl> myStyleables = new HashMap<ResourceReference, StyleableDefinitionImpl>();
    @Nullable
    private final AttributeDefinitions myFrameworkAttributeDefinitions;

    private AttributeDefinitionsImpl(@Nullable AttributeDefinitions frameworkAttributeDefinitions) {
        this.myFrameworkAttributeDefinitions = frameworkAttributeDefinitions;
    }

    @NotNull
    public static AttributeDefinitions parseFrameworkFiles(File ... files2) {
        AttributeDefinitionsImpl attributeDefinitions = new AttributeDefinitionsImpl(null);
        for (File file2 : files2) {
            attributeDefinitions.addAttrsFromFile(file2);
        }
        return attributeDefinitions;
    }

    @NotNull
    public static AttributeDefinitions create(@Nullable AttributeDefinitions frameworkAttributeDefinitions, @NotNull ResourceRepository resources2) {
        AttributeDefinitionsImpl attributeDefinitions = new AttributeDefinitionsImpl(frameworkAttributeDefinitions);
        attributeDefinitions.initializeFromResourceRepository(resources2);
        return attributeDefinitions;
    }

    private void initializeFromResourceRepository(@NotNull ResourceRepository resources2) {
        ResourceValue resourceValue;
        Collection items2;
        for (ResourceNamespace namespace : resources2.getNamespaces()) {
            items2 = resources2.getResources(namespace, ResourceType.ATTR).values();
            for (ResourceItem item2 : items2) {
                resourceValue = item2.getResourceValue();
                if (!(resourceValue instanceof AttrResourceValue)) continue;
                this.createOrUpdateAttributeDefinition((AttrResourceValue)resourceValue, null);
            }
        }
        for (ResourceNamespace namespace : resources2.getNamespaces()) {
            items2 = resources2.getResources(namespace, ResourceType.STYLEABLE).values();
            for (ResourceItem item2 : items2) {
                resourceValue = item2.getResourceValue();
                if (!(resourceValue instanceof StyleableResourceValue)) continue;
                StyleableResourceValue styleableValue = (StyleableResourceValue)resourceValue;
                ResourceReference reference = styleableValue.asReference();
                StyleableDefinitionImpl styleable = this.myStyleables.computeIfAbsent(reference, ref -> new StyleableDefinitionImpl(namespace, styleableValue.getName()));
                for (AttrResourceValue attrValue : styleableValue.getAllAttributes()) {
                    this.createOrUpdateAttributeDefinition(attrValue, styleable);
                }
            }
        }
    }

    private void createOrUpdateAttributeDefinition(@NotNull AttrResourceValue attrValue, @Nullable StyleableDefinitionImpl parentStyleable) {
        String groupName;
        String description2;
        ResourceReference attrRef = attrValue.asReference();
        AttributeDefinition attr = this.myAttrs.get(attrRef);
        if (attr == null) {
            if (this.myFrameworkAttributeDefinitions != null && attrValue.getNamespace().equals((Object)ResourceNamespace.ANDROID) && (attr = this.myFrameworkAttributeDefinitions.getAttrDefinition(attrRef)) != null) {
                attr = new AttributeDefinition(attr);
            }
            if (attr == null) {
                attr = new AttributeDefinition(attrValue.getNamespace(), attrValue.getName(), attrValue.getLibraryName(), null);
            }
            this.myAttrs.put(attrRef, attr);
        }
        attr.addFormats(attrValue.getFormats());
        Map valueMappings = attrValue.getAttributeValues();
        if (!valueMappings.isEmpty()) {
            attr.setValueMappings(valueMappings);
            HashMap valueDescriptions = Maps.newHashMapWithExpectedSize((int)valueMappings.size());
            for (String value2 : valueMappings.keySet()) {
                String description3 = attrValue.getValueDescription(value2);
                if (description3 == null) continue;
                valueDescriptions.put(value2, description3);
            }
            if (!valueDescriptions.isEmpty()) {
                attr.setValueDescriptions(valueDescriptions);
            }
        }
        if ((description2 = attrValue.getDescription()) != null) {
            attr.setDescription(description2, parentStyleable == null ? null : parentStyleable.getResourceReference());
        }
        if ((groupName = attrValue.getGroupName()) != null) {
            attr.setGroupName(groupName);
        }
        if (parentStyleable != null) {
            parentStyleable.addAttribute(attr);
        }
    }

    private void addAttrsFromFile(@NotNull File file2) {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file2));){
            int event;
            CommentTrackingXmlPullParser parser2 = new CommentTrackingXmlPullParser();
            parser2.setInput((InputStream)stream, null);
            StyleableDefinitionImpl styleable = null;
            do {
                event = parser2.nextToken();
                int depth = parser2.getDepth();
                block4 : switch (event) {
                    case 2: {
                        String tagName = parser2.getName();
                        if (depth == 1) {
                            if (tagName.equals("resources")) break;
                            return;
                        }
                        if (depth <= 1) break;
                        switch (tagName) {
                            case "attr": {
                                this.processAttrTag((XmlPullParser)parser2, file2, parser2.getLastComment(), parser2.getAttrGroupComment(), styleable);
                                break block4;
                            }
                            case "declare-styleable": {
                                if (styleable != null) {
                                    LOG.info("Found nested declare-styleable tag at " + file2.getAbsolutePath() + " line " + parser2.getLineNumber());
                                    break block4;
                                }
                                String styleableName = parser2.getAttributeValue(null, "name");
                                if (styleableName == null) {
                                    LOG.info("Found declare-styleable tag with no name at " + file2.getAbsolutePath() + " line " + parser2.getLineNumber());
                                    break block4;
                                }
                                styleable = new StyleableDefinitionImpl(ResourceNamespace.ANDROID, styleableName);
                                this.myStyleables.put(styleable.getResourceReference(), styleable);
                                break block4;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!parser2.getName().equals("declare-styleable")) break;
                        styleable = null;
                    }
                }
            } while (event != 1);
        }
        catch (IOException | XmlPullParserException e) {
            LOG.warn("Failed to parse " + file2.getAbsolutePath(), e);
        }
    }

    private void processAttrTag(@NotNull XmlPullParser parser2, @NotNull File file2, @Nullable String precedingComment, @Nullable String attrGroup, @Nullable StyleableDefinitionImpl parentStyleable) throws IOException, XmlPullParserException {
        int event;
        String attrName = parser2.getAttributeValue(null, "name");
        if (attrName == null) {
            LOG.info("Found attr tag with no name at " + file2.getAbsolutePath() + " line " + parser2.getLineNumber());
            return;
        }
        if (attrName.startsWith("android:")) {
            attrName = attrName.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
        }
        if (attrName.indexOf(58) >= 0) {
            LOG.info("Found attr tag with an invalid name at " + file2.getAbsolutePath() + " line " + parser2.getLineNumber());
            return;
        }
        AttributeDefinition attrDef = this.myAttrs.get(ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)attrName));
        if (attrDef == null) {
            attrDef = new AttributeDefinition(ResourceNamespace.ANDROID, attrName, null, null);
            attrDef.setGroupName(attrGroup);
            this.myAttrs.put(attrDef.getResourceReference(), attrDef);
        }
        if (parentStyleable != null) {
            parentStyleable.addAttribute(attrDef);
        }
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        String format = parser2.getAttributeValue(null, "format");
        if (format != null) {
            formats.addAll(AttributeDefinitionsImpl.parseAttrFormat(format));
        }
        HashMap<String, Integer> valueMappings = null;
        HashMap<String, String> valueDescriptions = null;
        String lastComment = null;
        int attrTagDepth = parser2.getDepth();
        do {
            event = parser2.nextToken();
            switch (event) {
                case 2: {
                    Integer intValue;
                    String tagName = parser2.getName();
                    if (tagName.equals("enum") && !formats.contains(AttributeFormat.FLAGS)) {
                        formats.add(AttributeFormat.ENUM);
                    } else if (tagName.equals("flag") && !formats.contains(AttributeFormat.ENUM)) {
                        formats.add(AttributeFormat.FLAGS);
                    }
                    String valueName = parser2.getAttributeValue(null, "name");
                    if (valueName == null) {
                        LOG.info("Unknown value for tag: " + tagName);
                        break;
                    }
                    String strIntValue = parser2.getAttributeValue(null, "value");
                    Integer n = intValue = strIntValue == null ? null : AttributeDefinitionsImpl.decodeIntegerValue(strIntValue);
                    if (valueMappings == null) {
                        valueMappings = new HashMap<String, Integer>();
                    }
                    valueMappings.putIfAbsent(valueName, intValue);
                    if (lastComment != null) {
                        if (valueDescriptions == null) {
                            valueDescriptions = new HashMap<String, String>();
                        }
                        valueDescriptions.putIfAbsent(valueName, lastComment);
                    }
                    lastComment = null;
                    break;
                }
                case 9: {
                    String commentText = parser2.getText().trim();
                    if (AttributeDefinitionsImpl.isEmptyOrAsciiArt(commentText)) break;
                    lastComment = commentText;
                    break;
                }
            }
        } while (event != 3 || parser2.getDepth() > attrTagDepth);
        attrDef.addFormats(formats);
        if (precedingComment != null) {
            attrDef.setDescription(precedingComment, parentStyleable == null ? null : parentStyleable.getResourceReference());
        }
        if (valueMappings != null) {
            attrDef.setValueMappings(valueMappings);
        }
        if (valueDescriptions != null) {
            attrDef.setValueDescriptions(valueDescriptions);
        }
    }

    @Nullable
    private static Integer decodeIntegerValue(@NotNull String value2) {
        try {
            return Long.decode(value2).intValue();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean isEmptyOrAsciiArt(@NotNull String commentText) {
        return commentText.isEmpty() || commentText.charAt(0) == '*' || commentText.charAt(0) == '=';
    }

    @NotNull
    private static Set<AttributeFormat> parseAttrFormat(@NotNull String formatString) {
        List formats = PIPE_SPLITTER.splitToList((CharSequence)formatString);
        EnumSet<AttributeFormat> result2 = EnumSet.noneOf(AttributeFormat.class);
        for (String format : formats) {
            AttributeFormat attributeFormat = AttributeFormat.fromXmlName((String)format);
            if (attributeFormat == null) continue;
            result2.add(attributeFormat);
        }
        return result2;
    }

    @Override
    @Nullable
    public StyleableDefinition getStyleableDefinition(@NotNull ResourceReference styleable) {
        if (this.myFrameworkAttributeDefinitions != null && styleable.getNamespace().equals((Object)ResourceNamespace.ANDROID)) {
            return this.myFrameworkAttributeDefinitions.getStyleableDefinition(styleable);
        }
        return this.myStyleables.get(styleable);
    }

    @Override
    @Deprecated
    @Nullable
    public StyleableDefinition getStyleableByName(@NotNull String name) {
        StyleableDefinition styleable = this.getStyleableDefinition(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.TODO(), (String)name));
        if (styleable == null) {
            styleable = this.getStyleableDefinition(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.ANDROID, (String)name));
        }
        return styleable;
    }

    @Override
    @NotNull
    public Set<ResourceReference> getAttrs() {
        return this.myAttrs.keySet();
    }

    @Override
    @Nullable
    public AttributeDefinition getAttrDefinition(@NotNull ResourceReference attr) {
        AttributeDefinition attributeDefinition = this.myAttrs.get(attr);
        if (attributeDefinition == null && this.myFrameworkAttributeDefinitions != null && attr.getNamespace().equals((Object)ResourceNamespace.ANDROID)) {
            return this.myFrameworkAttributeDefinitions.getAttrDefinition(attr);
        }
        return attributeDefinition;
    }

    @Override
    @Deprecated
    @Nullable
    public AttributeDefinition getAttrDefByName(@NotNull String name) {
        ResourceReference attr = name.startsWith("android:") ? ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN)) : (this.myFrameworkAttributeDefinitions == null ? ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)name) : ResourceReference.attr((ResourceNamespace)ResourceNamespace.TODO(), (String)name));
        return this.getAttrDefinition(attr);
    }

    @Override
    @Nullable
    public String getAttrGroup(@NotNull ResourceReference attr) {
        AttributeDefinition attributeDefinition = this.getAttrDefinition(attr);
        return attributeDefinition == null ? null : attributeDefinition.getGroupName();
    }
}

