/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.utils.Pair;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.annotations.NotNull;

public class XmlTagInnerClassInsertHandler
implements InsertHandler<LookupElement> {
    public static final XmlTagInnerClassInsertHandler INSTANCE = new XmlTagInnerClassInsertHandler();

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item2) {
        XmlAttributeDescriptor[] attributes;
        Project project = context2.getProject();
        Editor editor = context2.getEditor();
        Document document2 = editor.getDocument();
        PsiElement invalidElement = context2.getFile().findElementAt(context2.getStartOffset());
        if (invalidElement == null) {
            return;
        }
        XmlTag invalidTag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)invalidElement, XmlTag.class, (boolean)true);
        if (invalidTag == null) {
            return;
        }
        XmlElementDescriptor descriptor2 = invalidTag.getDescriptor();
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = attributes = descriptor2 != null ? descriptor2.getAttributesDescriptors(invalidTag) : null;
        if (!(item2.getObject() instanceof PsiClass)) {
            return;
        }
        PsiClass psiClass = (PsiClass)item2.getObject();
        String className = PackageClassConverter.getQualifiedName(psiClass);
        String replacement = "view class=\"" + className + "\"";
        int sOffset = invalidElement.getTextRange().getStartOffset();
        int eOffset = invalidElement.getTextRange().getEndOffset();
        document2.deleteString(sOffset, eOffset);
        document2.insertString(sOffset, (CharSequence)replacement);
        sOffset += replacement.length();
        if (context2.getCompletionChar() != '\r') {
            context2.setAddCompletionChar(false);
        }
        int caretOffset = -1;
        if (XmlUtil.getTokenOfType((PsiElement)invalidTag, (IElementType)XmlTokenType.XML_TAG_END) == null && XmlUtil.getTokenOfType((PsiElement)invalidTag, (IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END) == null) {
            int startIndent = XmlTagInnerClassInsertHandler.findStartIndent(document2, context2.getStartOffset() - 2);
            if (attributes != null) {
                Pair<Integer, Integer> result2 = XmlTagInnerClassInsertHandler.addRequiredAttributes(attributes, invalidTag, document2, sOffset, startIndent + 4);
                sOffset = (Integer)result2.getFirst();
                caretOffset = (Integer)result2.getSecond();
            }
            String indent = StringUtil.repeatSymbol((char)' ', (int)startIndent);
            Object endTag = XmlTagInnerClassInsertHandler.isLayout(psiClass) ? ">\n\n" + indent + "</view>" : "/>";
            document2.insertString(sOffset, (CharSequence)endTag);
            sOffset += ((String)endTag).length();
        } else if (context2.getCompletionChar() == '\t') {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiElement otherTag = PsiTreeUtil.getParentOfType((PsiElement)context2.getFile().findElementAt(context2.getStartOffset()), XmlTag.class);
            XmlToken endTagStart = XmlUtil.getTokenOfType((PsiElement)otherTag, (IElementType)XmlTokenType.XML_END_TAG_START);
            if (endTagStart != null) {
                PsiElement sibling = endTagStart.getNextSibling();
                assert (sibling != null);
                ASTNode node = sibling.getNode();
                assert (node != null);
                if (node.getElementType() == XmlTokenType.XML_NAME) {
                    sOffset = sibling.getTextRange().getStartOffset();
                    eOffset = sibling.getTextRange().getEndOffset();
                    document2.deleteString(sOffset, eOffset);
                    document2.insertString(sOffset, (CharSequence)((XmlTag)otherTag).getName());
                }
            }
        }
        if (caretOffset < 0) {
            caretOffset = sOffset;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        editor.getCaretModel().moveToOffset(caretOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    @NotNull
    private static Pair<Integer, Integer> addRequiredAttributes(@NotNull XmlAttributeDescriptor[] attributes, @NotNull XmlTag tag, @NotNull Document document2, int offset, int indentSize) {
        int cursorOffset = -1;
        String indent = StringUtil.repeatSymbol((char)' ', (int)indentSize);
        for (XmlAttributeDescriptor attribute : attributes) {
            String attributeName = attribute.getName((PsiElement)tag);
            if (!attribute.isRequired()) continue;
            String attrText = "\n" + indent + attributeName + "=\"\"";
            document2.insertString(offset, (CharSequence)attrText);
            offset += attrText.length();
            if (cursorOffset >= 0) continue;
            cursorOffset = offset - 1;
        }
        return Pair.of((Object)offset, (Object)cursorOffset);
    }

    private static boolean isLayout(@NotNull PsiClass psiClass) {
        HashSet<PsiClass> visited = new HashSet<PsiClass>();
        while (psiClass != null && visited.add(psiClass)) {
            if ("android.view.ViewGroup".equals(psiClass.getQualifiedName())) {
                return true;
            }
            psiClass = psiClass.getSuperClass();
        }
        return false;
    }

    private static int findStartIndent(@NotNull Document document2, int offset) {
        int indent = 0;
        CharSequence text2 = document2.getCharsSequence();
        while (offset > 0 && text2.charAt(offset) == ' ') {
            --offset;
            ++indent;
        }
        return indent;
    }
}

