/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.android.dom.ProvidedDocumentationPsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemovedApiField
extends ProvidedDocumentationPsiElement
implements PsiNamedElement {
    private static final String API_LEVELS_URL = "https://developer.android.com/guide/topics/manifest/uses-sdk-element.html#ApiLevels";
    private final String myName;
    private final PsiClass myContext;
    private final int mySince;
    private final int myDeprecatedIn;
    private final int myRemovedIn;

    public RemovedApiField(@NotNull String name, @NotNull PsiClass context2, int since, int deprecatedIn, int removedIn) {
        super(context2.getManager(), Language.ANY, name, "");
        this.myName = name;
        this.myContext = context2;
        this.mySince = since;
        this.myDeprecatedIn = deprecatedIn;
        this.myRemovedIn = removedIn;
    }

    public int getSince() {
        return this.mySince;
    }

    public int getDeprecatedIn() {
        return this.myDeprecatedIn;
    }

    public int getRemovedIn() {
        return this.myRemovedIn;
    }

    public boolean isEquivalentTo(PsiElement element2) {
        if (element2 == this) {
            return true;
        }
        if (!(element2 instanceof RemovedApiField)) {
            return false;
        }
        RemovedApiField other = (RemovedApiField)element2;
        return this.myName.equals(other.myName) && this.myContext.isEquivalentTo((PsiElement)other.myContext);
    }

    @NotNull
    public PsiElement getParent() {
        return this.myContext;
    }

    @Nullable
    public PsiFile getContainingFile() {
        return this.myContext.getContainingFile();
    }

    @Override
    @NotNull
    public String getDocumentation() {
        StringBuilder sb = new StringBuilder();
        sb.append("<HTML>\n");
        sb.append(String.format(Locale.US, "<p><b>%s</b>\n", this.myName));
        sb.append(String.format(Locale.US, "<p>Added in <a href=\"%s\">API level %d</a>\n", API_LEVELS_URL, this.mySince));
        if (this.myDeprecatedIn != 0 && this.myDeprecatedIn < this.myRemovedIn) {
            sb.append(String.format(Locale.US, "<br>Deprecated in <a href=\"%s\">API level %d</a>\n", API_LEVELS_URL, this.myDeprecatedIn));
        }
        sb.append(String.format(Locale.US, "<br>Removed in <a href=\"%s\">API level %d</a>\n", API_LEVELS_URL, this.myRemovedIn));
        sb.append("</HTML>\n");
        return sb.toString();
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.myName;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    public Icon getElementIcon(int flags) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RemovedApiField field2 = (RemovedApiField)((Object)o);
        return this.myName.equals(field2.myName) && this.myContext.equals(field2.myContext) && this.mySince == field2.mySince && this.myDeprecatedIn == field2.myDeprecatedIn && this.myRemovedIn == field2.myRemovedIn;
    }

    public int hashCode() {
        return 31 * this.myName.hashCode() + this.myContext.hashCode();
    }
}

