/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class FileDescriptionUtils {
    private FileDescriptionUtils() {
    }

    public static boolean isResourceOfTypeWithRootTag(@NotNull XmlFile file2, @NotNull ResourceFolderType folderType, @NotNull Collection<String> rootTags) {
        return (Boolean)ApplicationManager.getApplication().runReadAction(FileDescriptionUtils.newResourceTypeVerifier(file2, folderType, rootTags));
    }

    @NotNull
    private static Stream<XmlTag> asStream(@NotNull XmlTag rootTag) {
        return Stream.concat(Stream.of(rootTag), Arrays.stream(rootTag.getSubTags()).filter(XmlTag.class::isInstance).map(XmlTag.class::cast).flatMap(FileDescriptionUtils::asStream));
    }

    public static boolean isResourceOfTypeContainingTag(@NotNull XmlFile file2, @NotNull ResourceFolderType folderType, @NotNull Collection<String> tagNames) {
        Condition tagCondition = tagNames.isEmpty() ? Conditions.alwaysTrue() : rootTag -> rootTag != null && FileDescriptionUtils.asStream(rootTag).anyMatch(tag -> tagNames.contains(tag.getName()));
        return (Boolean)ApplicationManager.getApplication().runReadAction(FileDescriptionUtils.newResourceTypeVerifier(file2, folderType, (Condition<XmlTag>)tagCondition));
    }

    @NotNull
    private static Computable<Boolean> newResourceTypeVerifier(@NotNull XmlFile file2, @NotNull ResourceFolderType folderType, @NotNull Condition<XmlTag> tagVerifier) {
        return () -> {
            if (file2.getProject().isDisposed()) {
                return false;
            }
            if (!IdeResourcesUtil.isInResourceSubdirectoryInAnyVariant((PsiFile)file2, folderType.getName())) {
                return false;
            }
            XmlTag rootTag = file2.getRootTag();
            return tagVerifier.value((Object)rootTag);
        };
    }

    @NotNull
    @VisibleForTesting
    static Computable<Boolean> newResourceTypeVerifier(@NotNull XmlFile file2, @NotNull ResourceFolderType folderType, @NotNull Collection<String> rootTags) {
        return rootTags.isEmpty() ? FileDescriptionUtils.newResourceTypeVerifier(file2, folderType, (Condition<XmlTag>)Conditions.alwaysTrue()) : FileDescriptionUtils.newResourceTypeVerifier(file2, folderType, (Condition<XmlTag>)((Condition)element2 -> element2 != null && rootTags.contains(element2.getName())));
    }
}

