/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "charTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.android.core"})
public final class AndroidXmlTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char charTyped2, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        TypedHandlerDelegate.Result result2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (AndroidXmlTypedHandler.Companion.isSupportedSymbol(charTyped2) && file2 instanceof XmlFile) {
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, new Condition(file2, editor){
                final /* synthetic */ PsiFile $file;
                final /* synthetic */ Editor $editor;
                {
                    this.$file = $file;
                    this.$editor = $editor;
                }

                public final boolean value(PsiFile psiFile) {
                    AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)((PsiElement)this.$file));
                    if (androidFacet == null) {
                        return false;
                    }
                    AndroidFacet facet2 = androidFacet;
                    int caretOffset = this.$editor.getCaretModel().getOffset();
                    PsiElement psiElement = psiFile.findElementAt(caretOffset - 1);
                    if (psiElement == null) {
                        return false;
                    }
                    PsiElement lastElement = psiElement;
                    if (!org.jetbrains.android.dom.AndroidXmlTypedHandler$Companion.access$isSupportedSymbol(AndroidXmlTypedHandler.Companion, lastElement.getText().charAt(0))) {
                        return false;
                    }
                    if (!(psiFile instanceof XmlFile)) {
                        return false;
                    }
                    if (!ManifestDomFileDescription.isManifestFile((XmlFile)psiFile)) {
                        VirtualFile virtualFile = ((XmlFile)psiFile).getVirtualFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"psiFile.virtualFile");
                        if (!IdeResourcesUtil.isResourceFile(virtualFile, facet2)) {
                            return false;
                        }
                    }
                    if (!(lastElement.getParent() instanceof XmlAttributeValue) && !(lastElement.getParent() instanceof XmlText)) {
                        return false;
                    }
                    if (lastElement.getParent() instanceof XmlText && IdeResourcesUtil.getFolderType(psiFile) != ResourceFolderType.VALUES) {
                        return false;
                    }
                    return lastElement.getText().charAt(0) != '?' || IdeResourcesUtil.getFolderType(psiFile) == ResourceFolderType.LAYOUT;
                }
            });
            result2 = TypedHandlerDelegate.Result.STOP;
        } else {
            TypedHandlerDelegate.Result result3 = super.charTyped(charTyped2, project, editor, file2);
            result2 = result3;
            Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"{\n      super.charTyped(\u2026ject, editor, file)\n    }");
        }
        return result2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/android/dom/AndroidXmlTypedHandler$Companion;", "", "()V", "isSupportedSymbol", "", "charTyped", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSupportedSymbol(char charTyped2) {
            char c = charTyped2;
            return c == '@' ? true : c == '?';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

