/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidAnyTagDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlTagDescriptor
implements XmlElementDescriptor {
    private final XmlElementDescriptor myParentDescriptor;

    public AndroidXmlTagDescriptor(@NotNull XmlElementDescriptor parentDescriptor) {
        this.myParentDescriptor = parentDescriptor;
    }

    public String getQualifiedName() {
        return this.myParentDescriptor.getQualifiedName();
    }

    public String getDefaultName() {
        return this.myParentDescriptor.getDefaultName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context2) {
        return this.myParentDescriptor.getElementsDescriptors(context2);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlElementDescriptor descriptor2 = this.myParentDescriptor.getElementDescriptor(childTag, contextTag);
        if (descriptor2 != null) {
            return descriptor2;
        }
        XmlNSDescriptor nsDescriptor = this.getNSDescriptor();
        return nsDescriptor != null ? new AndroidAnyTagDescriptor(nsDescriptor) : null;
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context2) {
        return this.myParentDescriptor.getAttributesDescriptors(context2);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context2) {
        XmlAttributeDescriptor descriptor2 = this.myParentDescriptor.getAttributeDescriptor(attributeName, context2);
        return descriptor2 != null ? descriptor2 : new AndroidAnyAttributeDescriptor(attributeName);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        XmlAttributeDescriptor descriptor2 = this.myParentDescriptor.getAttributeDescriptor(attribute);
        return descriptor2 != null ? descriptor2 : new AndroidAnyAttributeDescriptor(attribute.getName());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myParentDescriptor.getNSDescriptor();
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return this.myParentDescriptor.getContentType();
    }

    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.myParentDescriptor.getDeclaration();
    }

    public String getName(PsiElement context2) {
        return this.getDefaultName();
    }

    public String getName() {
        return this.myParentDescriptor.getName();
    }

    public void init(PsiElement element2) {
        this.myParentDescriptor.init(element2);
    }

    @NotNull
    public Object[] getDependencies() {
        return this.myParentDescriptor.getDependencies();
    }
}

