/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProGuardConfigFilesPanel
extends JPanel {
    private final JBList myList;
    private CollectionListModel<String> myModel = new CollectionListModel((Object[])new String[0]);

    public ProGuardConfigFilesPanel() {
        super(new BorderLayout());
        this.myList = new JBList(this.myModel);
        ToolbarDecorator decorator2 = ToolbarDecorator.createDecorator((JList)this.myList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String path2 = ProGuardConfigFilesPanel.this.chooseFile();
                if (path2 != null) {
                    ProGuardConfigFilesPanel.this.myModel.add((Object)path2);
                }
            }
        });
        JPanel tablePanel = decorator2.setPreferredSize(new Dimension(-1, JBUI.scale((int)120))).createPanel();
        tablePanel.setMinimumSize(new Dimension(-1, JBUI.scale((int)120)));
        this.add((Component)tablePanel, "Center");
        JBLabel label = new JBLabel("Config file paths:");
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)5, (int)0));
        this.add((Component)label, "North");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component component2 : this.getComponents()) {
            UIUtil.setEnabled((Component)component2, (boolean)enabled, (boolean)true);
        }
    }

    private String chooseFile() {
        AndroidFacet facet2 = this.getFacet();
        if (facet2 == null) {
            return null;
        }
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        VirtualFile contentRoot = AndroidRootUtil.getMainContentRoot(facet2);
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Component)this, (Project)facet2.getModule().getProject(), (VirtualFile)contentRoot);
        return file2 != null ? FileUtil.toSystemDependentName((String)file2.getPath()) : null;
    }

    @NotNull
    public List<String> getUrls() {
        List<String> paths = this.getOsPaths();
        if (paths.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>(paths.size());
        for (String path2 : paths) {
            String url = VfsUtilCore.pathToUrl((String)path2);
            String sdkHome = this.getCanonicalSdkHome();
            if (sdkHome != null) {
                url = StringUtil.replace((String)url, (String)sdkHome, (String)"%MODULE_SDK_HOME%");
            }
            result2.add(url);
        }
        return result2;
    }

    @NotNull
    public List<String> getOsPaths() {
        return this.myModel.getItems();
    }

    public void setUrls(@NotNull List<String> urls) {
        this.setOsPaths(AndroidUtils.urlsToOsPaths(urls, this.getCanonicalSdkHome()));
    }

    public void setOsPaths(@NotNull List<String> paths) {
        this.myModel = new CollectionListModel(paths);
        this.myList.setModel(this.myModel);
    }

    @Nullable
    private String getCanonicalSdkHome() {
        AndroidFacet facet2 = this.getFacet();
        if (facet2 == null) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)facet2.getModule()).getSdk();
        if (sdk == null) {
            return null;
        }
        String homePath = sdk.getHomePath();
        return homePath != null ? FileUtil.toCanonicalPath((String)homePath) : null;
    }

    @Nullable
    protected abstract AndroidFacet getFacet();
}

