/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.res.AndroidDependenciesCache;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AndroidCompileUtil {
    private static final Key<Boolean> RELEASE_BUILD_KEY = new Key("RELEASE_BUILD_KEY");
    @NonNls
    public static final String OLD_PROGUARD_CFG_FILE_NAME = "proguard.cfg";
    public static Key<String> PROGUARD_CFG_PATHS_KEY = Key.create((String)"ANDROID_PROGUARD_CFG_PATHS");

    private AndroidCompileUtil() {
    }

    @Nullable
    public static Pair<VirtualFile, Boolean> getDefaultProguardConfigFile(@NotNull AndroidFacet facet2) {
        VirtualFile root = AndroidRootUtil.getMainContentRoot(facet2);
        if (root == null) {
            return null;
        }
        VirtualFile proguardCfg = root.findChild("proguard-project.txt");
        if (proguardCfg != null) {
            return new Pair((Object)proguardCfg, (Object)true);
        }
        VirtualFile oldProguardCfg = root.findChild(OLD_PROGUARD_CFG_FILE_NAME);
        if (oldProguardCfg != null) {
            return new Pair((Object)oldProguardCfg, (Object)false);
        }
        return null;
    }

    public static void setReleaseBuild(@NotNull CompileScope compileScope) {
        compileScope.putUserData(RELEASE_BUILD_KEY, (Object)Boolean.TRUE);
    }

    public static String getApkName(Module module2) {
        return module2.getName() + ".apk";
    }

    @Nullable
    public static String getOutputPackage(@NotNull Module module2) {
        VirtualFile compilerOutput = CompilerModuleExtension.getInstance((Module)module2).getCompilerOutputPath();
        if (compilerOutput == null) {
            return null;
        }
        return new File(compilerOutput.getPath(), AndroidCompileUtil.getApkName(module2)).getPath();
    }

    @Nullable
    public static Module findCircularDependencyOnLibraryWithSamePackage(@NotNull AndroidFacet facet2) {
        String aPackage;
        Manifest manifest = Manifest.getMainManifest(facet2);
        String string = aPackage = manifest != null ? (String)manifest.getPackage().getValue() : null;
        if (aPackage == null) {
            return null;
        }
        for (AndroidFacet depFacet : AndroidDependenciesCache.getAllAndroidDependencies(facet2.getModule(), true)) {
            List<AndroidFacet> depDependencies;
            Manifest depManifest = Manifest.getMainManifest(depFacet);
            String depPackage = depManifest != null ? (String)depManifest.getPackage().getValue() : null;
            if (!aPackage.equals(depPackage) || !(depDependencies = AndroidDependenciesCache.getAllAndroidDependencies(depFacet.getModule(), false)).contains(facet2)) continue;
            return depFacet.getModule();
        }
        return null;
    }

    @Nullable
    public static String getUnsignedApkPath(@NotNull AndroidFacet facet2) {
        String path2 = facet2.getProperties().APK_PATH;
        if (path2.isEmpty()) {
            return AndroidCompileUtil.getOutputPackage(facet2.getModule());
        }
        @SystemIndependent String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet2.getModule());
        return moduleDirPath != null ? FileUtil.toSystemDependentName((String)(moduleDirPath + path2)) : null;
    }

    @Nullable
    public static String getAaptManifestPackage(@NotNull AndroidFacet facet2) {
        if (facet2.getProperties().USE_CUSTOM_MANIFEST_PACKAGE) {
            return facet2.getProperties().CUSTOM_MANIFEST_PACKAGE;
        }
        Manifest manifest = Manifest.getMainManifest(facet2);
        return manifest != null ? manifest.getPackage().getStringValue() : null;
    }
}

