/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.Verify;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.AndroidLightInnerClassBase;
import org.jetbrains.android.augment.ResourceLightField;
import org.jetbrains.android.augment.StyleableAttrFieldUrl;
import org.jetbrains.android.augment.StyleableAttrLightField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InnerRClassBase
extends AndroidLightInnerClassBase {
    private static final Logger LOG = Logger.getInstance(InnerRClassBase.class);
    @NotNull
    protected final ResourceType myResourceType;
    @Nullable
    private CachedValue<PsiField[]> myFieldsCache;
    protected static final PsiType INT_ARRAY = PsiType.INT.createArrayType();
    protected static final Predicate<@NotNull ResourceItem> ACCESSIBLE_RESOURCE_FILTER = resource -> {
        if (!resource.getNamespace().equals((Object)ResourceNamespace.ANDROID) && resource.getLibraryName() == null) {
            return true;
        }
        if (resource instanceof ResourceItemWithVisibility) {
            return ((ResourceItemWithVisibility)resource).getVisibility() == ResourceVisibility.PUBLIC;
        }
        throw new AssertionError((Object)("Library resource " + resource.getType() + "/" + resource.getName() + " of type " + resource.getClass().getSimpleName() + " doesn't implement ResourceItemWithVisibility"));
    };

    public InnerRClassBase(@NotNull PsiClass context2, @NotNull ResourceType resourceType) {
        super(context2, resourceType.getName());
        this.myResourceType = resourceType;
    }

    protected static PsiField[] buildResourceFields(@NotNull ResourceRepository repository2, @NotNull ResourceNamespace namespace, @Nullable ResourceRepositoryManager resourceRepositoryManager, @NotNull AndroidLightField.FieldModifier fieldModifier, @NotNull Predicate<ResourceItem> resourceFilter, @NotNull ResourceType resourceType, @NotNull PsiClass context2) {
        LinkedHashMap<String, ResourceVisibility> otherFields = new LinkedHashMap<String, ResourceVisibility>();
        LinkedHashMap<String, ResourceVisibility> styleableFields = new LinkedHashMap<String, ResourceVisibility>();
        ArrayList<StyleableAttrFieldUrl> styleableAttrFields = new ArrayList<StyleableAttrFieldUrl>();
        ListMultimap map2 = repository2.getResources(namespace, resourceType);
        for (ResourceItem resource : map2.values()) {
            ResourceVisibility visibility;
            ResourceVisibility resourceVisibility = visibility = resourceFilter.test(resource) ? ResourceVisibility.PUBLIC : ResourceVisibility.PRIVATE;
            if (resourceType == ResourceType.STYLEABLE) {
                styleableFields.merge(resource.getName(), visibility, ResourceVisibility::max);
                StyleableResourceValue value2 = (StyleableResourceValue)resource.getResourceValue();
                if (value2 == null) continue;
                List attributes = value2.getAllAttributes();
                for (AttrResourceValue attr : attributes) {
                    ResourceItem attrResource;
                    List attrResources;
                    ResourceNamespace attrNamespace = attr.getNamespace();
                    ResourceRepository attrRepository = resourceRepositoryManager == null ? repository2 : resourceRepositoryManager.getResourcesForNamespace(attrNamespace);
                    if (attrRepository == null || (attrResources = attrRepository.getResources(attrNamespace, ResourceType.ATTR, attr.getName())).isEmpty() || !resourceFilter.test(attrResource = (ResourceItem)attrResources.get(0))) continue;
                    styleableAttrFields.add(new StyleableAttrFieldUrl(new ResourceReference(namespace, ResourceType.STYLEABLE, resource.getName()), new ResourceReference(attrNamespace, ResourceType.ATTR, attr.getName())));
                }
                continue;
            }
            otherFields.merge(resource.getName(), visibility, ResourceVisibility::max);
        }
        return InnerRClassBase.buildResourceFields(otherFields, styleableFields, styleableAttrFields, resourceType, context2, fieldModifier);
    }

    @NotNull
    protected static PsiField[] buildResourceFields(@NotNull Map<String, ResourceVisibility> otherFields, @NotNull Map<String, ResourceVisibility> styleableFields, @NotNull Collection<StyleableAttrFieldUrl> styleableAttrFields, @NotNull ResourceType resourceType, @NotNull PsiClass context2, @NotNull AndroidLightField.FieldModifier fieldModifier) {
        AndroidLightField field2;
        int fieldId;
        PsiField[] result2 = new PsiField[otherFields.size() + styleableFields.size() + styleableAttrFields.size()];
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)context2.getProject());
        int nextId = resourceType.ordinal() * 100000;
        int i = 0;
        for (Map.Entry<String, ResourceVisibility> entry : otherFields.entrySet()) {
            fieldId = nextId++;
            field2 = new ResourceLightField(entry.getKey(), context2, (PsiType)PsiType.INT, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(fieldId) : null, entry.getValue());
            field2.setInitializer(factory2.createExpressionFromText(Integer.toString(fieldId), (PsiElement)field2));
            result2[i++] = field2;
        }
        for (Map.Entry<String, ResourceVisibility> entry : styleableFields.entrySet()) {
            fieldId = nextId++;
            field2 = new ResourceLightField(entry.getKey(), context2, INT_ARRAY, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(fieldId) : null, entry.getValue());
            field2.setInitializer(factory2.createExpressionFromText(Integer.toString(fieldId), (PsiElement)field2));
            result2[i++] = field2;
        }
        for (StyleableAttrFieldUrl fieldContents : styleableAttrFields) {
            fieldId = nextId++;
            field2 = new StyleableAttrLightField(fieldContents, context2, fieldModifier, fieldModifier == AndroidLightField.FieldModifier.FINAL ? Integer.valueOf(fieldId) : null);
            field2.setInitializer(factory2.createExpressionFromText(Integer.toString(fieldId), (PsiElement)field2));
            result2[i++] = field2;
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (this.myFieldsCache == null) {
            this.myFieldsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                ModificationTracker dependencies2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Recomputing fields for " + this);
                }
                Verify.verify((!((dependencies2 = this.getFieldsDependencies()) instanceof ResourceRepository) ? 1 : 0) != 0, (String)"Resource repository leaked in a CachedValue.", (Object[])new Object[0]);
                return CachedValueProvider.Result.create((Object)this.doGetFields(), (Object[])new Object[]{dependencies2});
            });
        }
        return (PsiField[])this.myFieldsCache.getValue();
    }

    @Slow
    @NotNull
    protected abstract PsiField[] doGetFields();

    @NotNull
    protected abstract ModificationTracker getFieldsDependencies();

    @NotNull
    public ResourceType getResourceType() {
        return this.myResourceType;
    }
}

