/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.ExportEncryptedPrivateKeyTool;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class GenerateSignedApkAction
extends AnAction {
    public GenerateSignedApkAction() {
        super(AndroidBundle.message((Boolean)StudioFlags.RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED.get() != false ? "android.generate.signed.apk.action.bundle.text" : "android.generate.signed.apk.action.text", new Object[0]));
    }

    @VisibleForTesting
    static boolean allowBundleSigning(@Nullable Project project) {
        return project != null && (Boolean)StudioFlags.RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED.get() != false && !AndroidProjectInfo.getInstance(project).isApkProject();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        List<AndroidFacet> facets = ProjectSystemUtil.getAndroidFacets(project).stream().filter(facet2 -> ((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()).collect(Collectors.toList());
        assert (!facets.isEmpty());
        ExportSignedPackageWizard wizard = new ExportSignedPackageWizard(project, facets, true, GenerateSignedApkAction.allowBundleSigning(project), new ExportEncryptedPrivateKeyTool());
        wizard.show();
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean enabled = project != null && !AndroidUtils.getApplicationFacets(project).isEmpty() && (GradleProjectInfo.getInstance(project).isBuildWithGradle() || !ProjectSystemUtil.requiresAndroidModel(project));
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            String actionText = GenerateSignedApkAction.allowBundleSigning(project) ? "android.generate.signed.apk.action.bundle.text" : "android.generate.signed.apk.action.text";
            e.getPresentation().setText(AndroidBundle.message(actionText, new Object[0]));
        }
    }
}

