/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.font.FontUtil;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.TextFieldWithBooleanBoxKt;
import com.android.tools.idea.ui.TextFieldWithColorPickerKt;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.actions.CreateXmlResourceSubdirPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateXmlResourcePanelImpl
implements CreateXmlResourcePanel,
CreateXmlResourceSubdirPanel.Parent {
    private JPanel myPanel;
    private JTextField myNameField;
    private ModulesComboBox myModuleCombo;
    private JBLabel myModuleLabel;
    private JPanel myValueFieldContainer;
    private JBLabel myValueLabel;
    private JBLabel myNameLabel;
    private JComboBox myFileNameCombo;
    private JBLabel mySourceSetLabel;
    private JComboBox mySourceSetCombo;
    private JBLabel myFileNameLabel;
    @Nullable
    private final Module myModule;
    @NotNull
    private final ResourceType myResourceType;
    @NotNull
    private final ResourceFolderType myFolderType;
    private JPanel myDirectoriesPanel;
    private JBLabel myDirectoriesLabel;
    private JTextComponent myValueField;
    private CreateXmlResourceSubdirPanel mySubdirPanel;
    private IdeResourceNameValidator myResourceNameValidator;

    public CreateXmlResourcePanelImpl(@NotNull Module module2, @NotNull ResourceType resourceType, @NotNull ResourceFolderType folderType, @Nullable String resourceName, @Nullable String resourceValue, boolean chooseName, boolean chooseValue, boolean chooseFilename, @Nullable VirtualFile defaultFile, @Nullable VirtualFile contextFile, @NotNull Function<Module, IdeResourceNameValidator> nameValidatorFactory) {
        String defaultFileName;
        this.myResourceType = resourceType;
        this.$$$setupUI$$$();
        this.setChangeNameVisible(false);
        this.setChangeValueVisible(false);
        this.setChangeFileNameVisible(chooseFilename);
        this.myFolderType = folderType;
        if (chooseName) {
            this.setChangeNameVisible(true);
            resourceName = IdeResourcesUtil.prependResourcePrefix(module2, resourceName, folderType);
        }
        if (!StringUtil.isEmpty((String)resourceName)) {
            this.myNameField.setText(resourceName);
        }
        if (resourceType == ResourceType.COLOR) {
            Color defaultColor = IdeResourcesUtil.parseColor(resourceValue);
            this.myValueFieldContainer.removeAll();
            this.myValueFieldContainer.add(TextFieldWithColorPickerKt.wrapWithColorPickerIcon((JTextField)this.myValueField, defaultColor));
        } else if (resourceType == ResourceType.BOOL) {
            this.myValueFieldContainer.removeAll();
            this.myValueFieldContainer.add(TextFieldWithBooleanBoxKt.wrapWithBooleanCheckBox((JTextField)this.myValueField, Boolean.parseBoolean(resourceValue)));
        }
        if (chooseValue) {
            this.myValueField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent event) {
                    CreateXmlResourcePanelImpl.this.myValueField.setFont(FontUtil.getFontAbleToDisplay((String)CreateXmlResourcePanelImpl.this.myValueField.getText(), (Font)CreateXmlResourcePanelImpl.this.myValueField.getFont()));
                }
            });
            this.setChangeValueVisible(true);
            if (!StringUtil.isEmpty((String)resourceValue)) {
                this.myValueField.setText(resourceValue);
            }
        }
        HashSet<Module> modulesSet = new HashSet<Module>();
        modulesSet.add(module2);
        for (AndroidFacet depFacet : AndroidDependenciesCache.getAllAndroidDependencies(module2, true)) {
            modulesSet.add(depFacet.getModule());
        }
        assert (!modulesSet.isEmpty());
        this.myModuleCombo.setModules(modulesSet);
        this.myModuleCombo.setSelectedModule(module2);
        if (modulesSet.size() == 1) {
            this.myModule = module2;
            this.setChangeModuleVisible(false);
        } else {
            this.myModule = null;
        }
        this.myModuleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateResourceDialogUtils.updateSourceSetCombo((JComponent)CreateXmlResourcePanelImpl.this.mySourceSetLabel, CreateXmlResourcePanelImpl.this.mySourceSetCombo, AndroidFacet.getInstance((Module)CreateXmlResourcePanelImpl.this.getModule()), null);
            }
        });
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CreateResourceDialogUtils.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, AndroidFacet.getInstance((Module)this.getModule()), null);
        if (defaultFile == null && (defaultFileName = IdeResourcesUtil.getDefaultResourceFileName(this.myResourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.myDirectoriesLabel.setLabelFor((Component)this.myDirectoriesPanel);
        this.mySubdirPanel = new CreateXmlResourceSubdirPanel(module2.getProject(), folderType, this.myDirectoriesPanel, this);
        this.myResourceNameValidator = nameValidatorFactory.apply(this.getModule());
        this.myModuleCombo.addActionListener(e -> {
            this.mySubdirPanel.updateDirectories(true, this.getResourceDirectory());
            this.myResourceNameValidator = (IdeResourceNameValidator)nameValidatorFactory.apply(this.getModule());
        });
        if (defaultFile != null) {
            this.resetFromFile(defaultFile, module2.getProject());
        }
    }

    private void createUIComponents() {
        this.myValueFieldContainer = new JPanel();
        this.myValueFieldContainer.setFocusable(false);
        this.myValueFieldContainer.setLayout(new BoxLayout(this.myValueFieldContainer, 1));
        this.myValueFieldContainer.setUI(null);
        this.myValueFieldContainer.setOpaque(false);
        if (this.myResourceType == ResourceType.STRING) {
            JTextArea textArea = new JTextArea();
            textArea.setRows(3);
            this.myValueField = textArea;
            JBScrollPane scrollPane = new JBScrollPane((Component)textArea);
            this.setupBordersForTextArea(textArea, this.myValueFieldContainer);
            this.myValueFieldContainer.add((Component)scrollPane);
        } else {
            this.myValueField = new JTextField();
            this.myValueFieldContainer.setBorder((Border)JBUI.Borders.empty());
            this.myValueFieldContainer.add(this.myValueField);
        }
        this.myValueField.setName("Resource value area");
    }

    private void setupBordersForTextArea(@NotNull JTextArea textArea, final @NotNull JPanel containingPanel) {
        Border empty1pixel = JBUI.Borders.empty((int)1);
        Border empty3pixel = JBUI.Borders.empty((int)3);
        Border unfocusedLine = JBUI.Borders.customLine((Color)JBColor.border(), (int)1);
        Border focusedLine = JBUI.Borders.customLine((Color)UIUtil.getFocusedBorderColor(), (int)2);
        final Border unfocusedBorder = JBUI.Borders.merge((Border)empty3pixel, (Border)unfocusedLine, (boolean)false);
        final Border focusedBorder = JBUI.Borders.merge((Border)empty1pixel, (Border)JBUI.Borders.merge((Border)focusedLine, (Border)unfocusedLine, (boolean)false), (boolean)false);
        textArea.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                containingPanel.setBorder(focusedBorder);
            }

            @Override
            public void focusLost(FocusEvent e) {
                containingPanel.setBorder(unfocusedBorder);
            }
        });
        textArea.setBorder((Border)JBUI.Borders.empty((int)1, (int)4));
        containingPanel.setBorder(unfocusedBorder);
    }

    @Override
    public void resetToDefault() {
        String defaultFileName;
        if (this.myModule == null) {
            this.myModuleCombo.setSelectedModule(this.getRootModule());
        }
        if ((defaultFileName = IdeResourcesUtil.getDefaultResourceFileName(this.myResourceType)) != null) {
            this.myFileNameCombo.getEditor().setItem(defaultFileName);
        }
        this.mySubdirPanel.resetToDefault();
    }

    @NotNull
    private Module getRootModule() {
        assert (this.myModule == null);
        ComboBoxModel model2 = this.myModuleCombo.getModel();
        Module root = null;
        int moduleDependencyCount = -1;
        for (int c = 0; c < model2.getSize(); ++c) {
            Module otherModule = (Module)model2.getElementAt(c);
            int otherModuleDependencyCount = AndroidDependenciesCache.getAllAndroidDependencies(otherModule, true).size();
            if (otherModuleDependencyCount <= moduleDependencyCount) continue;
            moduleDependencyCount = otherModuleDependencyCount;
            root = otherModule;
        }
        assert (root != null);
        return root;
    }

    @Override
    public void resetFromFile(@NotNull VirtualFile file2, @NotNull Project project) {
        Module moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project);
        if (moduleForFile == null) {
            return;
        }
        VirtualFile parent2 = file2.getParent();
        if (parent2 == null) {
            return;
        }
        if (this.myModule == null) {
            Module prev = this.myModuleCombo.getSelectedModule();
            this.myModuleCombo.setSelectedItem((Object)moduleForFile);
            if (!moduleForFile.equals(this.myModuleCombo.getSelectedItem())) {
                this.myModuleCombo.setSelectedModule(prev);
                return;
            }
        } else if (!this.myModule.equals(moduleForFile)) {
            return;
        }
        this.mySubdirPanel.resetFromFile(parent2);
        this.myFileNameCombo.getEditor().setItem(file2.getName());
        this.myPanel.repaint();
    }

    @Override
    public ValidationInfo doValidate() {
        List<ResourceItem> resources2;
        String resourceName = this.getResourceName();
        String resourceValue = this.getValue();
        Module selectedModule = this.getModule();
        VirtualFile resourceDir = this.getResourceDirectory();
        List<String> directoryNames = this.getDirNames();
        String fileName = this.getFileName();
        if (this.myNameField.isVisible() && resourceName.isEmpty()) {
            return new ValidationInfo("specify resource name", (JComponent)this.myNameField);
        }
        if (this.myNameField.isVisible() && !IdeResourcesUtil.isCorrectAndroidResourceName(resourceName)) {
            return new ValidationInfo(resourceName + " is not a correct resource name", (JComponent)this.myNameField);
        }
        if (fileName.isEmpty()) {
            return new ValidationInfo("specify file name", (JComponent)this.myFileNameCombo);
        }
        if (selectedModule == null) {
            return new ValidationInfo("specify module", (JComponent)this.myModuleCombo);
        }
        if (resourceDir == null) {
            return new ValidationInfo("specify a module with resources", (JComponent)this.myModuleCombo);
        }
        if (directoryNames.isEmpty()) {
            return new ValidationInfo("choose directories", (JComponent)this.myDirectoriesPanel);
        }
        if (resourceName.equals(IdeResourcesUtil.prependResourcePrefix(this.myModule, null, this.myFolderType))) {
            return new ValidationInfo("specify more than resource prefix", (JComponent)this.myNameField);
        }
        LocalResourceRepository moduleResources = ResourceRepositoryManager.getModuleResources(selectedModule);
        if (moduleResources != null && !(resources2 = moduleResources.getResources(ResourceNamespace.RES_AUTO, this.myResourceType, resourceName)).isEmpty()) {
            return new ValidationInfo(resourceName + " is a resource that already exists", (JComponent)this.myNameField);
        }
        return CreateXmlResourceDialog.checkIfResourceAlreadyExists(selectedModule.getProject(), resourceDir, resourceName, resourceValue, this.myResourceType, directoryNames, fileName);
    }

    @Override
    @NotNull
    public IdeResourceNameValidator getResourceNameValidator() {
        return this.myResourceNameValidator;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        String name = this.myNameField.getText();
        if (name.isEmpty() || this.myValueField.isVisible() && !this.myValueField.getText().isEmpty() || name.equals(IdeResourcesUtil.prependResourcePrefix(this.myModule, null, this.myFolderType))) {
            return this.myNameField;
        }
        if (this.myValueField.isVisible()) {
            return this.myValueField;
        }
        if (this.myModuleCombo.isVisible()) {
            return this.myModuleCombo;
        }
        return this.myFileNameCombo;
    }

    @Override
    @NotNull
    public String getResourceName() {
        return this.myNameField.getText().trim();
    }

    @Override
    @NotNull
    public ResourceType getType() {
        return this.myResourceType;
    }

    @Override
    @NotNull
    public List<String> getDirNames() {
        return this.mySubdirPanel.getDirNames();
    }

    @Override
    @NotNull
    public String getFileName() {
        return ((String)this.myFileNameCombo.getEditor().getItem()).trim();
    }

    @Override
    @NotNull
    public String getValue() {
        return this.myValueField.getText();
    }

    @Override
    @Nullable
    public Module getModule() {
        return this.myModule != null ? this.myModule : this.myModuleCombo.getSelectedModule();
    }

    @Override
    @Nullable
    public VirtualFile getResourceDirectory() {
        Module module2 = this.getModule();
        if (module2 == null) {
            return null;
        }
        PsiDirectory resDirectory = CreateResourceDialogUtils.getOrCreateResourceDirectory(this.mySourceSetCombo, module2);
        return resDirectory != null ? resDirectory.getVirtualFile() : null;
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    private void setChangeFileNameVisible(boolean isVisible2) {
        this.myFileNameLabel.setVisible(isVisible2);
        this.myFileNameCombo.setVisible(isVisible2);
    }

    private void setChangeValueVisible(boolean isVisible2) {
        this.myValueFieldContainer.setVisible(isVisible2);
        this.myValueLabel.setVisible(isVisible2);
    }

    private void setChangeNameVisible(boolean isVisible2) {
        this.myNameField.setVisible(isVisible2);
        this.myNameLabel.setVisible(isVisible2);
    }

    private void setChangeModuleVisible(boolean isVisible2) {
        this.myModuleLabel.setVisible(isVisible2);
        this.myModuleCombo.setVisible(isVisible2);
    }

    @Override
    public void updateFilesCombo(List<VirtualFile> directories2) {
        Object oldItem = this.myFileNameCombo.getEditor().getItem();
        HashSet<String> fileNameSet = new HashSet<String>();
        for (VirtualFile dir : directories2) {
            for (VirtualFile file2 : dir.getChildren()) {
                fileNameSet.add(file2.getName());
            }
        }
        ArrayList fileNames = new ArrayList(fileNameSet);
        Collections.sort(fileNames);
        this.myFileNameCombo.setModel(new DefaultComboBoxModel<Object>(fileNames.toArray()));
        this.myFileNameCombo.getEditor().setItem(oldItem);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JComboBox jComboBox2;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        ModulesComboBox modulesComboBox;
        JTextField jTextField;
        JBLabel jBLabel6;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 5, 0), -1, -1, false, false));
        this.myNameLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Resource name:");
        jBLabel6.setDisplayedMnemonic('N');
        jBLabel6.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myModuleCombo = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myModuleLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Module:");
        jBLabel5.setDisplayedMnemonic('M');
        jBLabel5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileNameLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("File name:");
        jBLabel4.setDisplayedMnemonic('F');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoriesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDirectoriesLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Create the resource in directories:");
        jBLabel3.setDisplayedMnemonic('C');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myValueLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Resource value:");
        jBLabel2.setDisplayedMnemonic('V');
        jBLabel2.setDisplayedMnemonicIndex(9);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileNameCombo = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel2.add(jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySourceSetLabel = jBLabel = new JBLabel();
        jBLabel.setText("Source set:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceSetCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel3 = this.myValueFieldContainer;
        ((Component)jPanel3).setEnabled(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel6.setLabelFor(jTextField);
        jBLabel5.setLabelFor((Component)modulesComboBox);
        jBLabel4.setLabelFor(jComboBox2);
        jBLabel.setLabelFor((Component)modulesComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

