/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.google.common.collect.Maps;
import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateResourceFileActionGroup;
import org.jetbrains.android.actions.CreateResourceFileDialogBase;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceFileAction
extends CreateResourceActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.CreateResourceFileAction");
    private final Map<ResourceFolderType, CreateTypedResourceFileAction> mySubactions = Maps.newEnumMap(ResourceFolderType.class);
    private String myRootElement;
    private boolean myNavigate;

    @NotNull
    public static CreateResourceFileAction getInstance() {
        AnAction action2 = ActionManager.getInstance().getAction("Android.CreateResourcesActionGroup");
        assert (action2 instanceof CreateResourceFileActionGroup);
        return ((CreateResourceFileActionGroup)action2).getCreateResourceFileAction();
    }

    public CreateResourceFileAction() {
        super(AndroidBundle.message("new.resource.action.title", new Object[0]), AndroidBundle.message("new.resource.action.description", new Object[0]), XmlFileType.INSTANCE.getIcon());
    }

    public void add(CreateTypedResourceFileAction action2) {
        this.mySubactions.put(action2.getResourceFolderType(), action2);
    }

    public Collection<CreateTypedResourceFileAction> getSubactions() {
        return this.mySubactions.values();
    }

    @Override
    protected boolean isAvailable(DataContext context2) {
        if (!super.isAvailable(context2)) {
            return false;
        }
        return CreateResourceFileAction.isOutsideResourceTypeFolder(context2);
    }

    static boolean isOutsideResourceTypeFolder(@NotNull DataContext context2) {
        Module module2;
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context2);
        if (file2 != null) {
            if (!file2.isDirectory()) {
                file2 = file2.getParent();
            }
            if (file2 != null && ResourceFolderType.getFolderType((String)file2.getName()) != null) {
                return false;
            }
        }
        if ((module2 = (Module)PlatformCoreDataKeys.MODULE.getData(context2)) != null) {
            return AndroidFacet.getInstance((Module)module2) != null;
        }
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context2);
        return element2 != null && AndroidFacet.getInstance((PsiElement)element2) != null;
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet2, @NotNull ResourceFolderType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config2, boolean chooseResName, @Nullable String dialogTitle, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext, boolean navigate2) {
        PsiElement[] elements = CreateResourceFileAction.doCreateFileResource(facet2, resType, resName, rootElement, config2, chooseResName, dialogTitle, resDirectory, dataContext, navigate2);
        if (elements.length == 0) {
            return null;
        }
        assert (elements.length == 1 && elements[0] instanceof XmlFile);
        return (XmlFile)elements[0];
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet2, @NotNull ResourceFolderType folderType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config2, boolean chooseResName, @Nullable String dialogTitle, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext) {
        return CreateResourceFileAction.createFileResource(facet2, folderType, resName, rootElement, config2, chooseResName, dialogTitle, resDirectory, dataContext, true);
    }

    @NotNull
    private static PsiElement[] doCreateFileResource(@NotNull AndroidFacet facet2, @NotNull ResourceFolderType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config2, boolean chooseResName, @Nullable String dialogTitle, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext, boolean navigate2) {
        CreateResourceFileAction action2 = CreateResourceFileAction.getInstance();
        Project project = facet2.getModule().getProject();
        action2.myNavigate = navigate2;
        CreateResourceFileDialogBase.ValidatorFactory validatorFactory = action2.createValidatorFactory(project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String subdirName = resType.getName();
            VirtualFile resDir = ResourceFolderManager.getInstance(facet2).getPrimaryFolder();
            if (resDir == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            PsiDirectory resourceDir = PsiManager.getInstance((Project)project).findDirectory(resDir);
            if (resourceDir == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            ElementCreatingValidator inputValidator = validatorFactory.create(resourceDir, subdirName, null);
            return inputValidator.checkInput(resName) && inputValidator.canClose(resName) ? ((CreateResourceActionBase.MyInputValidator)inputValidator).getCreatedElements() : PsiElement.EMPTY_ARRAY;
        }
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceFileDialogBase dialog2 = newResourceHandler.createNewResourceFileDialog(facet2, action2.mySubactions.values(), resType, resName, rootElement, config2, chooseResName, true, resDirectory, dataContext, validatorFactory);
        if (dialogTitle != null) {
            dialog2.setTitle(dialogTitle);
        }
        if (!dialog2.showAndGet()) {
            return PsiElement.EMPTY_ARRAY;
        }
        return dialog2.getCreatedElements();
    }

    @Override
    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, @NotNull DataContext dataContext) {
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (module2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        LOG.assertTrue(facet2 != null);
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        ResourceFolderType folderType = CreateResourceFileAction.getUniqueFolderType(files2);
        FolderConfiguration config2 = null;
        if (files2 != null && files2.length > 0) {
            config2 = files2.length == 1 ? FolderConfiguration.getConfigForFolder((String)files2[0].getName()) : null;
        }
        this.myNavigate = true;
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceFileDialogBase dialog2 = newResourceHandler.createNewResourceFileDialog(facet2, this.mySubactions.values(), folderType, null, null, config2, true, false, CreateResourceDialogUtils.findResourceDirectory(dataContext), dataContext, this.createValidatorFactory(project));
        if (!dialog2.showAndGet()) {
            return PsiElement.EMPTY_ARRAY;
        }
        return dialog2.getCreatedElements();
    }

    @Nullable
    static ResourceFolderType getUniqueFolderType(@Nullable VirtualFile[] files2) {
        ResourceFolderType folderType = null;
        if (files2 != null && files2.length > 0) {
            for (VirtualFile file2 : files2) {
                ResourceFolderType type;
                if (!file2.isDirectory()) {
                    file2 = file2.getParent();
                }
                if (file2 == null || (type = ResourceFolderType.getFolderType((String)file2.getName())) == null) continue;
                if (type != folderType && folderType != null) {
                    folderType = null;
                    break;
                }
                folderType = type;
            }
        }
        return folderType;
    }

    @NotNull
    private CreateResourceFileDialogBase.ValidatorFactory createValidatorFactory(final @NotNull Project project) {
        return new CreateResourceFileDialogBase.ValidatorFactory(){

            @Override
            @NotNull
            public ElementCreatingValidator create(@NotNull PsiDirectory resourceDirectory, @NotNull String subdirName, @Nullable String rootElement) {
                PsiDirectory resSubdir = resourceDirectory.findSubdirectory(subdirName);
                if (resSubdir == null) {
                    resSubdir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction(() -> resourceDirectory.createSubdirectory(subdirName));
                }
                CreateResourceFileAction.this.myRootElement = rootElement;
                return new CreateResourceActionBase.MyInputValidator(CreateResourceFileAction.this, project, resSubdir);
            }
        };
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName2, PsiDirectory directory) throws Exception {
        CreateTypedResourceFileAction action2 = this.getActionByDir(directory);
        if (action2 == null) {
            throw new IllegalArgumentException("Incorrect directory");
        }
        if (this.myRootElement != null && !this.myRootElement.isEmpty()) {
            return action2.doCreateAndNavigate(newName2, directory, this.myRootElement, false, this.myNavigate);
        }
        return action2.create(newName2, directory);
    }

    private CreateTypedResourceFileAction getActionByDir(PsiDirectory directory) {
        String baseDirName = directory.getName();
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)baseDirName);
        if (folderType == null) {
            return null;
        }
        return this.mySubactions.get(folderType);
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.resource.command.name", new Object[0]);
    }

    @Override
    @Nullable
    protected String getActionName(PsiDirectory directory, String newName2) {
        return CreateResourceFileAction.doGetActionName(directory, newName2);
    }

    static String doGetActionName(PsiDirectory directory, String newName2) {
        if (FileUtilRt.getExtension((String)newName2).isEmpty()) {
            newName2 = (String)newName2 + ".xml";
        }
        return AndroidBundle.message("new.resource.action.name", directory.getName() + File.separator + (String)newName2);
    }
}

