/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.AndroidXConstants;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMultiRootResourceFileAction
extends CreateTypedResourceFileAction {
    private String myLastRootComponentName;

    public CreateMultiRootResourceFileAction(@NotNull String resourcePresentableName, @NotNull ResourceFolderType resourceFolderType) {
        super(resourcePresentableName, resourceFolderType, false, false);
    }

    @Override
    @NotNull
    protected PsiElement[] invokeDialog(@NotNull Project project, @NotNull DataContext dataContext) {
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null) {
            AbstractProjectViewPane pane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane();
            if (pane.getId().equals("AndroidView")) {
                return CreateResourceFileAction.getInstance().invokeDialog(project, dataContext);
            }
            PsiDirectory directory = view.getOrChooseDirectory();
            if (directory != null) {
                InputValidator validator = this.createValidator(project, directory);
                AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)directory);
                if (facet2 != null) {
                    MyDialog dialog2 = new MyDialog(facet2, validator);
                    dialog2.show();
                    return PsiElement.EMPTY_ARRAY;
                }
            }
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName2, PsiDirectory directory) throws Exception {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        String rootTag = this.myLastRootComponentName != null ? this.myLastRootComponentName : this.getDefaultRootTag(module2);
        return this.doCreateAndNavigate(newName2, directory, rootTag, false, true);
    }

    @Override
    public String getDefaultRootTag(@Nullable Module module2) {
        if (module2 != null && this.myResourceFolderType == ResourceFolderType.LAYOUT) {
            if (DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.CONSTRAINT_LAYOUT)) {
                return AndroidXConstants.CONSTRAINT_LAYOUT.oldName();
            }
            if (DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.ANDROIDX_CONSTRAINT_LAYOUT)) {
                return AndroidXConstants.CONSTRAINT_LAYOUT.newName();
            }
        }
        return super.getDefaultRootTag(module2);
    }

    @Override
    @NotNull
    public List<String> getAllowedTagNames(@NotNull AndroidFacet facet2) {
        assert (this.myResourceFolderType == ResourceFolderType.LAYOUT);
        return this.getPossibleRoots(facet2);
    }

    @VisibleForTesting
    List<String> getPossibleRoots(@NotNull AndroidFacet facet2) {
        return AndroidLayoutUtil.getPossibleRoots(facet2);
    }

    public class MyDialog
    extends DialogWrapper {
        private final InputValidator myValidator;
        private JTextField myFileNameField;
        private TextFieldWithAutoCompletion<String> myRootElementField;
        private JPanel myPanel;
        private JPanel myRootElementFieldWrapper;
        private JBLabel myRootElementLabel;

        protected MyDialog(@Nullable AndroidFacet facet2, InputValidator validator) {
            super(facet2.getModule().getProject());
            this.myValidator = validator;
            Object[] objectArray = new Object[]{CreateMultiRootResourceFileAction.this.myResourcePresentableName};
            this.$$$setupUI$$$();
            this.setTitle(AndroidBundle.message("new.typed.resource.dialog.title", objectArray));
            List<String> tagNames = CreateMultiRootResourceFileAction.this.getSortedAllowedTagNames(facet2);
            this.myRootElementField = new TextFieldWithAutoCompletion(facet2.getModule().getProject(), (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(tagNames, null), true, null);
            this.myRootElementField.setText(CreateMultiRootResourceFileAction.this.getDefaultRootTag(facet2.getModule()));
            this.myRootElementFieldWrapper.add((Component)this.myRootElementField, "Center");
            this.myRootElementLabel.setLabelFor(this.myRootElementField);
            this.init();
            this.myFileNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(@NotNull DocumentEvent event) {
                    String text2 = MyDialog.this.myFileNameField.getText().trim();
                    if (MyDialog.this.myValidator instanceof InputValidatorEx) {
                        MyDialog.this.setErrorText(((InputValidatorEx)MyDialog.this.myValidator).getErrorText(text2));
                    }
                }
            });
        }

        protected JComponent createCenterPanel() {
            return this.myPanel;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myFileNameField;
        }

        protected void doOKAction() {
            String fileName = this.myFileNameField.getText().trim();
            CreateMultiRootResourceFileAction.this.myLastRootComponentName = this.myRootElementField.getText().trim();
            if (fileName.isEmpty()) {
                Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("file.name.not.specified.error", new Object[0]), (String)CommonBundle.getErrorTitle());
                return;
            }
            if (CreateMultiRootResourceFileAction.this.myLastRootComponentName.isEmpty()) {
                Messages.showErrorDialog((Component)this.myPanel, (String)AndroidBundle.message("root.element.not.specified.error", new Object[0]), (String)CommonBundle.getErrorTitle());
                return;
            }
            if (this.myValidator == null || this.myValidator.checkInput(fileName) && this.myValidator.canClose(fileName)) {
                super.doOKAction();
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JBLabel jBLabel;
            JTextField jTextField;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBLabel jBLabel2 = new JBLabel();
            jBLabel2.setText("File name:");
            jBLabel2.setDisplayedMnemonic('F');
            jBLabel2.setDisplayedMnemonicIndex(0);
            jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myFileNameField = jTextField = new JTextField();
            jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myRootElementLabel = jBLabel = new JBLabel();
            jBLabel.setText("Root element:");
            jBLabel.setDisplayedMnemonic('R');
            jBLabel.setDisplayedMnemonicIndex(0);
            jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myRootElementFieldWrapper = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, null, null));
            jBLabel2.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }
    }
}

