/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.Client;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.execution.common.debug.utils.UtilsKt;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessHandler;
import com.android.tools.idea.run.editor.RunConfigurationWithDebugger;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidConnectDebuggerAction
extends AnAction {
    private final boolean isAndroidStudio = IdeInfo.getInstance().isAndroidStudio();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        AndroidProcessChooserDialog dialog2 = new AndroidProcessChooserDialog(project, true);
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            Client client2 = dialog2.getClient();
            if (client2 == null) {
                return;
            }
            AppExecutorUtil.getAppExecutorService().execute(() -> AndroidConnectDebuggerAction.closeOldSessionAndRun(project, dialog2.getSelectedAndroidDebugger(), client2, dialog2.getRunConfiguration()));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean isVisible2 = this.isAndroidStudio || project != null && ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID);
        e.getPresentation().setVisible(isVisible2);
    }

    @Slow
    public static void closeOldSessionAndRun(@NotNull Project project, @NotNull AndroidDebugger androidDebugger, @NotNull Client client2, @Nullable RunConfigurationWithDebugger configuration) {
        AndroidConnectDebuggerAction.terminateRunSessions(project, client2);
        Object state2 = configuration != null ? configuration.getAndroidDebuggerContext().getAndroidDebuggerState() : androidDebugger.createState();
        androidDebugger.attachToClient(project, client2, state2).onError(e -> {
            if (e instanceof ExecutionException) {
                UtilsKt.showError(project, (ExecutionException)((Object)((Object)e)), "Attach debug to process");
            } else {
                Logger.getInstance(AndroidConnectDebuggerAction.class).error(e);
            }
        });
    }

    private static void terminateRunSessions(@NotNull Project project, @NotNull Client selectedClient) {
        int pid = selectedClient.getClientData().getPid();
        for (ProcessHandler handler2 : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            Client client2;
            if (!(handler2 instanceof AndroidProcessHandler) || (client2 = ((AndroidProcessHandler)handler2).getClient(selectedClient.getDevice())) == null || client2.getClientData().getPid() != pid) continue;
            handler2.notifyTextAvailable("Disconnecting run session: a new debug session will be established.\n", ProcessOutputTypes.STDOUT);
            handler2.detachProcess();
            break;
        }
    }
}

