/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import org.jetbrains.android.AndroidResourceExternalAnnotatorBase;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXMLResourceExternalAnnotator
extends AndroidResourceExternalAnnotatorBase {
    @Override
    @Nullable
    protected AndroidResourceExternalAnnotatorBase.FileAnnotationInfo collectInformation(@NotNull PsiFile file2, @NotNull Editor editor) {
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return null;
        }
        final AndroidResourceExternalAnnotatorBase.FileAnnotationInfo annotationInfo = new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo(facet2, file2, editor);
        if (IdeResourcesUtil.isInResourceSubdirectoryInAnyVariant(file2, "values")) {
            file2.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement annotatableElement = AndroidXMLResourceExternalAnnotator.getAnnotatableElement(tag.getValue().getText().trim(), (XmlElement)tag);
                    if (annotatableElement != null) {
                        annotationInfo.getElements().add(annotatableElement);
                    }
                }
            });
        } else if (IdeResourcesUtil.isInResourceSubdirectoryInAnyVariant(file2, null) || ManifestDomFileDescription.isManifestFile((XmlFile)file2)) {
            file2.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                    super.visitXmlAttributeValue(attributeValue);
                    AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement annotatableElement = AndroidXMLResourceExternalAnnotator.getAnnotatableElement(attributeValue.getValue(), (XmlElement)attributeValue);
                    if (annotatableElement != null) {
                        annotationInfo.getElements().add(annotatableElement);
                    }
                }
            });
        }
        if (annotationInfo.getElements().isEmpty()) {
            return null;
        }
        return annotationInfo;
    }

    @Nullable
    private static AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement getAnnotatableElement(@NotNull String value2, @NotNull XmlElement element2) {
        if ((value2 = value2.trim()).isEmpty()) {
            return null;
        }
        char startChar = value2.charAt(0);
        if (startChar != '@' && startChar != '#' && startChar != '?') {
            return null;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)value2);
        if (resourceUrl == null) {
            if (value2.startsWith("#")) {
                Color color = IdeResourcesUtil.parseColor(value2);
                if (color == null) {
                    return null;
                }
                return new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement(color, (PsiElement)element2);
            }
        } else {
            ResourceReference reference = IdeResourcesUtil.resolve(resourceUrl, element2);
            if (reference == null) {
                return null;
            }
            ResourceType type = reference.getResourceType();
            if (type != ResourceType.COLOR && type != ResourceType.DRAWABLE && type != ResourceType.MIPMAP && type != ResourceType.ATTR && type != ResourceType.MACRO) {
                return null;
            }
            return new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement(reference, (PsiElement)element2);
        }
        return null;
    }
}

