/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.android.AndroidResourceExternalAnnotatorBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaResourceExternalAnnotator
extends AndroidResourceExternalAnnotatorBase {
    @Override
    @Nullable
    protected AndroidResourceExternalAnnotatorBase.FileAnnotationInfo collectInformation(@NotNull PsiFile file2, @NotNull Editor editor) {
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return null;
        }
        final AndroidResourceExternalAnnotatorBase.FileAnnotationInfo annotationInfo = new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo(facet2, file2, editor);
        file2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement element2) {
                ResourceType type = AndroidPsiUtils.getResourceType((PsiElement)element2);
                if (type == ResourceType.COLOR || type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP) {
                    AndroidPsiUtils.ResourceReferenceType referenceType = AndroidPsiUtils.getResourceReferenceType((PsiElement)element2);
                    ResourceNamespace namespace = referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK ? ResourceNamespace.ANDROID : ResourceNamespace.RES_AUTO;
                    String name = AndroidPsiUtils.getResourceName((PsiElement)element2);
                    ResourceReference reference = new ResourceReference(namespace, type, name);
                    annotationInfo.getElements().add(new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement(reference, (PsiElement)element2));
                }
            }
        });
        if (annotationInfo.getElements().isEmpty()) {
            return null;
        }
        return annotationInfo;
    }
}

