/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.lang.aidl.AidlFileType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import icons.StudioIcons;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFileTemplateProvider
implements FileTemplateGroupDescriptorFactory {
    @NonNls
    public static final String REMOTE_INTERFACE_TEMPLATE = "Remote_Interface.aidl";
    @NonNls
    public static final String ANDROID_MANIFEST_TEMPLATE = "AndroidManifest.xml";
    @NonNls
    public static final String VALUE_RESOURCE_FILE_TEMPLATE = "valueResourceFile.xml";
    @NonNls
    public static final String RESOURCE_FILE_TEMPLATE = "resourceFile.xml";
    @NonNls
    public static final String LAYOUT_RESOURCE_FILE_TEMPLATE = "layoutResourceFile.xml";
    @NonNls
    public static final String LAYOUT_RESOURCE_VERTICAL_FILE_TEMPLATE = "layoutResourceFile_vertical.xml";
    @NonNls
    public static final String NAVIGATION_RESOURCE_FILE_TEMPLATE = "navigationResourceFile.xml";
    @NonNls
    public static final String ACTIVITY = "Activity.java";
    @NonNls
    public static final String FRAGMENT = "Fragment.java";
    @NonNls
    public static final String APPLICATION = "Application.java";
    @NonNls
    public static final String SERVICE = "Service.java";
    @NonNls
    public static final String BROADCAST_RECEIVER = "Broadcast_Receiver.java";
    @NonNls
    public static final String DEFAULT_PROPERTIES_TEMPLATE = "default.properties";

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        FileTemplateGroupDescriptor group2 = new FileTemplateGroupDescriptor("Android", StudioIcons.Common.ANDROID_HEAD);
        group2.addTemplate(new FileTemplateDescriptor(ANDROID_MANIFEST_TEMPLATE, XmlFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(VALUE_RESOURCE_FILE_TEMPLATE, XmlFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(RESOURCE_FILE_TEMPLATE, XmlFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(LAYOUT_RESOURCE_FILE_TEMPLATE, XmlFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(LAYOUT_RESOURCE_VERTICAL_FILE_TEMPLATE, XmlFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(ACTIVITY, JavaFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(FRAGMENT, JavaFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(APPLICATION, JavaFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(SERVICE, JavaFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(BROADCAST_RECEIVER, JavaFileType.INSTANCE.getIcon()));
        group2.addTemplate(new FileTemplateDescriptor(REMOTE_INTERFACE_TEMPLATE, AidlFileType.INSTANCE.getIcon()));
        return group2;
    }

    @Nullable
    public static PsiElement createFromTemplate(@NotNull Project project, @NotNull VirtualFile rootDir, @NotNull String templateName, @NotNull String fileName, @NotNull Properties properties2) throws Exception {
        rootDir.refresh(false, false);
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(rootDir);
        if (directory != null) {
            return AndroidFileTemplateProvider.createFromTemplate(templateName, fileName, directory, properties2);
        }
        return null;
    }

    @Nullable
    public static PsiElement createFromTemplate(@NotNull Project project, @NotNull VirtualFile rootDir, @NotNull String templateName, @NotNull String fileName) throws Exception {
        return AndroidFileTemplateProvider.createFromTemplate(project, rootDir, templateName, fileName, FileTemplateManager.getInstance((Project)project).getDefaultProperties());
    }

    public static PsiElement createFromTemplate(String templateName, String fileName, @NotNull PsiDirectory directory, Properties properties2) throws Exception {
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)directory.getProject());
        FileTemplate template = manager.getJ2eeTemplate(templateName);
        return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties2, (PsiDirectory)directory);
    }

    public static PsiElement createFromTemplate(String templateName, String fileName, @NotNull PsiDirectory directory) throws Exception {
        return AndroidFileTemplateProvider.createFromTemplate(templateName, fileName, directory, FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties());
    }

    @NotNull
    public static String getFileNameByNewElementName(@NotNull String name) {
        if (!FileUtilRt.extensionEquals((String)name, (String)"xml")) {
            name = (String)name + ".xml";
        }
        return name;
    }
}

