/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.ptable.impl;

import com.android.tools.property.ptable.PTableColumn;
import com.android.tools.property.ptable.PTableGroupItem;
import com.android.tools.property.ptable.PTableGroupModification;
import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.PTableModel;
import com.android.tools.property.ptable.PTableModelUpdateListener;
import com.android.tools.property.ptable.impl.PTableModelEvent;
import com.android.tools.property.ptable.impl.PTableModelRepaintEvent;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010!\u001a\u00020 J,\u0010\"\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0014\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001c0\u001cH\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u000e\u0010(\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0013J\u0018\u0010)\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010!\u001a\u00020 H\u0002J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010!\u001a\u00020 H\u0002J\u000e\u0010*\u001a\u00020\u00192\u0006\u0010!\u001a\u00020 J\u0010\u0010+\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010,\u001a\u00020 H\u0016J\b\u0010-\u001a\u00020 H\u0016J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020 H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u00102\u001a\u00020 2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013J\u0018\u00103\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020 H\u0016J\u000e\u00104\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u00105\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u00106\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0013J\b\u00107\u001a\u00020\u0019H\u0002J\u0016\u00108\u001a\u00020\u00192\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00130\u001cH\u0002J\u001c\u0010:\u001a\u00020\u00192\u0012\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001c0\u001cH\u0002J\u000e\u0010<\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0007J\u0018\u0010<\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010!\u001a\u00020 H\u0002J\u000e\u0010<\u001a\u00020\u00192\u0006\u0010!\u001a\u00020 J\u0016\u0010=\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?JD\u0010@\u001a\u00020\u0019\"\u0004\b\u0000\u0010A*\b\u0012\u0004\u0012\u0002HA0\u001c2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002HA0\u00122\b\b\u0002\u0010C\u001a\u00020 2\b\b\u0002\u0010D\u001a\u00020 2\b\b\u0002\u0010E\u001a\u00020 H\u0002R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006F"}, d2={"Lcom/android/tools/property/ptable/impl/PTableModelImpl;", "Ljavax/swing/table/AbstractTableModel;", "tableModel", "Lcom/android/tools/property/ptable/PTableModel;", "(Lcom/android/tools/property/ptable/PTableModel;)V", "expandedItems", "", "Lcom/android/tools/property/ptable/PTableGroupItem;", "getExpandedItems$annotations", "()V", "getExpandedItems", "()Ljava/util/Set;", "hasEditableCells", "Lcom/intellij/util/ThreeState;", "isEditable", "", "()Z", "items", "", "Lcom/android/tools/property/ptable/PTableItem;", "parentItems", "Ljava/util/IdentityHashMap;", "getTableModel", "()Lcom/android/tools/property/ptable/PTableModel;", "addParents", "", "group", "added", "", "collapse", "item", "row", "", "index", "computeExpanded", "expanded", "", "list", "computeExpandedPaths", "computeParents", "depth", "doExpand", "expand", "expandedRowCount", "getColumnCount", "getRowCount", "getValueAt", "rowIndex", "columnIndex", "groupAt", "indexOf", "isCellEditable", "isExpanded", "isGroupItem", "parentOf", "recomputeParents", "removeParents", "removed", "restoreExpanded", "previousExpandedPaths", "toggle", "updateGroupItems", "modification", "Lcom/android/tools/property/ptable/PTableGroupModification;", "copyInto", "E", "destination", "destinationOffset", "startIndex", "endIndex", "intellij.android.layout-ui"})
public final class PTableModelImpl
extends AbstractTableModel {
    @NotNull
    private final PTableModel tableModel;
    @NotNull
    private final List<PTableItem> items;
    @NotNull
    private final IdentityHashMap<PTableItem, PTableGroupItem> parentItems;
    @NotNull
    private ThreeState hasEditableCells;
    @NotNull
    private final Set<PTableGroupItem> expandedItems;

    public PTableModelImpl(@NotNull PTableModel tableModel2) {
        Intrinsics.checkNotNullParameter((Object)tableModel2, (String)"tableModel");
        this.tableModel = tableModel2;
        this.items = new ArrayList();
        this.parentItems = new IdentityHashMap();
        this.hasEditableCells = ThreeState.UNSURE;
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(IdentityHashMap())");
        this.expandedItems = set;
        this.items.addAll((Collection<PTableItem>)this.tableModel.getItems());
        this.recomputeParents();
        this.tableModel.addListener(new PTableModelUpdateListener(){

            @Override
            public void itemsUpdated(boolean modelChanged, @Nullable PTableItem nextEditedItem) {
                if (!modelChanged) {
                    this.fireTableChanged(new PTableModelRepaintEvent(this));
                } else {
                    hasEditableCells = ThreeState.UNSURE;
                    List previousExpandedPaths = this.computeExpandedPaths();
                    items.clear();
                    items.addAll((Collection)this.getTableModel().getItems());
                    this.recomputeParents();
                    this.restoreExpanded(previousExpandedPaths);
                    int index2 = nextEditedItem != null ? this.indexOf(nextEditedItem) : -1;
                    this.fireTableChanged(new PTableModelEvent(this, index2));
                }
            }
        });
    }

    @NotNull
    public final PTableModel getTableModel() {
        return this.tableModel;
    }

    @NotNull
    public final Set<PTableGroupItem> getExpandedItems() {
        return this.expandedItems;
    }

    @VisibleForTesting
    public static /* synthetic */ void getExpandedItems$annotations() {
    }

    @Override
    public int getRowCount() {
        return ((Collection)this.items).size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    @NotNull
    public PTableItem getValueAt(int rowIndex, int columnIndex) {
        return this.items.get(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.tableModel.isCellEditable(this.items.get(rowIndex), PTableColumn.Companion.fromColumn(columnIndex));
    }

    public final int indexOf(@Nullable PTableItem item2) {
        int n;
        block4: {
            if (item2 != null) {
                List<PTableItem> $this$indexOfFirst$iv = this.items;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<PTableItem> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    PTableItem item$iv;
                    PTableItem it = item$iv = iterator2.next();
                    boolean bl = false;
                    if (item2 == it) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            } else {
                n = -1;
            }
        }
        return n;
    }

    @Nullable
    public final PTableGroupItem parentOf(@NotNull PTableItem item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        return this.parentItems.get(item2);
    }

    public final boolean isGroupItem(@NotNull PTableItem item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        return item2 instanceof PTableGroupItem;
    }

    public final boolean isExpanded(@NotNull PTableGroupItem item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        return this.expandedItems.contains(item2);
    }

    public final int toggle(@NotNull PTableGroupItem item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        int index2 = this.indexOf(item2);
        if (index2 < 0) {
            return index2;
        }
        this.toggle(item2, index2);
        return index2;
    }

    public final void toggle(int index2) {
        PTableGroupItem pTableGroupItem = this.groupAt(index2);
        if (pTableGroupItem == null) {
            return;
        }
        PTableGroupItem item2 = pTableGroupItem;
        this.toggle(item2, index2);
    }

    public final void expand(int index2) {
        PTableGroupItem pTableGroupItem = this.groupAt(index2);
        if (pTableGroupItem == null) {
            return;
        }
        PTableGroupItem item2 = pTableGroupItem;
        this.expand(item2, index2);
    }

    public final void collapse(int index2) {
        PTableGroupItem pTableGroupItem = this.groupAt(index2);
        if (pTableGroupItem == null) {
            return;
        }
        PTableGroupItem item2 = pTableGroupItem;
        this.collapse(item2, index2);
    }

    public final int depth(@NotNull PTableItem item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        PTableGroupItem parent2 = this.parentItems.get(item2);
        int depth = 0;
        while (parent2 != null) {
            ++depth;
            parent2 = this.parentItems.get(parent2);
        }
        return depth;
    }

    public final boolean isEditable() {
        ThreeState editable = this.hasEditableCells;
        if (editable == ThreeState.UNSURE) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = this.items;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PTableItem it = (PTableItem)element$iv;
                        boolean bl2 = false;
                        if (!(this.tableModel.isCellEditable(it, PTableColumn.VALUE) || this.tableModel.isCellEditable(it, PTableColumn.NAME))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            ThreeState threeState = ThreeState.fromBoolean((boolean)bl);
            Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"fromBoolean(items.any {\n\u2026it, PTableColumn.NAME) })");
            this.hasEditableCells = editable = threeState;
        }
        return editable.toBoolean();
    }

    public final void updateGroupItems(@NotNull PTableGroupItem group2, @NotNull PTableGroupModification modification) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)modification, (String)"modification");
        this.removeParents(modification.getRemoved());
        this.addParents(group2, modification.getAdded());
        if (!this.isExpanded(group2)) {
            return;
        }
        int index2 = this.indexOf(group2);
        if (index2 < 0) {
            return;
        }
        int first = index2 + 1;
        int alreadyExpanded = group2.getChildren().size() - modification.getAdded().size() + modification.getRemoved().size();
        int itemsToCopy = Math.min(alreadyExpanded, group2.getChildren().size());
        this.copyInto(group2.getChildren(), this.items, first, 0, itemsToCopy);
        if (alreadyExpanded > group2.getChildren().size()) {
            this.items.subList(first + group2.getChildren().size(), first + alreadyExpanded).clear();
        } else if (alreadyExpanded < group2.getChildren().size()) {
            this.items.addAll(first + itemsToCopy, (Collection<PTableItem>)group2.getChildren().subList(itemsToCopy, group2.getChildren().size()));
        }
        this.fireTableDataChanged();
    }

    private final PTableGroupItem groupAt(int index2) {
        PTableGroupItem pTableGroupItem;
        if (index2 < 0 || index2 >= this.items.size()) {
            return null;
        }
        PTableItem item2 = this.items.get(index2);
        if (this.isGroupItem(item2)) {
            Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type com.android.tools.property.ptable.PTableGroupItem");
            pTableGroupItem = (PTableGroupItem)item2;
        } else {
            pTableGroupItem = null;
        }
        return pTableGroupItem;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<PTableGroupItem>> computeExpandedPaths() {
        void $this$mapTo$iv$iv;
        CollectionsKt.retainAll((Iterable)this.expandedItems, (Function1)((Function1)new Function1<PTableGroupItem, Boolean>(this){
            final /* synthetic */ PTableModelImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PTableGroupItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.isGroupItem(it);
            }
        }));
        Iterable $this$map$iv = this.expandedItems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            PTableGroupItem pTableGroupItem = (PTableGroupItem)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)node, (Function1)((Function1)new Function1<PTableGroupItem, PTableGroupItem>(this){
                final /* synthetic */ PTableModelImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final PTableGroupItem invoke(@NotNull PTableGroupItem it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.parentOf(it);
                }
            })))));
        }
        return (List)destination$iv$iv;
    }

    private final void restoreExpanded(List<? extends List<? extends PTableGroupItem>> previousExpandedPaths) {
        this.expandedItems.clear();
        for (List<? extends PTableGroupItem> list2 : previousExpandedPaths) {
            for (PTableGroupItem pTableGroupItem : list2) {
                int index2 = this.items.indexOf(pTableGroupItem);
                this.expand(index2);
            }
        }
    }

    private final void toggle(PTableGroupItem item2, int index2) {
        if (this.expandedItems.contains(item2)) {
            this.collapse(item2, index2);
        } else {
            this.expand(item2, index2);
        }
    }

    private final void expand(PTableGroupItem item2, int index2) {
        item2.expandWhenPossible((Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(item2, this, index2){
            final /* synthetic */ PTableGroupItem $item;
            final /* synthetic */ PTableModelImpl this$0;
            final /* synthetic */ int $index;
            {
                this.$item = $item;
                this.this$0 = $receiver;
                this.$index = $index;
                super(1);
            }

            public final void invoke(boolean restructured) {
                if (this.$item == PTableModelImpl.access$groupAt(this.this$0, this.$index)) {
                    if (restructured) {
                        PTableModelImpl.access$computeParents(this.this$0, this.$item);
                    }
                    PTableModelImpl.access$doExpand(this.this$0, this.$item, this.$index);
                }
            }
        }));
    }

    private final void doExpand(PTableGroupItem item2, int index2) {
        if (this.expandedItems.add(item2)) {
            List list2 = new ArrayList();
            this.computeExpanded(item2, this.expandedItems, list2);
            this.items.addAll(index2 + 1, list2);
            this.fireTableDataChanged();
        }
    }

    private final void computeExpanded(PTableGroupItem item2, Set<? extends PTableGroupItem> expanded, List<PTableItem> list2) {
        Iterable $this$forEach$iv = item2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PTableItem it = (PTableItem)element$iv;
            boolean bl = false;
            list2.add(it);
            if (!(it instanceof PTableGroupItem) || !expanded.contains(it)) continue;
            this.computeExpanded((PTableGroupItem)it, expanded, list2);
        }
    }

    private final void collapse(PTableGroupItem item2, int row2) {
        int rowsToRemove = this.expandedRowCount(item2);
        if (this.expandedItems.remove(item2)) {
            this.items.subList(row2 + 1, row2 + 1 + rowsToRemove).clear();
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int expandedRowCount(PTableGroupItem group2) {
        Iterable $this$sumBy$iv = group2.getChildren();
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            PTableItem pTableItem = (PTableItem)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = it instanceof PTableGroupItem && this.expandedItems.contains(it) ? 1 + this.expandedRowCount((PTableGroupItem)it) : 1;
            sum$iv = n + n2;
        }
        return sum$iv;
    }

    private final void recomputeParents() {
        this.parentItems.clear();
        Iterable $this$forEach$iv = this.items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PTableItem it = (PTableItem)element$iv;
            boolean bl = false;
            if (!(it instanceof PTableGroupItem)) continue;
            this.computeParents((PTableGroupItem)it);
        }
    }

    private final void computeParents(PTableGroupItem group2) {
        this.addParents(group2, group2.getChildren());
    }

    private final void addParents(PTableGroupItem group2, List<? extends PTableItem> added2) {
        Iterable $this$forEach$iv = added2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PTableItem it = (PTableItem)element$iv;
            boolean bl = false;
            ((Map)this.parentItems).put(it, group2);
            if (!(it instanceof PTableGroupItem)) continue;
            this.addParents((PTableGroupItem)it, ((PTableGroupItem)it).getChildren());
        }
    }

    private final void removeParents(List<? extends PTableItem> removed2) {
        Iterable $this$forEach$iv = removed2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PTableItem it = (PTableItem)element$iv;
            boolean bl = false;
            this.parentItems.remove(it);
            if (!(it instanceof PTableGroupItem)) continue;
            this.removeParents(((PTableGroupItem)it).getChildren());
        }
    }

    private final <E> void copyInto(List<? extends E> $this$copyInto, List<E> destination, int destinationOffset, int startIndex, int endIndex) {
        for (int index2 = startIndex; index2 < endIndex; ++index2) {
            destination.set(destinationOffset + index2 - startIndex, $this$copyInto.get(index2));
        }
    }

    static /* synthetic */ void copyInto$default(PTableModelImpl pTableModelImpl, List list2, List list3, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = list2.size();
        }
        pTableModelImpl.copyInto(list2, list3, n, n2, n3);
    }

    public static final /* synthetic */ PTableGroupItem access$groupAt(PTableModelImpl $this, int index2) {
        return $this.groupAt(index2);
    }

    public static final /* synthetic */ void access$computeParents(PTableModelImpl $this, PTableGroupItem group2) {
        $this.computeParents(group2);
    }

    public static final /* synthetic */ void access$doExpand(PTableModelImpl $this, PTableGroupItem item2, int index2) {
        $this.doExpand(item2, index2);
    }
}

