/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.tools.property.panel.impl.model.TableEditingRequest;
import com.android.tools.property.panel.impl.model.TableLineModelImpl;
import com.android.tools.property.panel.impl.model.TableRowEditListener;
import com.android.tools.property.panel.impl.model.TextFieldPropertyEditorModel;
import com.android.tools.property.panel.impl.support.HelpSupportBinding;
import com.android.tools.property.panel.impl.ui.PropertyTextField;
import com.android.tools.property.ptable.ColumnFraction;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableCellEditorProvider;
import com.android.tools.property.ptable.PTableCellRendererProvider;
import com.android.tools.property.ptable.PTableColumn;
import com.android.tools.property.ptable.PTableGroupItem;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010'\u001a\u00020#H\u0002J\u001a\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020\u001c2\b\u0010*\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0012\u0010.\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010/\u001a\u00020#H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/property/panel/impl/ui/TableEditor;", "", "lineModel", "Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;", "rendererProvider", "Lcom/android/tools/property/ptable/PTableCellRendererProvider;", "editorProvider", "Lcom/android/tools/property/ptable/PTableCellEditorProvider;", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "nameColumnFraction", "Lcom/android/tools/property/ptable/ColumnFraction;", "(Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;Lcom/android/tools/property/ptable/PTableCellRendererProvider;Lcom/android/tools/property/ptable/PTableCellEditorProvider;Ljava/util/List;Lcom/android/tools/property/ptable/ColumnFraction;)V", "getActions", "()Ljava/util/List;", "component", "Ljavax/swing/JTable;", "getComponent", "()Ljavax/swing/JTable;", "getLineModel", "()Lcom/android/tools/property/panel/impl/model/TableLineModelImpl;", "table", "Lcom/android/tools/property/ptable/PTable;", "computeRowHeight", "", "findRowOf", "itemToEdit", "Lcom/android/tools/property/ptable/PTableItem;", "findRowOfBestMatch", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "handleEditRequest", "", "request", "Lcom/android/tools/property/panel/impl/model/TableEditingRequest;", "item", "handleValueChanged", "isBetter", "", "best", "isMatch", "matcher", "Lcom/intellij/util/text/Matcher;", "selectItem", "updateUI", "intellij.android.layout-ui"})
public final class TableEditor {
    @NotNull
    private final TableLineModelImpl lineModel;
    @NotNull
    private final List<AnAction> actions;
    @NotNull
    private final PTable table;
    @NotNull
    private final JTable component;

    /*
     * WARNING - void declaration
     */
    public TableEditor(@NotNull TableLineModelImpl lineModel, @NotNull PTableCellRendererProvider rendererProvider, @NotNull PTableCellEditorProvider editorProvider, @NotNull List<? extends AnAction> actions2, @NotNull ColumnFraction nameColumnFraction) {
        Intrinsics.checkNotNullParameter((Object)lineModel, (String)"lineModel");
        Intrinsics.checkNotNullParameter((Object)rendererProvider, (String)"rendererProvider");
        Intrinsics.checkNotNullParameter((Object)editorProvider, (String)"editorProvider");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)nameColumnFraction, (String)"nameColumnFraction");
        this.lineModel = lineModel;
        this.actions = actions2;
        this.table = PTable.Companion.create(this.lineModel.getTableModel(), this.lineModel, rendererProvider, editorProvider, (Function1<? super MouseEvent, String>)((Function1)new Function1<MouseEvent, String>(this){
            final /* synthetic */ TableEditor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TableEditor.access$getToolTipText(this.this$0, it);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                TableEditor.access$updateUI((TableEditor)this.receiver);
            }
        }), nameColumnFraction);
        JComponent jComponent = this.table.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type javax.swing.JTable");
        this.component = (JTable)jComponent;
        this.component.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.component.setRowHeight(this.computeRowHeight());
        this.lineModel.addValueChangedListener(new TableRowEditListener(){

            public void valueChanged() {
                this.handleValueChanged();
            }

            @Override
            public void editRequest(@NotNull TableEditingRequest type, @Nullable PTableItem item2) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                this.handleEditRequest(type, item2);
            }
        });
        this.component.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                Object object;
                int index2 = this.getComponent().getSelectedRow();
                PTableItem item2 = index2 >= 0 && index2 < this.getComponent().getRowCount() ? ((object = this.getComponent().getValueAt(index2, 1)) instanceof PTableItem ? (PTableItem)object : null) : null;
                this.getLineModel().setSelectedItem(item2);
            }
        });
        HelpSupportBinding.registerHelpKeyActions$default(HelpSupportBinding.INSTANCE, this.component, (Function0)new Function0<PropertyItem>(){

            @Nullable
            public final PropertyItem invoke() {
                PTableItem pTableItem = this.getLineModel().getSelectedItem();
                return pTableItem instanceof PropertyItem ? (PropertyItem)pTableItem : null;
            }
        }, 0, 4, null);
        KeyBindingKt.registerActionKey$default((JComponent)this.component, (Function0)4.INSTANCE, (KeyStroke)KeyStrokes.INSTANCE.getPAGE_UP(), (String)"pageUp", (Function0)5.INSTANCE, (int)0, (int)16, null);
        KeyBindingKt.registerActionKey$default((JComponent)this.component, (Function0)6.INSTANCE, (KeyStroke)KeyStrokes.INSTANCE.getPAGE_DOWN(), (String)"pageDown", (Function0)7.INSTANCE, (int)0, (int)16, null);
        Iterable $this$forEach$iv = this.actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            AnAction action2 = (AnAction)element$iv;
            boolean bl = false;
            Shortcut[] shortcutArray = action2.getShortcutSet().getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"action.shortcutSet.shortcuts");
            Object[] objectArray = shortcutArray;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KeyboardShortcut)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KeyboardShortcut it = (KeyboardShortcut)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getSecondKeyStroke() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KeyboardShortcut it = (KeyboardShortcut)element$iv2;
                boolean bl3 = false;
                JComponent jComponent2 = this.component;
                Function0 function0 = (Function0)new Function0<AnAction>(action2){
                    final /* synthetic */ AnAction $action;
                    {
                        this.$action = $action;
                        super(0);
                    }

                    @Nullable
                    public final AnAction invoke() {
                        return this.$action;
                    }
                };
                KeyStroke keyStroke = it.getFirstKeyStroke();
                Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"it.firstKeyStroke");
                String string = action2.getTemplatePresentation().getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"action.templatePresentation.description");
                KeyBindingKt.registerAnActionKey$default((JComponent)jComponent2, (Function0)function0, (KeyStroke)keyStroke, (String)string, (int)0, (int)8, null);
            }
        }
    }

    public /* synthetic */ TableEditor(TableLineModelImpl tableLineModelImpl, PTableCellRendererProvider pTableCellRendererProvider, PTableCellEditorProvider pTableCellEditorProvider, List list2, ColumnFraction columnFraction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            columnFraction = new ColumnFraction(0.0f, false, 3, null);
        }
        this(tableLineModelImpl, pTableCellRendererProvider, pTableCellEditorProvider, list2, columnFraction);
    }

    @NotNull
    public final TableLineModelImpl getLineModel() {
        return this.lineModel;
    }

    @NotNull
    public final List<AnAction> getActions() {
        return this.actions;
    }

    @NotNull
    public final JTable getComponent() {
        return this.component;
    }

    private final void updateUI() {
        this.component.setRowHeight(this.computeRowHeight());
    }

    private final void handleValueChanged() {
        this.component.setVisible(this.lineModel.getVisible());
        this.table.setFilter(this.lineModel.getFilter());
        this.lineModel.setItemCount(this.table.getItemCount());
    }

    private final void handleEditRequest(TableEditingRequest request2, PTableItem item2) {
        this.handleValueChanged();
        switch (WhenMappings.$EnumSwitchMapping$0[request2.ordinal()]) {
            case 1: {
                this.table.startEditing(this.findRowOf(item2));
                break;
            }
            case 2: {
                this.table.startEditing(-1);
                break;
            }
            case 3: {
                this.table.startEditing(this.findRowOfBestMatch());
                break;
            }
            case 4: {
                this.selectItem(item2);
            }
        }
    }

    private final void selectItem(PTableItem item2) {
        if (item2 != null) {
            int n = this.component.getRowCount();
            for (int row2 = 0; row2 < n; ++row2) {
                if (!Intrinsics.areEqual((Object)this.component.getValueAt(row2, 0), (Object)item2)) continue;
                this.component.setRowSelectionInterval(row2, row2);
                return;
            }
        }
        this.component.transferFocusBackward();
    }

    private final String getToolTipText(MouseEvent event) {
        JComponent control;
        int tableRow = this.component.rowAtPoint(event.getPoint());
        int tableColumn = this.component.columnAtPoint(event.getPoint());
        if (tableRow < 0 || tableColumn < 0) {
            return null;
        }
        Object item2 = this.component.getValueAt(tableRow, tableColumn);
        TableCellRenderer renderer2 = this.component.getCellRenderer(tableRow, tableColumn);
        Component component2 = renderer2.getTableCellRendererComponent(this.component, item2, false, false, tableRow, tableColumn);
        if (component2 == null) {
            return null;
        }
        Component cell = component2;
        Rectangle rect = this.component.getCellRect(tableRow, tableColumn, true);
        cell.setBounds(0, 0, rect.width, rect.height);
        Component component3 = SwingUtilities.getDeepestComponentAt(cell, event.getX() - rect.x, event.getY() - rect.y);
        JComponent jComponent = control = component3 instanceof JComponent ? (JComponent)component3 : null;
        return jComponent != null ? jComponent.getToolTipText(event) : null;
    }

    private final int computeRowHeight() {
        Object v0;
        block2: {
            Iterable iterable = this.lineModel.getTableModel().getItems();
            for (Object t : iterable) {
                PTableItem it = (PTableItem)t;
                boolean bl = false;
                if (!(it instanceof PropertyItem)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Object var3_6 = v0;
        PropertyItem propertyItem = var3_6 instanceof PropertyItem ? (PropertyItem)var3_6 : null;
        if (propertyItem == null) {
            return JBUI.scale((int)24);
        }
        PropertyItem property2 = propertyItem;
        PropertyTextField textField2 = new PropertyTextField(new TextFieldPropertyEditorModel(property2, true));
        return Integer.max(textField2.getPreferredSize().height, JBUI.scale((int)20));
    }

    private final int findRowOf(PTableItem itemToEdit) {
        int count2 = this.table.getItemCount();
        for (int i = 0; i < count2; ++i) {
            PTableItem item2 = this.table.item(i);
            if (!Intrinsics.areEqual((Object)item2, (Object)itemToEdit)) continue;
            return i;
        }
        return -1;
    }

    private final int findRowOfBestMatch() {
        if (((CharSequence)this.lineModel.getFilter()).length() == 0) {
            return -1;
        }
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + this.lineModel.getFilter())).build();
        int count2 = this.table.getItemCount();
        PTableItem best = null;
        int bestRow = -1;
        for (int row2 = 0; row2 < count2; ++row2) {
            PTableItem item2 = this.table.item(row2);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher");
            if (!this.isMatch((Matcher)matcher, item2) || !this.isBetter(item2, best)) continue;
            best = item2;
            bestRow = row2;
        }
        return bestRow;
    }

    private final boolean isMatch(Matcher matcher, PTableItem item2) {
        return item2 instanceof PTableGroupItem ? matcher.matches(item2.getName()) : true;
    }

    private final boolean isBetter(PTableItem item2, PTableItem best) {
        return !this.lineModel.getTableModel().isCellEditable(item2, PTableColumn.VALUE) ? false : (best == null ? true : item2.getName().length() < best.getName().length());
    }

    public static final /* synthetic */ String access$getToolTipText(TableEditor $this, MouseEvent event) {
        return $this.getToolTipText(event);
    }

    public static final /* synthetic */ void access$updateUI(TableEditor $this) {
        $this.updateUI();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TableEditingRequest.values().length];
            nArray[TableEditingRequest.SPECIFIED_ITEM.ordinal()] = 1;
            nArray[TableEditingRequest.STOP_EDITING.ordinal()] = 2;
            nArray[TableEditingRequest.BEST_MATCH.ordinal()] = 3;
            nArray[TableEditingRequest.SELECT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

