/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.adtui.stdui.CommonHyperLinkLabel;
import com.android.tools.adtui.stdui.StandardDimensions;
import com.android.tools.property.panel.impl.model.LinkPropertyEditorModel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/property/panel/impl/ui/PropertyLink;", "Ljavax/swing/JPanel;", "model", "Lcom/android/tools/property/panel/impl/model/LinkPropertyEditorModel;", "(Lcom/android/tools/property/panel/impl/model/LinkPropertyEditorModel;)V", "label", "Lcom/intellij/ui/components/JBLabel;", "link", "Lcom/android/tools/adtui/stdui/CommonHyperLinkLabel;", "linkActivated", "", "updateFromModel", "intellij.android.layout-ui"})
public final class PropertyLink
extends JPanel {
    @NotNull
    private final LinkPropertyEditorModel model;
    @NotNull
    private final JBLabel label;
    @NotNull
    private final CommonHyperLinkLabel link;

    public PropertyLink(@NotNull LinkPropertyEditorModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(new BorderLayout());
        this.model = model2;
        this.label = new JBLabel(this.model.getValue());
        this.link = new CommonHyperLinkLabel(true, false);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.setOpaque(false);
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)StandardDimensions.INSTANCE.getHORIZONTAL_PADDING()));
        this.add((Component)this.label, "West");
        this.add((Component)this.link, "Center");
        this.link.getHyperLinkListeners().add(new Function0<Unit>(){

            public final void invoke() {
                this.linkActivated();
            }
        });
        this.link.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
        this.model.addListener(new ValueChangedListener(){

            public final void valueChanged() {
                this.updateFromModel();
            }
        });
    }

    private final void updateFromModel() {
        this.label.setText(this.model.getValue());
        Color color = UIUtil.getLabelForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelForeground()");
        this.label.setForeground(this.model.displayedForeground(color));
        this.link.setText(this.model.getLinkProperty().getLink().getTemplateText());
        this.link.setForeground(this.model.displayedForeground(this.link.getNormalForegroundColor()));
        Color color2 = UIUtil.TRANSPARENT_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"TRANSPARENT_COLOR");
        this.setBackground(this.model.displayedBackground(color2));
        this.setOpaque(this.model.isUsedInRendererWithSelection());
    }

    private final void linkActivated() {
        AnAction action2 = this.model.getLinkProperty().getLink();
        Presentation presentation = action2.getTemplatePresentation().clone();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"action.templatePresentation.clone()");
        Presentation presentation2 = presentation;
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getInstance().getDataContext(this)");
        DataContext dataContext2 = dataContext;
        ActionManager manager = ActionManager.getInstance();
        AnActionEvent actionEvent = new AnActionEvent(null, dataContext2, "unknown", presentation2, manager, 0);
        action2.actionPerformed(actionEvent);
    }
}

