/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.property.panel.api.InspectorLineModel;
import com.android.tools.property.panel.api.InspectorPanel;
import com.android.tools.property.panel.api.PropertyEditorModel;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.panel.api.TableUIProvider;
import com.android.tools.property.panel.impl.model.CollapsibleLabelModel;
import com.android.tools.property.panel.impl.model.GenericInspectorLineModel;
import com.android.tools.property.panel.impl.model.InspectorPanelModel;
import com.android.tools.property.panel.impl.model.SeparatorLineModel;
import com.android.tools.property.panel.impl.model.TableLineModelImpl;
import com.android.tools.property.panel.impl.model.TitleLineModel;
import com.android.tools.property.panel.impl.ui.CollapsibleLabelPanel;
import com.android.tools.property.panel.impl.ui.GenericLinePanel;
import com.android.tools.property.panel.impl.ui.InspectorPanelImpl;
import com.android.tools.property.panel.impl.ui.TableEditor;
import com.android.tools.property.ptable.ColumnFraction;
import com.android.tools.property.ptable.PTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010$\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u001cH\u0016J\"\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010%\u001a\u0004\u0018\u00010\u001cH\u0002J\u001c\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u00192\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u00100\u001a\u00020+2\b\u0010%\u001a\u0004\u0018\u00010\u001cH\u0002J\u0006\u00101\u001a\u00020+J\b\u00102\u001a\u00020+H\u0002J\"\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010\u001cH\u0016J8\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>2\b\u0010%\u001a\u0004\u0018\u00010\u001cH\u0016J\u001e\u0010@\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\n2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0016J\u0010\u0010A\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001cH\u0002J\u0006\u0010B\u001a\u00020+J\u0010\u0010C\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010D\u001a\u00020\u0019J\u0006\u0010E\u001a\u00020+J\u0006\u0010F\u001a\u00020+J\u0014\u0010G\u001a\u0004\u0018\u00010\u001c2\b\u0010H\u001a\u0004\u0018\u00010\u001cH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u00020\u00138\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u00020 8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0015\u001a\u0004\b\"\u0010#\u00a8\u0006I"}, d2={"Lcom/android/tools/property/panel/impl/ui/PropertiesPage;", "Lcom/android/tools/property/panel/api/InspectorPanel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/Disposable;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "value", "", "filter", "getFilter", "()Ljava/lang/String;", "setFilter", "(Ljava/lang/String;)V", "inspector", "Lcom/android/tools/property/panel/impl/ui/InspectorPanelImpl;", "inspectorModel", "Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "getInspectorModel$annotations", "()V", "getInspectorModel", "()Lcom/android/tools/property/panel/impl/model/InspectorPanelModel;", "isEmpty", "", "()Z", "lastAddedLine", "Lcom/android/tools/property/panel/api/InspectorLineModel;", "lastTitleLine", "Lcom/android/tools/property/panel/impl/model/CollapsibleLabelModel;", "nameColumnFraction", "Lcom/android/tools/property/ptable/ColumnFraction;", "getNameColumnFraction$annotations", "getNameColumnFraction", "()Lcom/android/tools/property/ptable/ColumnFraction;", "addComponent", "parent", "addCustomEditor", "editorModel", "Lcom/android/tools/property/panel/api/PropertyEditorModel;", "editor", "addLine", "", "model", "Lcom/android/tools/property/panel/impl/model/GenericInspectorLineModel;", "addSeparator", "bottomDivider", "addSeparatorAfterTitle", "addSeparatorBeforeTabs", "addSeparatorBeforeTitle", "addSubTitle", "title", "initiallyExpanded", "addTable", "Lcom/android/tools/property/panel/api/TableLineModel;", "tableModel", "Lcom/android/tools/property/ptable/PTableModel;", "searchable", "tableUI", "Lcom/android/tools/property/panel/api/TableUIProvider;", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "addTitle", "checkNewParent", "clear", "createScrollPane", "enterInFilter", "propertyValuesChanged", "repaint", "topParent", "line", "intellij.android.layout-ui"})
public final class PropertiesPage
implements InspectorPanel {
    @NotNull
    private final InspectorPanelModel inspectorModel;
    @Nullable
    private InspectorLineModel lastAddedLine;
    @Nullable
    private CollapsibleLabelModel lastTitleLine;
    @NotNull
    private final ColumnFraction nameColumnFraction;
    @NotNull
    private final InspectorPanelImpl inspector;
    @NotNull
    private final JComponent component;

    public PropertiesPage(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.inspectorModel = new InspectorPanelModel();
        this.nameColumnFraction = new ColumnFraction(PropertiesComponent.getInstance().getFloat("android.property.left.fraction", 0.4f), true);
        this.inspector = new InspectorPanelImpl(this.inspectorModel, this.nameColumnFraction, parentDisposable);
        this.nameColumnFraction.getListeners().add(new ValueChangedListener(){

            public final void valueChanged() {
                inspector.invalidate();
                inspector.validate();
                inspector.repaint();
                PropertiesComponent.getInstance().setValue("android.property.left.fraction", this.getNameColumnFraction().getValue(), 0.4f);
            }
        });
        this.component = this.createScrollPane((JComponent)((Object)this.inspector));
    }

    @NotNull
    public final InspectorPanelModel getInspectorModel() {
        return this.inspectorModel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getInspectorModel$annotations() {
    }

    @NotNull
    public final ColumnFraction getNameColumnFraction() {
        return this.nameColumnFraction;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNameColumnFraction$annotations() {
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final String getFilter() {
        return this.inspectorModel.getFilter();
    }

    public final void setFilter(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.inspectorModel.setFilter(value2);
    }

    public final boolean isEmpty() {
        return this.inspectorModel.getLines().isEmpty();
    }

    public final boolean enterInFilter() {
        return this.inspectorModel.enterInFilter();
    }

    public final void clear() {
        this.inspectorModel.clear();
        this.inspector.removeAll();
        this.lastAddedLine = null;
        this.lastTitleLine = null;
    }

    public final void propertyValuesChanged() {
        this.inspectorModel.propertyValuesChanged();
    }

    public final void repaint() {
        this.inspector.revalidate();
        this.inspector.repaint();
    }

    public final void addSeparatorBeforeTabs() {
        this.addSeparatorBeforeTitle();
    }

    private final JComponent createScrollPane(JComponent component2) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)component2, (int)20, (int)31);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(\n      \u2026RIZONTAL_SCROLLBAR_NEVER)");
        JScrollPane scrollPane = jScrollPane;
        scrollPane.setVerticalScrollBar((JScrollBar)new JBScrollBar(){

            public void setOpaque(boolean isOpaque) {
                super.setOpaque(isOpaque || SystemInfo.isMac);
            }
        });
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        scrollPane.addComponentListener(new ComponentAdapter(scrollPane){
            final /* synthetic */ JScrollPane $scrollPane;
            {
                this.$scrollPane = $scrollPane;
            }

            public void componentResized(@Nullable ComponentEvent event) {
                this.$scrollPane.getVerticalScrollBar().setUnitIncrement(JBUI.scale((int)16) * (SystemInfo.isWindows ? 1 : 2));
                this.$scrollPane.getVerticalScrollBar().setBlockIncrement(this.$scrollPane.getHeight());
            }
        });
        return scrollPane;
    }

    @Override
    @NotNull
    public InspectorLineModel addTitle(@NotNull String title, @NotNull List<? extends AnAction> actions2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        this.addSeparatorBeforeTitle();
        TitleLineModel model2 = new TitleLineModel(title);
        CollapsibleLabelPanel label = new CollapsibleLabelPanel(model2, UIUtil.FontSize.NORMAL, 1, actions2, this.nameColumnFraction);
        label.setOpaque(true);
        label.setInnerBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        label.setBorder(JBUI.Borders.merge((Border)((Border)JBUI.Borders.empty((int)0, (int)6, (int)0, (int)0)), (Border)((Border)new SideBorder(JBColor.border(), 8)), (boolean)true));
        this.addLine(model2, null);
        this.inspector.addLineElement(label);
        label.setBackground(UIUtil.getPanelBackground());
        this.lastTitleLine = model2;
        return model2;
    }

    @Override
    @NotNull
    public InspectorLineModel addSubTitle(@NotNull String title, boolean initiallyExpanded, @Nullable InspectorLineModel parent2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.addSeparatorBeforeTitle();
        TitleLineModel model2 = new TitleLineModel(title);
        CollapsibleLabelPanel label = new CollapsibleLabelPanel(model2, UIUtil.FontSize.NORMAL, 1, null, null, 24, null);
        label.setOpaque(true);
        label.setInnerBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        label.setBorder(JBUI.Borders.merge((Border)((Border)JBUI.Borders.empty((int)0, (int)6, (int)0, (int)0)), (Border)((Border)new SideBorder(JBColor.border(), 8)), (boolean)true));
        this.addLine(model2, parent2);
        this.inspector.addLineElement(label);
        this.lastTitleLine = model2;
        model2.makeExpandable(initiallyExpanded);
        return model2;
    }

    @Override
    @NotNull
    public InspectorLineModel addCustomEditor(@NotNull PropertyEditorModel editorModel, @NotNull JComponent editor, @Nullable InspectorLineModel parent2) {
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.addSeparatorAfterTitle(parent2);
        CollapsibleLabelModel model2 = new CollapsibleLabelModel(editorModel.getProperty().getName(), editorModel, false, null, 12, null);
        CollapsibleLabelPanel label = new CollapsibleLabelPanel(model2, UIUtil.FontSize.SMALL, 0, null, null, 24, null);
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        editorModel.setLineModel(model2);
        this.addLine(model2, parent2);
        this.inspector.addLineElement(label, editor);
        return model2;
    }

    @Override
    @NotNull
    public TableLineModel addTable(@NotNull PTableModel tableModel2, boolean searchable, @NotNull TableUIProvider tableUI, @NotNull List<? extends AnAction> actions2, @Nullable InspectorLineModel parent2) {
        Intrinsics.checkNotNullParameter((Object)tableModel2, (String)"tableModel");
        Intrinsics.checkNotNullParameter((Object)tableUI, (String)"tableUI");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        TableLineModelImpl model2 = new TableLineModelImpl(tableModel2, searchable);
        TableEditor editor = new TableEditor(model2, tableUI.getTableCellRendererProvider(), tableUI.getTableCellEditorProvider(), actions2, this.nameColumnFraction);
        this.addLine(model2, parent2);
        this.inspector.addLineElement(editor.getComponent());
        return model2;
    }

    @Override
    @NotNull
    public InspectorLineModel addComponent(@NotNull JComponent component2, @Nullable InspectorLineModel parent2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.addSeparatorAfterTitle(parent2);
        GenericInspectorLineModel model2 = new GenericInspectorLineModel();
        GenericLinePanel wrapper = new GenericLinePanel(component2, model2);
        this.addLine(model2, parent2);
        this.inspector.addLineElement(wrapper);
        return model2;
    }

    private final void addLine(GenericInspectorLineModel model2, InspectorLineModel parent2) {
        InspectorLineModel inspectorLineModel = parent2;
        if (inspectorLineModel != null) {
            InspectorLineModel it = inspectorLineModel;
            boolean bl = false;
            this.checkNewParent(it).addChild(model2);
        }
        this.inspectorModel.add(model2);
        this.lastAddedLine = model2;
    }

    private final CollapsibleLabelModel checkNewParent(InspectorLineModel parent2) {
        CollapsibleLabelModel collapsibleLabelModel = parent2 instanceof CollapsibleLabelModel ? (CollapsibleLabelModel)parent2 : null;
        if (collapsibleLabelModel == null) {
            throw new IllegalArgumentException();
        }
        CollapsibleLabelModel label = collapsibleLabelModel;
        if (!label.getExpandable()) {
            throw new IllegalArgumentException();
        }
        return label;
    }

    private final void addSeparatorBeforeTitle() {
        if (this.lastAddedLine == null || Intrinsics.areEqual((Object)this.lastAddedLine, (Object)this.lastTitleLine) || this.lastAddedLine instanceof TableLineModel) {
            return;
        }
        this.addSeparator(true, this.topParent(this.lastAddedLine));
    }

    private final void addSeparatorAfterTitle(InspectorLineModel parent2) {
        if (this.lastAddedLine == null || Intrinsics.areEqual((Object)this.lastAddedLine, (Object)this.lastTitleLine)) {
            this.addSeparator(false, parent2);
        } else {
            InspectorLineModel topParent;
            InspectorLineModel lastTopParent = this.topParent(this.lastAddedLine);
            if (!Intrinsics.areEqual((Object)lastTopParent, (Object)(topParent = this.topParent(parent2)))) {
                this.addSeparator(false, topParent);
            }
        }
    }

    private final InspectorLineModel topParent(InspectorLineModel line2) {
        InspectorLineModel topParent = line2;
        while (true) {
            InspectorLineModel inspectorLineModel = topParent;
            if ((inspectorLineModel != null ? inspectorLineModel.getParent() : null) == null || topParent instanceof TitleLineModel) break;
            topParent = topParent.getParent();
        }
        InspectorLineModel inspectorLineModel = topParent;
        return inspectorLineModel instanceof TitleLineModel ? (TitleLineModel)inspectorLineModel : null;
    }

    private final GenericInspectorLineModel addSeparator(boolean bottomDivider, InspectorLineModel parent2) {
        JPanel component2 = new JPanel();
        component2.setPreferredSize((Dimension)new JBDimension(0, 4));
        component2.setBackground(this.inspector.getBackground());
        component2.setBorder(bottomDivider ? (Border)new SideBorder(JBColor.border(), 8) : (Border)JBUI.Borders.empty());
        SeparatorLineModel model2 = new SeparatorLineModel();
        GenericLinePanel wrapper = new GenericLinePanel(component2, model2);
        this.addLine(model2, parent2);
        this.inspector.addLineElement(wrapper);
        return model2;
    }

    static /* synthetic */ GenericInspectorLineModel addSeparator$default(PropertiesPage propertiesPage, boolean bl, InspectorLineModel inspectorLineModel, int n, Object object) {
        if ((n & 2) != 0) {
            inspectorLineModel = null;
        }
        return propertiesPage.addSeparator(bl, inspectorLineModel);
    }
}

