/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.property.panel.impl.ui.Placement;
import com.android.tools.property.ptable.ColumnFraction;
import com.intellij.util.ui.JBDimension;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010 \u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010&\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010'\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010(\u001a\u00020\u0012J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/property/panel/impl/ui/InspectorLayoutManager;", "Ljava/awt/LayoutManager2;", "nameColumnFraction", "Lcom/android/tools/property/ptable/ColumnFraction;", "(Lcom/android/tools/property/ptable/ColumnFraction;)V", "lastAdded", "Lcom/android/tools/property/panel/impl/ui/Placement;", "leftWidth", "", "placementMap", "Ljava/util/HashMap;", "Ljava/awt/Component;", "Lkotlin/collections/HashMap;", "rightWidth", "rowHeights", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "totalHeight", "addLayoutComponent", "", "component", "place", "", "label", "", "computePreferredGridSize", "container", "Ljava/awt/Container;", "getLayoutAlignmentX", "", "getLayoutAlignmentY", "getRowHeight", "indexOf", "invalidateLayout", "layoutContainer", "maximumLayoutSize", "Ljava/awt/Dimension;", "minimumLayoutSize", "Lcom/intellij/util/ui/JBDimension;", "otherComponentHeight", "preferredLayoutSize", "removeAll", "removeLayoutComponent", "Companion", "intellij.android.layout-ui"})
public final class InspectorLayoutManager
implements LayoutManager2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnFraction nameColumnFraction;
    private int leftWidth;
    private int rightWidth;
    private int totalHeight;
    @NotNull
    private final IntArrayList rowHeights;
    @NotNull
    private final HashMap<Component, Placement> placementMap;
    @NotNull
    private Placement lastAdded;
    @NotNull
    private static final JBDimension MINIMUM_LAYOUT_SIZE = new JBDimension(120, 240);
    @NotNull
    private static final Dimension MAXIMUM_LAYOUT_SIZE = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public InspectorLayoutManager(@NotNull ColumnFraction nameColumnFraction) {
        Intrinsics.checkNotNullParameter((Object)nameColumnFraction, (String)"nameColumnFraction");
        this.nameColumnFraction = nameColumnFraction;
        this.leftWidth = -1;
        this.rightWidth = -1;
        this.totalHeight = -1;
        this.rowHeights = new IntArrayList(50);
        this.placementMap = new HashMap();
        this.lastAdded = Placement.LINE;
    }

    public /* synthetic */ InspectorLayoutManager(ColumnFraction columnFraction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            columnFraction = new ColumnFraction(0.0f, false, 3, null);
        }
        this(columnFraction);
    }

    @Override
    public void invalidateLayout(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.invalidateLayout();
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.computePreferredGridSize(container);
        Insets insets = container.getInsets();
        Dimension size = container.getSize();
        int width = size.width - insets.left - insets.right;
        int leftMargin = insets.left;
        int left2 = Math.max((int)((float)width * this.nameColumnFraction.getValue()), 0);
        int right = Math.max(width - left2, 0);
        int rowIndex = 0;
        int y = insets.top;
        int n = container.getComponentCount();
        for (int index2 = 0; index2 < n; ++index2) {
            Placement placement;
            Component component2 = container.getComponent(index2);
            if (!component2.isVisible()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)this.placementMap.getOrDefault(component2, Placement.LINE)), (String)"placementMap.getOrDefaul\u2026omponent, Placement.LINE)");
            int height = rowIndex < this.rowHeights.size() ? this.rowHeights.getInt(rowIndex) : component2.getPreferredSize().height;
            switch (WhenMappings.$EnumSwitchMapping$0[placement.ordinal()]) {
                case 1: {
                    component2.setBounds(leftMargin, y, left2, height);
                    break;
                }
                case 2: {
                    component2.setBounds(leftMargin + left2, y, right, height);
                    break;
                }
                case 3: {
                    component2.setBounds(leftMargin, y, width, height);
                }
            }
            if (placement == Placement.LEFT) continue;
            ++rowIndex;
            y += height;
        }
    }

    @Override
    public float getLayoutAlignmentY(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentX(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return 0.5f;
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return MAXIMUM_LAYOUT_SIZE;
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.computePreferredGridSize(container);
        return new Dimension(this.leftWidth + this.rightWidth, this.totalHeight);
    }

    @NotNull
    public JBDimension minimumLayoutSize(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return MINIMUM_LAYOUT_SIZE;
    }

    @Override
    public void addLayoutComponent(@NotNull Component component2, @Nullable Object place) {
        Placement placement;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Placement placement2 = place instanceof Placement ? (Placement)((Object)place) : null;
        if (placement2 == null) {
            placement2 = placement = Placement.LINE;
        }
        if (!(this.lastAdded != Placement.LEFT || placement == Placement.RIGHT)) {
            boolean $i$a$-require-InspectorLayoutManager$addLayoutComponent$32 = false;
            String $i$a$-require-InspectorLayoutManager$addLayoutComponent$32 = "Expected a right side component";
            throw new IllegalArgumentException($i$a$-require-InspectorLayoutManager$addLayoutComponent$32.toString());
        }
        if (!(this.lastAdded == Placement.LEFT || placement != Placement.RIGHT)) {
            boolean bl = false;
            String string = "Expected a left side component";
            throw new IllegalArgumentException(string.toString());
        }
        this.placementMap.put(component2, placement);
        this.invalidateLayout();
        this.lastAdded = placement;
    }

    @Override
    public void addLayoutComponent(@NotNull String label, @NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.addLayoutComponent(component2, (Object)Placement.LINE);
    }

    @Override
    public void removeLayoutComponent(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.placementMap.remove(component2);
        this.invalidateLayout();
    }

    public final void removeAll() {
        this.lastAdded = Placement.LINE;
        this.placementMap.clear();
        this.invalidateLayout();
    }

    public final int getRowHeight(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return Math.max(component2.getHeight(), this.otherComponentHeight(component2));
    }

    private final int otherComponentHeight(Component component2) {
        int n;
        Container container = component2.getParent();
        Placement placement = this.placementMap.getOrDefault(component2, Placement.LINE);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)placement), (String)"placementMap.getOrDefaul\u2026omponent, Placement.LINE)");
        Placement placement2 = placement;
        switch (WhenMappings.$EnumSwitchMapping$0[placement2.ordinal()]) {
            case 3: {
                n = -1;
                break;
            }
            case 1: {
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"container");
                int index2 = this.indexOf(container, component2);
                if (index2 >= 0 && index2 + 1 < container.getComponentCount()) {
                    n = container.getComponent(index2 + 1).getHeight();
                    break;
                }
                n = -1;
                break;
            }
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"container");
                int index3 = this.indexOf(container, component2);
                if (index3 > 0) {
                    n = container.getComponent(index3 - 1).getHeight();
                    break;
                }
                n = -1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final int indexOf(Container container, Component component2) {
        int n = container.getComponentCount();
        for (int index2 = 0; index2 < n; ++index2) {
            Component current = container.getComponent(index2);
            if (!Intrinsics.areEqual((Object)component2, (Object)current)) continue;
            return index2;
        }
        return -1;
    }

    private final void invalidateLayout() {
        this.leftWidth = -1;
        this.rightWidth = -1;
        this.totalHeight = -1;
        this.rowHeights.clear();
    }

    private final void computePreferredGridSize(Container container) {
        if (this.totalHeight >= 0) {
            return;
        }
        if (!(this.lastAdded != Placement.LEFT)) {
            boolean $i$a$-require-InspectorLayoutManager$computePreferredGridSize$22 = false;
            String $i$a$-require-InspectorLayoutManager$computePreferredGridSize$22 = "Expected a right side component";
            throw new IllegalArgumentException($i$a$-require-InspectorLayoutManager$computePreferredGridSize$22.toString());
        }
        int rowHeight = 0;
        int maxHeight = 0;
        int leftMaxWidth = 0;
        int rightMaxWidth = 0;
        int lineMaxWidth = 0;
        this.rowHeights.clear();
        int n = container.getComponentCount();
        for (int index2 = 0; index2 < n; ++index2) {
            Placement placement;
            Component component2 = container.getComponent(index2);
            if (!component2.isVisible()) continue;
            Dimension size = component2.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)this.placementMap.getOrDefault(component2, Placement.LINE)), (String)"placementMap.getOrDefaul\u2026omponent, Placement.LINE)");
            switch (WhenMappings.$EnumSwitchMapping$0[placement.ordinal()]) {
                case 3: {
                    lineMaxWidth = Math.max(lineMaxWidth, size.width);
                    break;
                }
                case 1: {
                    leftMaxWidth = Math.max(leftMaxWidth, size.width);
                    break;
                }
                case 2: {
                    rightMaxWidth = Math.max(rightMaxWidth, size.width);
                }
            }
            rowHeight = Math.max(rowHeight, size.height);
            if (placement == Placement.LEFT) continue;
            this.rowHeights.add(rowHeight);
            maxHeight += rowHeight;
            rowHeight = 0;
        }
        float rightFraction = 1.0f - this.nameColumnFraction.getValue();
        int width = (int)Math.max((float)leftMaxWidth / this.nameColumnFraction.getValue(), Math.max((float)rightMaxWidth / rightFraction, (float)lineMaxWidth));
        this.leftWidth = (int)((float)width * this.nameColumnFraction.getValue());
        this.rightWidth = width - this.leftWidth;
        this.totalHeight = maxHeight;
    }

    public InspectorLayoutManager() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/property/panel/impl/ui/InspectorLayoutManager$Companion;", "", "()V", "MAXIMUM_LAYOUT_SIZE", "Ljava/awt/Dimension;", "MINIMUM_LAYOUT_SIZE", "Lcom/intellij/util/ui/JBDimension;", "intellij.android.layout-ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Placement.values().length];
            nArray[Placement.LEFT.ordinal()] = 1;
            nArray[Placement.RIGHT.ordinal()] = 2;
            nArray[Placement.LINE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

