/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.property.panel.impl.model.CollapsibleLabelModel;
import com.android.tools.property.panel.impl.ui.CollapsibleLabelPanel;
import com.android.tools.property.panel.impl.ui.ExpandableLabel;
import com.android.tools.property.panel.impl.ui.FocusableActionButton;
import com.android.tools.property.panel.impl.ui.IconWithFocusBorder;
import com.android.tools.property.ptable.ColumnFraction;
import com.android.tools.property.ptable.ColumnFractionChangeHandler;
import com.google.common.html.HtmlEscapers;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ToolbarUpdater;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0012\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0014J\u0010\u00106\u001a\u0002002\u0006\u00104\u001a\u000205H\u0002J\u0010\u00107\u001a\u00020*2\u0006\u0010)\u001a\u00020*H\u0002J\b\u00108\u001a\u000200H\u0002J\b\u00109\u001a\u000200H\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R(\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010)\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/android/tools/property/panel/impl/ui/CollapsibleLabelPanel;", "Ljavax/swing/JPanel;", "model", "Lcom/android/tools/property/panel/impl/model/CollapsibleLabelModel;", "fontSize", "Lcom/intellij/util/ui/UIUtil$FontSize;", "fontStyle", "", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "nameColumnFraction", "Lcom/android/tools/property/ptable/ColumnFraction;", "(Lcom/android/tools/property/panel/impl/model/CollapsibleLabelModel;Lcom/intellij/util/ui/UIUtil$FontSize;ILjava/util/List;Lcom/android/tools/property/ptable/ColumnFraction;)V", "actionButtons", "", "Lcom/android/tools/property/panel/impl/ui/FocusableActionButton;", "expandAction", "com/android/tools/property/panel/impl/ui/CollapsibleLabelPanel$expandAction$1", "Lcom/android/tools/property/panel/impl/ui/CollapsibleLabelPanel$expandAction$1;", "expandButton", "Lcom/android/tools/property/panel/impl/ui/IconWithFocusBorder;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "value", "Ljavax/swing/border/Border;", "innerBorder", "getInnerBorder", "()Ljavax/swing/border/Border;", "setInnerBorder", "(Ljavax/swing/border/Border;)V", "label", "Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "getLabel", "()Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "getModel", "()Lcom/android/tools/property/panel/impl/model/CollapsibleLabelModel;", "resizeHandler", "Lcom/android/tools/property/ptable/ColumnFractionChangeHandler;", "text", "", "getText", "()Ljava/lang/String;", "valueWithTrailingEllipsis", "valueWithoutEllipsis", "onResizeModeChange", "", "newResizeMode", "", "paintComponent", "g", "Ljava/awt/Graphics;", "paintResizeNibs", "toHtml", "toggle", "valueChanged", "intellij.android.layout-ui"})
public final class CollapsibleLabelPanel
extends JPanel {
    @NotNull
    private final CollapsibleLabelModel model;
    @NotNull
    private final ColumnFraction nameColumnFraction;
    @NotNull
    private final ExpandableLabel label;
    @NotNull
    private final String valueWithTrailingEllipsis;
    @NotNull
    private final String valueWithoutEllipsis;
    @NotNull
    private final expandAction.1 expandAction;
    @NotNull
    private final IconWithFocusBorder expandButton;
    @NotNull
    private final List<FocusableActionButton> actionButtons;
    @NotNull
    private final ColumnFractionChangeHandler resizeHandler;

    public CollapsibleLabelPanel(@NotNull CollapsibleLabelModel model2, @NotNull UIUtil.FontSize fontSize, int fontStyle, @NotNull List<? extends AnAction> actions2, @NotNull ColumnFraction nameColumnFraction) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)fontSize, (String)"fontSize");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)nameColumnFraction, (String)"nameColumnFraction");
        super(new BorderLayout());
        this.model = model2;
        this.nameColumnFraction = nameColumnFraction;
        this.label = new ExpandableLabel();
        this.valueWithTrailingEllipsis = this.model.getName();
        this.valueWithoutEllipsis = this.toHtml(this.model.getName());
        this.expandAction = new AnAction(this){
            final /* synthetic */ CollapsibleLabelPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CollapsibleLabelPanel.access$toggle(this.this$0);
            }
        };
        this.expandButton = new IconWithFocusBorder((Function0<? extends AnAction>)((Function0)new Function0<AnAction>(this){
            final /* synthetic */ CollapsibleLabelPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final AnAction invoke() {
                return this.this$0.getModel().getExpandable() ? (AnAction)CollapsibleLabelPanel.access$getExpandAction$p(this.this$0) : null;
            }
        }));
        this.actionButtons = new ArrayList();
        this.resizeHandler = new ColumnFractionChangeHandler(this.nameColumnFraction, (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ CollapsibleLabelPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getLabel().getX();
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ CollapsibleLabelPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getWidth();
            }
        }), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)this){

            public final void invoke(boolean p0) {
                CollapsibleLabelPanel.access$onResizeModeChange((CollapsibleLabelPanel)this.receiver, p0);
            }
        }));
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.label.setActualText(this.model.getName());
        this.label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)fontSize));
        if (fontStyle != 0) {
            this.label.setFont(this.label.getFont().deriveFont(fontStyle));
        }
        this.expandButton.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        this.add((Component)((Object)this.expandButton), "West");
        this.add((Component)this.label, "Center");
        this.model.addValueChangedListener(new ValueChangedListener(){

            public final void valueChanged() {
                this.valueChanged();
            }
        });
        if (!((Collection)actions2).isEmpty()) {
            JPanel buttonPanel = new JPanel(new FlowLayout(1, JBUI.scale((int)2), 0));
            Iterable $this$forEach$iv = actions2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnAction it = (AnAction)element$iv;
                boolean bl = false;
                FocusableActionButton button = new FocusableActionButton(it);
                buttonPanel.add((Component)((Object)button));
                this.actionButtons.add(button);
            }
            this.add((Component)buttonPanel, "East");
            new ToolbarUpdater(){

                protected void updateActionsImpl(boolean forced) {
                    if (!ApplicationManager.getApplication().isDisposed()) {
                        Iterable $this$forEach$iv = actionButtons;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            FocusableActionButton it = (FocusableActionButton)((Object)element$iv);
                            boolean bl = false;
                            it.update();
                        }
                    }
                }
            };
        }
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getClickCount() > 1) {
                    this.toggle();
                }
            }
        });
        this.label.addMouseListener(this.resizeHandler);
        this.label.addMouseMotionListener(this.resizeHandler);
        this.valueChanged();
    }

    public /* synthetic */ CollapsibleLabelPanel(CollapsibleLabelModel collapsibleLabelModel, UIUtil.FontSize fontSize, int n, List list2, ColumnFraction columnFraction, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x10) != 0) {
            columnFraction = new ColumnFraction(0.0f, false, 3, null);
        }
        this(collapsibleLabelModel, fontSize, n, list2, columnFraction);
    }

    @NotNull
    public final CollapsibleLabelModel getModel() {
        return this.model;
    }

    @NotNull
    public final ExpandableLabel getLabel() {
        return this.label;
    }

    @Nullable
    public final String getText() {
        return this.label.getText();
    }

    @Nullable
    public final Icon getIcon() {
        return this.expandButton.getIcon();
    }

    @Nullable
    public final Border getInnerBorder() {
        return this.label.getBorder();
    }

    public final void setInnerBorder(@Nullable Border value2) {
        this.label.setBorder(value2);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.resizeHandler.getResizeMode()) {
            this.paintResizeNibs(g);
        }
    }

    private final void paintResizeNibs(Graphics g) {
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor((Color)StudioColorsKt.getSelectionBackground());
        int x = MathKt.roundToInt((float)((float)this.getWidth() * this.nameColumnFraction.getValue()));
        g2.drawLine(x, 0, x, this.getHeight());
        g2.dispose();
    }

    private final void onResizeModeChange(boolean newResizeMode) {
        this.label.setCursor(Cursor.getPredefinedCursor(newResizeMode ? 10 : 0));
        this.repaint();
    }

    private final void toggle() {
        this.model.setExpanded(!this.model.getExpanded());
    }

    private final void valueChanged() {
        block1: {
            Container revalidateParent = this.isVisible() != this.model.getVisible() ? this.getParent() : null;
            this.setVisible(this.model.getVisible());
            this.label.setVisible(this.isVisible());
            this.label.setText(this.model.getShowEllipses() ? this.valueWithTrailingEllipsis : this.valueWithoutEllipsis);
            this.label.setForeground(this.model.getEnabled() ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground());
            this.expandButton.setIcon(this.model.getIcon());
            Container container = revalidateParent;
            if (container != null) {
                container.revalidate();
            }
            Container container2 = revalidateParent;
            if (container2 == null) break block1;
            container2.repaint();
        }
    }

    private final String toHtml(String text2) {
        return "<html><nobr>" + HtmlEscapers.htmlEscaper().escape(text2) + "</nobr></html>";
    }

    public static final /* synthetic */ expandAction.1 access$getExpandAction$p(CollapsibleLabelPanel $this) {
        return $this.expandAction;
    }

    public static final /* synthetic */ void access$onResizeModeChange(CollapsibleLabelPanel $this, boolean newResizeMode) {
        $this.onResizeModeChange(newResizeMode);
    }
}

