/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.support;

import com.android.tools.property.panel.api.PropertiesTable;
import com.android.tools.property.panel.api.PropertyItem;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u001f\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"R\u0016\u0010\b\u001a\u0004\u0018\u00018\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/android/tools/property/panel/impl/support/PropertiesTableImpl;", "P", "Lcom/android/tools/property/panel/api/PropertyItem;", "Lcom/android/tools/property/panel/api/PropertiesTable;", "table", "Lcom/google/common/collect/Table;", "", "(Lcom/google/common/collect/Table;)V", "first", "getFirst", "()Lcom/android/tools/property/panel/api/PropertyItem;", "isEmpty", "", "()Z", "namespaces", "", "getNamespaces", "()Ljava/util/Collection;", "size", "", "getSize", "()I", "values", "getValues", "get", "namespace", "name", "(Ljava/lang/String;Ljava/lang/String;)Lcom/android/tools/property/panel/api/PropertyItem;", "getByNamespace", "", "getOrNull", "put", "", "property", "(Lcom/android/tools/property/panel/api/PropertyItem;)V", "intellij.android.layout-ui"})
public final class PropertiesTableImpl<P extends PropertyItem>
implements PropertiesTable<P> {
    @NotNull
    private final Table<String, String, P> table;

    public PropertiesTableImpl(@NotNull Table<String, String, P> table2) {
        Intrinsics.checkNotNullParameter(table2, (String)"table");
        this.table = table2;
    }

    @Override
    @NotNull
    public P get(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PropertyItem propertyItem = (PropertyItem)this.table.get((Object)namespace, (Object)name);
        if (propertyItem == null) {
            throw new NoSuchElementException();
        }
        return (P)propertyItem;
    }

    @Override
    @Nullable
    public P getOrNull(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (P)((PropertyItem)this.table.get((Object)namespace, (Object)name));
    }

    @Override
    public void put(@NotNull P property2) {
        Intrinsics.checkNotNullParameter(property2, (String)"property");
        this.table.put((Object)property2.getNamespace(), (Object)property2.getName(), property2);
    }

    @Override
    @NotNull
    public Map<String, P> getByNamespace(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Map map2 = this.table.row((Object)namespace);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"table.row(namespace)");
        return map2;
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    @Nullable
    public P getFirst() {
        Collection collection2 = this.table.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"table.values()");
        return (P)((PropertyItem)CollectionsKt.firstOrNull((Iterable)collection2));
    }

    @Override
    public int getSize() {
        return this.table.size();
    }

    @Override
    @NotNull
    public Collection<P> getValues() {
        Collection collection2 = this.table.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"table.values()");
        return collection2;
    }

    @Override
    @NotNull
    public Collection<String> getNamespaces() {
        Set set = this.table.rowKeySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"table.rowKeySet()");
        return set;
    }
}

