/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.ui;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class WizardUtils {
    @NotNull
    public static File getProjectLocationParent() {
        String parent2 = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent2 != null) {
            return new File(PathUtil.toSystemDependentName((String)parent2));
        }
        String defaultProjectLocation = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (defaultProjectLocation != null && !defaultProjectLocation.isEmpty()) {
            return new File(defaultProjectLocation);
        }
        String child = ApplicationNamesInfo.getInstance().getFullProductName().replace(" ", "") + "Projects";
        return new File(SystemProperties.getUserHome(), child);
    }

    @NotNull
    public static String toHtmlString(@NotNull String text2) {
        if (!StringUtil.isEmpty((String)text2) && !text2.startsWith("<html>")) {
            text2 = text2.trim().replaceAll("\n", "<br>");
            return String.format("<html>%1$s</html>", text2);
        }
        return text2;
    }

    @NotNull
    public static JBScrollPane wrapWithVScroll(@NotNull JPanel innerPanel2) {
        return WizardUtils.wrapWithVScroll(innerPanel2, WIZARD_BORDER.LARGE);
    }

    @NotNull
    public static JBScrollPane wrapWithVScroll(@NotNull JPanel innerPanel2, WIZARD_BORDER wizardBorder) {
        JBScrollPane sp = new JBScrollPane((Component)innerPanel2, 20, 31);
        sp.setBorder(WIZARD_BORDER.EMPTY.border);
        innerPanel2.setBorder(wizardBorder.border);
        return sp;
    }

    public static enum WIZARD_BORDER {
        EMPTY((Border)JBUI.Borders.empty()),
        SMALL(JBUI.Borders.empty((int)16)),
        LARGE((Border)JBUI.Borders.empty((int)0, (int)72));

        public final Border border;

        private WIZARD_BORDER(Border border) {
            this.border = border;
        }
    }
}

