/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.repository.Revision;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.whatsnew.assistant.WhatsNewBundleCreator;
import com.android.tools.idea.whatsnew.assistant.WhatsNewCheckVersionTask;
import com.android.tools.idea.whatsnew.assistant.WhatsNewSidePanelAction;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.xmlb.annotations.Tag;
import org.apache.http.concurrent.FutureCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhatsNewStartupActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        WhatsNewBundleCreator bundleCreator = (WhatsNewBundleCreator)AssistantBundleCreator.EP_NAME.findExtension(WhatsNewBundleCreator.class);
        if (bundleCreator == null || !bundleCreator.shouldShowWhatsNew()) {
            return;
        }
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        WhatsNewService service = (WhatsNewService)ApplicationManager.getApplication().getService(WhatsNewService.class);
        if (service == null) {
            return;
        }
        WhatsNewData data2 = service.getState();
        if (GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Revision applicationRevision = Revision.safeParseRevision((String)ApplicationInfo.getInstance().getStrictVersion());
        if (this.isNewStudioVersion(data2, applicationRevision)) {
            WhatsNewStartupActivity.hideTipsAndOpenWhatsNewAssistant(project);
        } else {
            WhatsNewCheckVersionTask task2 = new WhatsNewCheckVersionTask(project, new VersionCheckCallback(project));
            task2.queue();
        }
    }

    private static void hideTipsAndOpenWhatsNewAssistant(@NotNull Project project) {
        WhatsNewStartupActivity.hideTipsAndOpenWhatsNewAssistant(project, GeneralSettings.getInstance(), null);
    }

    @VisibleForTesting
    static void hideTipsAndOpenWhatsNewAssistant(@NotNull Project project, @NotNull GeneralSettings generalSettings, @Nullable FutureCallback<? super Boolean> callback) {
        boolean showTipsOnStartup = generalSettings.isShowTipsOnStartup();
        if (showTipsOnStartup) {
            generalSettings.setShowTipsOnStartup(false);
        }
        WhatsNewStartupActivity.openWhatsNewAssistant(project);
        if (showTipsOnStartup) {
            ApplicationManager.getApplication().invokeLater(() -> {
                generalSettings.setShowTipsOnStartup(true);
                if (callback != null) {
                    callback.completed((Object)true);
                }
            });
        } else if (callback != null) {
            callback.completed((Object)true);
        }
    }

    private static void openWhatsNewAssistant(@NotNull Project project) {
        ((WhatsNewSidePanelAction)ActionManager.getInstance().getAction("WhatsNewAction")).openWhatsNewSidePanel(project, true);
    }

    @VisibleForTesting
    boolean isNewStudioVersion(@NotNull WhatsNewData data2, @NotNull Revision applicationRevision) {
        String seenRevisionStr = data2.myRevision;
        Revision seenRevision = null;
        if (seenRevisionStr != null) {
            seenRevision = Revision.safeParseRevision((String)seenRevisionStr);
        }
        if (seenRevision == null || seenRevision.equals((Object)Revision.NOT_SPECIFIED) || applicationRevision.equals((Object)Revision.NOT_SPECIFIED) || applicationRevision.compareTo(seenRevision, Revision.PreviewComparison.ASCENDING) > 0) {
            data2.myRevision = applicationRevision.toString();
            return true;
        }
        return false;
    }

    private static class VersionCheckCallback
    implements FutureCallback<Boolean> {
        private Project myProject;

        private VersionCheckCallback(Project project) {
            this.myProject = project;
        }

        public void cancelled() {
        }

        public void completed(Boolean result2) {
            if (result2.booleanValue()) {
                WhatsNewStartupActivity.hideTipsAndOpenWhatsNewAssistant(this.myProject);
            }
        }

        public void failed(Exception ex) {
            Logger.getInstance(WhatsNewStartupActivity.class).error((Throwable)ex);
        }
    }

    @VisibleForTesting
    public static class WhatsNewData {
        @Tag(value="shownVersion")
        public String myRevision;
    }

    @State(name="whatsNew", storages={@Storage(value="androidStudioFirstRun.xml")})
    public static class WhatsNewService
    implements PersistentStateComponent<WhatsNewData> {
        private WhatsNewData myData;

        @NotNull
        public WhatsNewData getState() {
            if (this.myData == null) {
                this.myData = new WhatsNewData();
            }
            return this.myData;
        }

        public void loadState(@NotNull WhatsNewData state2) {
            this.myData = state2;
        }
    }
}

