/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.PanelFactory;
import com.android.tools.idea.whatsnew.assistant.ActionButtonMetricsEventBuilder;
import com.android.tools.idea.whatsnew.assistant.WhatsNewUpdateStatusPanelFactory;
import com.google.common.base.Stopwatch;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.WhatsNewAssistantUpdateEvent;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class WhatsNewMetricsTracker {
    @NotNull
    private final Map<Project, MetricsEventBuilder> myProjectToBuilderMap = new HashMap<Project, MetricsEventBuilder>();
    @NotNull
    private final Map<Project, ActionButtonMetricsEventBuilder> myProjectToActionBuilderMap = new HashMap<Project, ActionButtonMetricsEventBuilder>();

    WhatsNewMetricsTracker() {
    }

    @NotNull
    public static WhatsNewMetricsTracker getInstance() {
        return Objects.requireNonNull((WhatsNewUpdateStatusPanelFactory)PanelFactory.EP_NAME.findExtension(WhatsNewUpdateStatusPanelFactory.class)).getMetricsTracker();
    }

    void open(@NotNull Project project, boolean isAutoOpened) {
        this.myProjectToBuilderMap.computeIfAbsent(project, p -> {
            MetricsEventBuilder eventBuilder = new MetricsEventBuilder();
            eventBuilder.myBuilder.setAutoOpened(isAutoOpened);
            this.getActionsMetricsBuilder(project).generateEventsForAllCreatedBeforeActions(project).forEach(eventBuilder::addActionButtonEvent);
            return eventBuilder;
        });
    }

    private ActionButtonMetricsEventBuilder getActionsMetricsBuilder(@NotNull Project project) {
        return this.myProjectToActionBuilderMap.computeIfAbsent(project, p -> new ActionButtonMetricsEventBuilder());
    }

    void clearCachedActionKeys(@NotNull Project project) {
        this.myProjectToActionBuilderMap.remove(project);
    }

    void updateFlow(@NotNull Project project) {
        this.myProjectToBuilderMap.get((Object)project).myBuilder.setUpdateFlow(true);
    }

    void scrolledToBottom(@NotNull Project project) {
        MetricsEventBuilder metricsEventBuilder = this.myProjectToBuilderMap.get(project);
        if (metricsEventBuilder != null) {
            metricsEventBuilder.scrolledToBottom();
        }
    }

    public void actionButtonCreated(@NotNull Project project, @NotNull String actionKey) {
        this.actionButtonEvent(project, this.getActionsMetricsBuilder(project).actionCreated(project, actionKey));
    }

    public void clickActionButton(@NotNull Project project, @NotNull String actionKey) {
        this.actionButtonEvent(project, this.getActionsMetricsBuilder(project).clickAction(project, actionKey));
    }

    public void stateUpdateActionButton(@NotNull Project project, @NotNull String actionKey) {
        this.actionButtonEvent(project, this.getActionsMetricsBuilder(project).stateUpdateAction(project, actionKey));
    }

    private void actionButtonEvent(@NotNull Project project, @NotNull WhatsNewAssistantUpdateEvent.ActionButtonEvent.Builder actionButtonEvent) {
        MetricsEventBuilder metricsEventBuilder = this.myProjectToBuilderMap.get(project);
        if (metricsEventBuilder != null) {
            metricsEventBuilder.addActionButtonEvent(actionButtonEvent);
        }
    }

    public void dismissed(@NotNull Project project) {
        this.myProjectToBuilderMap.get((Object)project).myBuilder.setDismissed(true);
    }

    public void setUpdateTime(@NotNull Project project) {
        this.myProjectToBuilderMap.get(project).setUpdateTime();
    }

    void close(@NotNull Project project) {
        this.myProjectToBuilderMap.remove(project).buildAndLog();
    }

    private static class MetricsEventBuilder {
        @NotNull
        final WhatsNewAssistantUpdateEvent.Builder myBuilder = WhatsNewAssistantUpdateEvent.newBuilder();
        @NotNull
        final Stopwatch myStopwatch = Stopwatch.createStarted();

        private MetricsEventBuilder() {
        }

        private void setUpdateTime() {
            this.myBuilder.setTimeToUpdateMs(this.myStopwatch.elapsed().toMillis());
        }

        private void scrolledToBottom() {
            this.myBuilder.setScrolledToBottom(true);
            this.myBuilder.setTimeToScrolledToBottom(this.myStopwatch.elapsed().toMillis());
        }

        private void buildAndLog() {
            this.myBuilder.setTimeToCloseMs(this.myStopwatch.elapsed().toMillis());
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.WHATS_NEW_ASSISTANT_UPDATE_EVENT).setWhatsNewAssistantUpdateEvent(this.myBuilder));
        }

        public void addActionButtonEvent(WhatsNewAssistantUpdateEvent.ActionButtonEvent.Builder actionButtonEvent) {
            this.myBuilder.addActionButtonEvents(actionButtonEvent.setTimeFromWnaOpen(this.myStopwatch.elapsed().toMillis()));
        }
    }
}

