/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.repository.Revision;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.whatsnew.assistant.WhatsNewBundle;
import com.android.tools.idea.whatsnew.assistant.WhatsNewConnectionOpener;
import com.android.tools.idea.whatsnew.assistant.WhatsNewURLProvider;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhatsNewBundleCreator
implements AssistantBundleCreator {
    public static final String BUNDLE_ID = "DeveloperServices.WhatsNewAssistant";
    private static AssistantBundleCreator ourTestCreator = null;
    @NotNull
    private WhatsNewURLProvider myURLProvider;
    @NotNull
    private WhatsNewConnectionOpener myConnectionOpener;
    @NotNull
    private Revision myStudioRevision;
    @NotNull
    private Revision myLastSeenVersion;
    private boolean myAllowDownload;

    public WhatsNewBundleCreator() {
        this(new WhatsNewURLProvider(), Revision.safeParseRevision((String)ApplicationInfo.getInstance().getStrictVersion()), new WhatsNewConnectionOpener(), true);
    }

    public WhatsNewBundleCreator(@NotNull WhatsNewURLProvider urlProvider, @NotNull Revision studioRevision) {
        this(urlProvider, studioRevision, new WhatsNewConnectionOpener(), true);
    }

    @VisibleForTesting
    public WhatsNewBundleCreator(@NotNull WhatsNewURLProvider urlProvider, @NotNull Revision studioRevision, @NotNull WhatsNewConnectionOpener connectionOpener, boolean allowDownload) {
        this.myURLProvider = urlProvider;
        this.myConnectionOpener = connectionOpener;
        this.myStudioRevision = studioRevision;
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            this.myStudioRevision = Revision.NOT_SPECIFIED;
        }
        this.myLastSeenVersion = Revision.NOT_SPECIFIED;
        this.myAllowDownload = allowDownload;
    }

    @VisibleForTesting
    void setURLProvider(@NotNull WhatsNewURLProvider urlProvider) {
        this.myURLProvider = urlProvider;
    }

    @VisibleForTesting
    void setStudioRevision(@NotNull Revision revision) {
        this.myStudioRevision = revision;
    }

    @VisibleForTesting
    void setAllowDownload(boolean allowDownload) {
        this.myAllowDownload = allowDownload;
    }

    @Override
    @NotNull
    public String getBundleId() {
        return BUNDLE_ID;
    }

    @Override
    @Nullable
    public WhatsNewBundle getBundle(@NotNull Project project) {
        assert (ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
        this.updateConfig();
        return this.parseBundle();
    }

    @Override
    @Nullable
    public URL getConfig() {
        return null;
    }

    public boolean isNewConfigVersion() {
        assert (ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
        WhatsNewBundle oldBundle = this.parseBundle();
        if (oldBundle != null) {
            this.myLastSeenVersion = oldBundle.getVersion();
        }
        this.updateConfig();
        WhatsNewBundle newBundle = this.parseBundle();
        if (newBundle != null) {
            if (this.myLastSeenVersion.equals((Object)Revision.NOT_SPECIFIED)) {
                return true;
            }
            return newBundle.getVersion().compareTo(this.myLastSeenVersion) > 0;
        }
        return false;
    }

    @Nullable
    private WhatsNewBundle parseBundle() {
        WhatsNewBundle bundle2 = this.parseBundleWorker();
        if (bundle2 != null) {
            return bundle2;
        }
        try {
            Path path2 = this.myURLProvider.getLocalConfig(this.getStudioRevision());
            Files.delete(path2);
        }
        catch (IOException e) {
            WhatsNewBundleCreator.getLog().warn("Error deleting cached file", (Throwable)e);
            return null;
        }
        WhatsNewBundleCreator.getLog().info("Retrying WNA parseBundle after deleting possibly corrupt file.");
        this.updateConfig();
        return this.parseBundleWorker();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private WhatsNewBundle parseBundleWorker() {
        try (InputStream configStream = this.openConfigStream();){
            if (configStream == null) {
                WhatsNewBundle whatsNewBundle2 = null;
                return whatsNewBundle2;
            }
            WhatsNewBundle whatsNewBundle = DefaultTutorialBundle.parse(configStream, WhatsNewBundle.class, this.getBundleId());
            return whatsNewBundle;
        }
        catch (Exception e) {
            WhatsNewBundleCreator.getLog().warn("Error parsing bundle", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private InputStream openConfigStream() throws FileNotFoundException {
        Path path2 = this.myURLProvider.getLocalConfig(this.getStudioRevision());
        if (Files.exists(path2, new LinkOption[0])) {
            return new FileInputStream(path2.toFile());
        }
        return this.myURLProvider.getResourceFileAsStream(this, this.getStudioRevision());
    }

    private void updateConfig() {
        if (this.myAllowDownload && !this.myStudioRevision.equals((Object)Revision.parseRevision((String)"0.0.0rc0"))) {
            URL webConfig = this.myURLProvider.getWebConfig(this.getStudioRevision());
            Path localConfigPath = this.myURLProvider.getLocalConfig(this.getStudioRevision());
            this.downloadConfig(webConfig, localConfigPath);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean downloadConfig(@NotNull URL sourceUrl, @NotNull Path destinationFilePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private String getStudioRevision() {
        return this.myStudioRevision.getMajor() + "." + this.myStudioRevision.getMinor() + "." + this.myStudioRevision.getMicro();
    }

    public boolean shouldShowWhatsNew() {
        if (!WhatsNewBundleCreator.shouldShowReleaseNotes()) {
            return false;
        }
        return this.hasResourceConfig();
    }

    @VisibleForTesting
    static boolean shouldShowReleaseNotes() {
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return false;
        }
        Optional<AssistantBundleCreator> creator = WhatsNewBundleCreator.getCreator();
        return creator.isPresent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    boolean hasResourceConfig() {
        try (InputStream stream = this.myURLProvider.getResourceFileAsStream(this, this.getStudioRevision());){
            if (stream == null) {
                boolean bl2 = false;
                return bl2;
            }
            WhatsNewBundle bundle2 = DefaultTutorialBundle.parse(stream, WhatsNewBundle.class, this.getBundleId());
            boolean bl = this.myStudioRevision.equals((Object)Revision.parseRevision((String)"0.0.0rc0")) || this.isBundleRevisionSame(bundle2.getVersion());
            return bl;
        }
        catch (Exception e) {
            WhatsNewBundleCreator.getLog().warn((Throwable)e);
            return false;
        }
    }

    private boolean isBundleRevisionSame(@NotNull Revision revision) {
        return revision.getMajor() == this.myStudioRevision.getMajor() && revision.getMinor() == this.myStudioRevision.getMinor();
    }

    @VisibleForTesting
    public static void setTestCreator(@Nullable AssistantBundleCreator testCreator) {
        ourTestCreator = testCreator;
    }

    private static Optional<AssistantBundleCreator> getCreator() {
        if (ourTestCreator != null) {
            return Optional.of(ourTestCreator);
        }
        return Arrays.stream((AssistantBundleCreator[])AssistantBundleCreator.EP_NAME.getExtensions()).filter(extension -> extension.getBundleId().equals(BUNDLE_ID)).findFirst();
    }

    private static Logger getLog() {
        return Logger.getInstance(WhatsNewBundleCreator.class);
    }
}

