/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.ui.LabelAndFileForLocation;
import com.android.tools.idea.gradle.ui.SdkUiStrings;
import com.android.tools.idea.gradle.ui.SdkUiUtils;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizardStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkSetupStep
extends FirstRunWizardStep {
    private ComboboxWithBrowseButton myJdkLocationComboBox;
    private JBLabel myJdkLocationHelp;
    private JBScrollPane myContents;

    public JdkSetupStep() {
        super("Select default JDK Location");
        this.$$$setupUI$$$();
        this.setUpJdkLocationComboBox();
        this.setComponent((JComponent)this.myContents);
        this.createUIComponents();
    }

    private void setUpJdkLocationComboBox() {
        String javaHomePath;
        Path validatedPath;
        FileChooserDescriptor descriptor2 = JdkSetupStep.createSingleFolderDescriptor((Function<? super Path, Void>)((Function)file2 -> {
            Path validatedFile = this.validateJdkPath((Path)file2);
            if (validatedFile == null) {
                throw new IllegalArgumentException(SdkUiStrings.generateChooseValidJdkDirectoryError());
            }
            this.setJdkLocationComboBox((Path)file2);
            return null;
        }));
        this.myJdkLocationComboBox.addBrowseFolderListener(this.getProject(), descriptor2);
        JComboBox comboBox2 = this.myJdkLocationComboBox.getComboBox();
        IdeSdks ideSdks = IdeSdks.getInstance();
        Path embeddedPath = ideSdks.getEmbeddedJdkPath();
        if (embeddedPath != null && (validatedPath = this.validateJdkPath(embeddedPath)) != null) {
            comboBox2.addItem(new LabelAndFileForLocation("Embedded JDK", validatedPath));
        }
        if ((javaHomePath = IdeSdks.getJdkFromJavaHome()) != null) {
            boolean isJavaHomeValid;
            Path validatedPath2 = this.validateJdkPath(Paths.get(javaHomePath, new String[0]));
            boolean bl = isJavaHomeValid = validatedPath2 != null;
            if (isJavaHomeValid) {
                comboBox2.addItem(new LabelAndFileForLocation("JAVA_HOME", validatedPath2));
            }
        }
        comboBox2.setEditable(true);
        comboBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object selectedItem;
                if (event.getStateChange() == 1 && (selectedItem = event.getItem()) instanceof LabelAndFileForLocation) {
                    ApplicationManager.getApplication().invokeLater(() -> JdkSetupStep.this.setJdkLocationComboBox(((LabelAndFileForLocation)selectedItem).getFile()));
                }
            }
        });
        this.setJdkLocationComboBox(embeddedPath);
    }

    private void setJdkLocationComboBox(@Nullable Path path2) {
        this.myJdkLocationComboBox.getComboBox().setSelectedItem(path2 == null ? null : path2.toString());
        this.updateIsValidPath();
    }

    private void createUIComponents() {
        this.myJdkLocationHelp = ContextHelpLabel.createWithLink(null, (String)"To share the same Gradle daemon between Android Studio and other external processes, create a JAVA_HOME environment variable with a valid JDK location and select it from the dropdown below.", (String)"Learn more", () -> BrowserUtil.browse((String)"https://docs.gradle.org/current/userguide/gradle_daemon.html#sec:why_is_there_more_than_one_daemon_process_on_my_machine"));
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(final @NotNull Function<? super Path, Void> validation2) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files2) {
                for (VirtualFile virtualFile : files2) {
                    validation2.fun((Object)virtualFile.toNioPath());
                }
            }
        };
        if (SystemInfo.isMac) {
            descriptor2.withShowHiddenFiles(true);
        }
        descriptor2.setTitle("Choose JDK Location");
        return descriptor2;
    }

    private void updateIsValidPath() {
        this.invokeUpdate(null);
    }

    @Nullable
    private Path validateJdkPath(@NotNull Path file2) {
        Path possiblePath = IdeSdks.getInstance().validateJdkPath(file2);
        if (possiblePath != null) {
            if (!possiblePath.equals(file2)) {
                this.setJdkLocationComboBox(possiblePath);
            }
            return possiblePath;
        }
        return null;
    }

    @Override
    public void init() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        this.setJdkLocationComboBox(ideSdks.getEmbeddedJdkPath());
    }

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJdkLocationComboBox;
    }

    @Override
    public boolean validate() {
        if (!this.isValidJdkPath()) {
            return false;
        }
        return super.validate();
    }

    private boolean isValidJdkPath() {
        return this.validateJdkPath(this.getJdkLocation()) != null;
    }

    @Override
    public boolean commitStep() {
        if (!this.isValidJdkPath()) {
            return false;
        }
        Path path2 = this.getJdkLocation();
        IdeSdks.findOrCreateJdk("Android Studio default JDK", path2);
        this.myState.put(WizardConstants.KEY_JDK_LOCATION, path2.toString());
        return true;
    }

    @NotNull
    private Path getJdkLocation() {
        return SdkUiUtils.getLocationFromComboBoxWithBrowseButton(this.myJdkLocationComboBox);
    }

    @Override
    public boolean isStepVisible() {
        return (Boolean)StudioFlags.NPW_SHOW_JDK_STEP.get() != false && Boolean.TRUE.equals(this.myState.get(FirstRunWizard.KEY_CUSTOM_INSTALL));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JBScrollPane jBScrollPane;
        this.createUIComponents();
        this.myContents = jBScrollPane = new JBScrollPane();
        jBScrollPane.setPreferredSize(new Dimension(548, 315));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Select the Java Development Kit (JDK) you want Gradle to use when building your project.");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JBLabel jBLabel2 = this.myJdkLocationHelp;
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 10, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myJdkLocationComboBox = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(2, 0, 1, 1, 9, 0, 3, 3, new Dimension(518, -1), new Dimension(518, -1), new Dimension(518, -1)));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContents;
    }
}

