/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.sdk.wizard.legacy.LicenseAgreementStep;
import com.android.tools.idea.ui.ApplicationUtils;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.AndroidSdk;
import com.android.tools.idea.welcome.install.AndroidVirtualDevice;
import com.android.tools.idea.welcome.install.CheckSdkOperation;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.Gvm;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallComponentsOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.InstallationIntention;
import com.android.tools.idea.welcome.install.Platform;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.deprecated.InstallSummaryStep;
import com.android.tools.idea.welcome.wizard.deprecated.LongRunningOperationPath;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.welcome.wizard.deprecated.SdkComponentsStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsPath
extends DynamicWizardPath
implements LongRunningOperationPath {
    @NotNull
    private final FirstRunWizardMode myMode;
    private AndroidSdkHandler myLocalHandler;
    private ComponentTreeNode myComponentTree;
    private final ProgressStep myProgressStep;
    @NotNull
    private ComponentInstaller myComponentInstaller;
    private final boolean myInstallUpdates;
    private SdkComponentsStep myComponentsStep;
    @Nullable
    private LicenseAgreementStep myLicenseAgreementStep;

    public InstallComponentsPath(@NotNull FirstRunWizardMode mode, @NotNull File sdkLocation, @NotNull ProgressStep progressStep, boolean installUpdates) {
        this.myMode = mode;
        this.myLocalHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)sdkLocation.toPath());
        this.myProgressStep = progressStep;
        this.myComponentInstaller = new ComponentInstaller(this.myLocalHandler);
        this.myInstallUpdates = installUpdates;
    }

    private ComponentTreeNode createComponentTree(@NotNull FirstRunWizardMode reason, boolean createAvd2) {
        InstallationIntention installationIntention;
        ArrayList<ComponentTreeNode> components = new ArrayList<ComponentTreeNode>();
        components.add(new AndroidSdk(this.myInstallUpdates));
        RepoManager sdkManager = this.myLocalHandler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, null, null, (ProgressRunner)new StudioProgressRunner(true, false, "Finding Available SDK Components", null), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        Map remotePackages = sdkManager.getPackages().getRemotePackages();
        ComponentTreeNode platforms = Platform.Companion.createSubtree(remotePackages, this.myInstallUpdates);
        if (platforms != null) {
            components.add(platforms);
        }
        InstallationIntention installationIntention2 = installationIntention = this.myInstallUpdates ? InstallationIntention.INSTALL_WITH_UPDATES : InstallationIntention.INSTALL_WITHOUT_UPDATES;
        if (reason == FirstRunWizardMode.NEW_INSTALL && Haxm.InstallerInfo.canRun()) {
            components.add(new Haxm(installationIntention, FirstRunWizard.KEY_CUSTOM_INSTALL));
        }
        if (reason == FirstRunWizardMode.NEW_INSTALL && Gvm.InstallerInfo.canRun()) {
            components.add(new Gvm(installationIntention, FirstRunWizard.KEY_CUSTOM_INSTALL));
        }
        if (createAvd2) {
            components.add(new AndroidVirtualDevice(remotePackages, this.myInstallUpdates));
        }
        return new ComponentCategory("Root", "Root node that is not supposed to appear in the UI", components);
    }

    private static File createTempDir() throws WizardException {
        File tempDirectory;
        try {
            tempDirectory = FileUtil.createTempDirectory((String)"AndroidStudio", (String)"FirstRun", (boolean)true);
        }
        catch (IOException e) {
            throw new WizardException("Unable to create temporary folder: " + e.getMessage(), e);
        }
        return tempDirectory;
    }

    @Override
    protected void init() {
        File location2 = this.myLocalHandler.getLocation().toFile();
        assert (location2 != null);
        this.myState.put(WizardConstants.KEY_SDK_INSTALL_LOCATION, location2.getAbsolutePath());
        Path file2 = null;
        if (!IdeInfo.getInstance().isGameTools()) {
            file2 = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
        }
        if (file2 != null) {
            this.myState.put(WizardConstants.KEY_JDK_LOCATION, file2.toString());
        }
        this.myComponentTree = this.createComponentTree(this.myMode, !HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated() && this.myMode.shouldCreateAvd());
        this.myComponentTree.init(this.myProgressStep);
        this.myComponentsStep = new SdkComponentsStep(this.myComponentTree, FirstRunWizard.KEY_CUSTOM_INSTALL, WizardConstants.KEY_SDK_INSTALL_LOCATION, this.myMode, this.myWizard.getDisposable());
        this.addStep(this.myComponentsStep);
        this.myComponentTree.init(this.myProgressStep);
        this.myComponentTree.updateState(this.myLocalHandler);
        for (DynamicWizardStep step2 : this.myComponentTree.createSteps()) {
            this.addStep(step2);
        }
        if (this.myMode != FirstRunWizardMode.INSTALL_HANDOFF) {
            Supplier<Collection> supplier2 = () -> {
                Collection<InstallableComponent> components = this.myComponentTree.getChildrenToInstall();
                try {
                    return this.myComponentInstaller.getPackagesToInstall(components);
                }
                catch (SdkQuickfixUtils.PackageResolutionException e) {
                    Logger.getInstance(InstallComponentsPath.class).warn((Throwable)e);
                    return null;
                }
            };
            this.addStep(new InstallSummaryStep(FirstRunWizard.KEY_CUSTOM_INSTALL, WizardConstants.KEY_SDK_INSTALL_LOCATION, WizardConstants.KEY_JDK_LOCATION, supplier2));
            Supplier<List<String>> installRequests = () -> {
                Collection remotePackages = (Collection)supplier2.get();
                return remotePackages == null ? null : remotePackages.stream().map(it -> it.getPath()).collect(Collectors.toList());
            };
            this.myLicenseAgreementStep = new LicenseAgreementStep(this.myWizard.getDisposable(), installRequests, () -> this.myLocalHandler);
            this.addStep(this.myLicenseAgreementStep);
        }
    }

    @Override
    public void deriveValues(Set<? extends ScopedStateStore.Key> modified) {
        String sdkPath;
        super.deriveValues(modified);
        if (modified.contains(WizardConstants.KEY_SDK_INSTALL_LOCATION) && (sdkPath = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION)) != null) {
            File sdkLocation = new File(sdkPath);
            if (!FileUtil.filesEqual((File)this.myLocalHandler.getLocation().toFile(), (File)sdkLocation)) {
                this.myLocalHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)this.myLocalHandler.toCompatiblePath(sdkLocation));
                StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
                this.myComponentsStep.startLoading();
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    this.myLocalHandler.getSdkManager((ProgressIndicator)progress2).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of(packages -> {
                        this.myComponentInstaller = new ComponentInstaller(this.myLocalHandler);
                        this.myComponentTree.updateState(this.myLocalHandler);
                        this.myComponentsStep.stopLoading();
                    }), (List)ImmutableList.of(() -> this.myComponentsStep.loadingError()), (ProgressRunner)new StudioProgressRunner(false, false, "Finding Available SDK Components", this.getProject()), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
                    if (this.myLicenseAgreementStep != null) {
                        this.myLicenseAgreementStep.reload();
                    }
                });
            }
        }
    }

    @Override
    @NotNull
    public String getPathName() {
        return "Setup Android Studio Components";
    }

    @Override
    public void runLongOperation() throws WizardException {
        double INSTALL_COMPONENTS_OPERATION_PROGRESS_SHARE = 1.0;
        InstallContext installContext = new InstallContext(InstallComponentsPath.createTempDir(), this.myProgressStep);
        File destination = this.getDestination();
        Collection<InstallableComponent> selectedComponents = this.myComponentTree.getChildrenToInstall();
        CheckSdkOperation checkSdk = new CheckSdkOperation(installContext);
        InstallComponentsOperation install2 = new InstallComponentsOperation(installContext, selectedComponents, this.myComponentInstaller, 1.0);
        if (this.myLicenseAgreementStep != null) {
            this.myLicenseAgreementStep.performFinishingActions();
        }
        Sdk jdk = null;
        String jdkLocation = this.myState.get(WizardConstants.KEY_JDK_LOCATION);
        if (jdkLocation != null) {
            Ref result2 = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> result2.set((Object)IdeSdks.getInstance().setJdkPath(Paths.get(jdkLocation, new String[0])))), ModalityState.any());
            jdk = (Sdk)result2.get();
        }
        SetPreference setPreference = new SetPreference(this.myMode.getInstallerTimestamp(), ModalityState.stateForComponent((Component)this.myWizard.getContentPane()), jdk);
        if (selectedComponents.isEmpty()) {
            this.myProgressStep.print("Nothing to do!", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        try {
            install2.then(setPreference).then(new ConfigureComponents(installContext, selectedComponents, this.myLocalHandler)).then(checkSdk).execute(destination);
        }
        catch (InstallationCancelledException e) {
            installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
            this.myProgressStep.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    @Nullable
    public static RemotePackage findLatestPlatform(@Nullable Map<String, RemotePackage> remotePackages, boolean returnBaseExtension) {
        if (remotePackages == null) {
            return null;
        }
        AndroidVersion max = null;
        RemotePackage latest = null;
        for (RemotePackage pkg : remotePackages.values()) {
            DetailsTypes.PlatformDetailsType platformDetails;
            AndroidVersion version2;
            TypeDetails details = pkg.getTypeDetails();
            if (!(details instanceof DetailsTypes.PlatformDetailsType) || (version2 = (platformDetails = (DetailsTypes.PlatformDetailsType)details).getAndroidVersion()).isPreview() || returnBaseExtension && !version2.isBaseExtension() || max != null && version2.compareTo(max) <= 0) continue;
            latest = pkg;
            max = version2;
        }
        return latest;
    }

    @NotNull
    private File getDestination() throws WizardException {
        String destinationPath = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
        assert (destinationPath != null);
        File destination = new File(destinationPath);
        if (destination.isFile()) {
            throw new WizardException(String.format("Path %s does not point to a directory", destination));
        }
        return destination;
    }

    @Override
    public boolean performFinishingActions() {
        return true;
    }

    @Override
    public boolean isPathVisible() {
        return true;
    }

    public boolean shouldDownloadingComponentsStepBeShown() {
        String path2 = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
        assert (path2 != null);
        return SdkLocationUtils.isWritable(Paths.get(path2, new String[0]));
    }

    private static class ConfigureComponents
    implements Function<File, File> {
        private final InstallContext myInstallContext;
        private final Collection<? extends InstallableComponent> mySelectedComponents;
        private final AndroidSdkHandler mySdkHandler;

        ConfigureComponents(InstallContext installContext, Collection<? extends InstallableComponent> selectedComponents, AndroidSdkHandler sdkHandler) {
            this.myInstallContext = installContext;
            this.mySelectedComponents = selectedComponents;
            this.mySdkHandler = sdkHandler;
        }

        public File apply(@Nullable File input2) {
            assert (input2 != null);
            for (InstallableComponent installableComponent : this.mySelectedComponents) {
                installableComponent.configure(this.myInstallContext, this.mySdkHandler);
            }
            return input2;
        }
    }

    private static class SetPreference
    implements Function<File, File> {
        @NotNull
        private final ModalityState myModalityState;
        @Nullable
        private final String myInstallerTimestamp;
        @Nullable
        private final Sdk myJdk;

        SetPreference(@Nullable String installerTimestamp, @NotNull ModalityState modalityState, @Nullable Sdk jdk) {
            this.myInstallerTimestamp = installerTimestamp;
            this.myModalityState = modalityState;
            this.myJdk = jdk;
        }

        public File apply(@Nullable File input2) {
            assert (input2 != null);
            ApplicationUtils.invokeWriteActionAndWait(this.myModalityState, () -> {
                IdeSdks.getInstance().setAndroidSdkPath(input2, this.myJdk, ProjectManager.getInstance().getDefaultProject());
                if (this.myJdk != null && !StringUtil.isEmpty((String)this.myJdk.getHomePath())) {
                    IdeSdks.findOrCreateJdk("Android Studio default JDK", Paths.get(this.myJdk.getHomePath(), new String[0]));
                }
                AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(this.myInstallerTimestamp);
            });
            return input2;
        }
    }

    private static class ReturnValue
    implements Function<File, File> {
        private ReturnValue() {
        }

        public File apply(@Nullable File input2) {
            assert (input2 != null);
            return input2;
        }
    }
}

