/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.gradle.ui.LabelAndFileForLocation;
import com.android.tools.idea.gradle.ui.SdkUiStrings;
import com.android.tools.idea.gradle.ui.SdkUiUtils;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.welcome.wizard.FirstRunModel;
import com.android.tools.idea.welcome.wizard.JdkSetupStep;
import com.android.tools.idea.welcome.wizard.JdkSetupStepKt;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.WizardModel;
import com.android.tools.idea.wizard.ui.WizardUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0012H\u0014J\b\u0010\u0016\u001a\u00020\u0010H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\u0012\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/welcome/wizard/JdkSetupStep;", "Lcom/android/tools/idea/wizard/model/ModelWizardStep;", "Lcom/android/tools/idea/welcome/wizard/FirstRunModel;", "model", "(Lcom/android/tools/idea/welcome/wizard/FirstRunModel;)V", "invalidPathMessage", "Lcom/android/tools/idea/observable/core/StringValueProperty;", "isValidJdkPath", "Lcom/android/tools/idea/observable/core/BoolValueProperty;", "jdkLocation", "Ljava/nio/file/Path;", "getJdkLocation", "()Ljava/nio/file/Path;", "jdkLocationComboBox", "Lcom/intellij/ui/ComboboxWithBrowseButton;", "jdkPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "validatorPanel", "Lcom/android/tools/adtui/validation/ValidatorPanel;", "canGoForward", "Lcom/android/tools/idea/observable/core/ObservableBool;", "getComponent", "getPreferredFocusComponent", "onEntering", "", "onProceeding", "setJdkLocationComboBox", "path", "validateJdkPath", "file", "intellij.android.core"})
public final class JdkSetupStep
extends ModelWizardStep<FirstRunModel> {
    @NotNull
    private final ComboboxWithBrowseButton jdkLocationComboBox;
    @NotNull
    private final DialogPanel jdkPanel;
    @NotNull
    private final ValidatorPanel validatorPanel;
    @NotNull
    private final StringValueProperty invalidPathMessage;
    @NotNull
    private final BoolValueProperty isValidJdkPath;

    /*
     * WARNING - void declaration
     */
    public JdkSetupStep(@NotNull FirstRunModel model2) {
        void $this$jdkPanel_u24lambda_u2d0;
        LayoutBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super((WizardModel)model2, "Select default JDK location");
        this.jdkLocationComboBox = new ComboboxWithBrowseButton();
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder layoutBuilder = builder$iv = LayoutImplKt.createLayoutBuilder();
        JdkSetupStep jdkSetupStep = this;
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$jdkPanel_u24lambda_u2d0), null, (boolean)false, (Function1)jdkPanel.1.1.INSTANCE, (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$jdkPanel_u24lambda_u2d0), null, (boolean)false, (Function1)jdkPanel.1.2.INSTANCE, (int)3, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$jdkPanel_u24lambda_u2d0), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ JdkSetupStep this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                Cell.invoke$default((Cell)((Cell)$this$row), (JComponent)((JComponent)JdkSetupStep.access$getJdkLocationComboBox$p(this.this$0)), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        jdkSetupStep.jdkPanel = panel$iv;
        this.validatorPanel = new ValidatorPanel((Disposable)this, (JComponent)WizardUtils.wrapWithVScroll((JPanel)this.jdkPanel));
        this.invalidPathMessage = new StringValueProperty();
        this.isValidJdkPath = new BoolValueProperty(false);
        FileChooserDescriptor descriptor2 = JdkSetupStepKt.createSingleFolderDescriptor((Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(this){
            final /* synthetic */ JdkSetupStep this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Path file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (JdkSetupStep.access$validateJdkPath(this.this$0, file2) == null) {
                    throw new IllegalArgumentException(SdkUiStrings.generateChooseValidJdkDirectoryError());
                }
                JdkSetupStep.access$setJdkLocationComboBox(this.this$0, file2);
            }
        }));
        this.jdkLocationComboBox.addBrowseFolderListener(null, descriptor2);
        JComboBox comboBox2 = this.jdkLocationComboBox.getComboBox();
        comboBox2.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.validateJdkPath(this.getJdkLocation());
            }
        });
        Path embeddedPath = IdeSdks.getInstance().getEmbeddedJdkPath();
        JdkSetupStep._init_$addJdkIfValid(this, comboBox2, embeddedPath, "Embedded JDK");
        String javaHomePath = IdeSdks.getJdkFromJavaHome();
        if (javaHomePath != null) {
            JdkSetupStep._init_$addJdkIfValid(this, comboBox2, Paths.get(javaHomePath, new String[0]), "JAVA_HOME");
        }
        comboBox2.setEditable(true);
        comboBox2.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent event) {
                final Object selectedItem = event.getItem();
                if (event.getStateChange() == 1 && selectedItem instanceof LabelAndFileForLocation) {
                    WelcomeUiUtils.invokeLater$default(null, (Function0)new Function0<Unit>(){

                        public final void invoke() {
                            this.setJdkLocationComboBox(((LabelAndFileForLocation)selectedItem).getFile());
                        }
                    }, 1, null);
                }
            }
        });
        this.setJdkLocationComboBox(embeddedPath);
    }

    private final Path getJdkLocation() {
        Path path2 = SdkUiUtils.getLocationFromComboBoxWithBrowseButton(this.jdkLocationComboBox);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getLocationFromComboBoxW\u2026tton(jdkLocationComboBox)");
        return path2;
    }

    @Override
    protected void onEntering() {
        this.validatorPanel.registerMessageSource((ObservableValue)this.invalidPathMessage);
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.isValidJdkPath;
    }

    @Override
    protected void onProceeding() {
        Path path2;
        Path path3 = path2 = this.getJdkLocation().toAbsolutePath().normalize();
        Intrinsics.checkNotNull((Object)path3);
        IdeSdks.findOrCreateJdk("Android Studio default JDK", path3);
    }

    @NotNull
    protected DialogPanel getPreferredFocusComponent() {
        return this.jdkPanel;
    }

    @NotNull
    protected ValidatorPanel getComponent() {
        return this.validatorPanel;
    }

    private final Path validateJdkPath(Path file2) {
        Path possiblePath = IdeSdks.getInstance().validateJdkPath(file2);
        if (possiblePath != null) {
            this.setJdkLocationComboBox(possiblePath);
            this.isValidJdkPath.set(true);
            return possiblePath;
        }
        this.isValidJdkPath.set(false);
        return null;
    }

    private final void setJdkLocationComboBox(Path path2) {
        Path path3 = path2;
        this.jdkLocationComboBox.getComboBox().setSelectedItem(path3 != null ? ((Object)path3).toString() : null);
    }

    private static final void _init_$addJdkIfValid(JdkSetupStep this$0, JComboBox comboBox2, Path path2, String label) {
        if (path2 == null) {
            return;
        }
        Path path3 = this$0.validateJdkPath(path2);
        if (path3 == null) {
            return;
        }
        Path validatedPath = path3;
        comboBox2.addItem(new LabelAndFileForLocation(label, validatedPath));
    }

    public static final /* synthetic */ ComboboxWithBrowseButton access$getJdkLocationComboBox$p(JdkSetupStep $this) {
        return $this.jdkLocationComboBox;
    }
}

