/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.AndroidSdk;
import com.android.tools.idea.welcome.install.AndroidVirtualDevice;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.Gvm;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallationIntention;
import com.android.tools.idea.welcome.install.Platform;
import com.android.tools.idea.welcome.wizard.FirstRunModel;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\nH\u0002J\b\u0010'\u001a\u00020(H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/welcome/wizard/FirstRunModel;", "Lcom/android/tools/idea/wizard/model/WizardModel;", "mode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "(Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;)V", "componentTree", "Lcom/android/tools/idea/welcome/install/ComponentTreeNode;", "getComponentTree", "()Lcom/android/tools/idea/welcome/install/ComponentTreeNode;", "customInstall", "", "getCustomInstall", "()Z", "installationType", "Lcom/android/tools/idea/observable/core/ObjectValueProperty;", "Lcom/android/tools/idea/welcome/wizard/FirstRunModel$InstallationType;", "getInstallationType", "()Lcom/android/tools/idea/observable/core/ObjectValueProperty;", "jdkLocation", "Ljava/nio/file/Path;", "Lorg/jetbrains/annotations/NotNull;", "getJdkLocation", "()Ljava/nio/file/Path;", "localHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "getLocalHandler", "()Lcom/android/sdklib/repository/AndroidSdkHandler;", "setLocalHandler", "(Lcom/android/sdklib/repository/AndroidSdkHandler;)V", "sdkExists", "getSdkExists", "sdkLocation", "Ljava/io/File;", "getSdkLocation", "()Ljava/io/File;", "setSdkLocation", "(Ljava/io/File;)V", "createComponentTree", "createAvd", "handleFinished", "", "InstallationType", "intellij.android.core"})
public final class FirstRunModel
extends WizardModel {
    @NotNull
    private final FirstRunWizardMode mode;
    @NotNull
    private File sdkLocation;
    @NotNull
    private final ObjectValueProperty<InstallationType> installationType;
    @NotNull
    private final Path jdkLocation;
    private final boolean sdkExists;
    @NotNull
    private AndroidSdkHandler localHandler;
    @NotNull
    private final ComponentTreeNode componentTree;

    public FirstRunModel(@NotNull FirstRunWizardMode mode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mode = mode;
        this.sdkLocation = FirstRunWizardDefaults.getInitialSdkLocation(this.mode);
        String string = this.sdkLocation.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdkLocation.path");
        this.installationType = new ObjectValueProperty<InstallationType>(((CharSequence)string).length() == 0 ? InstallationType.CUSTOM : InstallationType.STANDARD);
        Path path2 = EmbeddedDistributionPaths.getInstance().getEmbeddedJdkPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getInstance().embeddedJdkPath");
        this.jdkLocation = path2;
        if (this.sdkLocation.isDirectory()) {
            AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE), (Path)this.sdkLocation.toPath());
            StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
            Map map2 = sdkHandler.getSdkManager((ProgressIndicator)progress2).getPackages().getLocalPackages();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"sdkHandler.getSdkManager\u2026s).packages.localPackages");
            bl = !map2.isEmpty();
        } else {
            bl = false;
        }
        this.sdkExists = bl;
        AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE), (Path)this.sdkLocation.toPath());
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance(AndroidLocat\u2026on, sdkLocation.toPath())");
        this.localHandler = androidSdkHandler;
        this.componentTree = this.createComponentTree(true);
        Disposable mockDisposable2 = mockDisposable.1.INSTANCE;
        ProgressStep mockProgressStep2 = new ProgressStep(mockDisposable2){

            protected void execute() {
            }
        };
        this.componentTree.init(mockProgressStep2);
        this.componentTree.updateState(this.localHandler);
    }

    @NotNull
    public final File getSdkLocation() {
        return this.sdkLocation;
    }

    public final void setSdkLocation(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"<set-?>");
        this.sdkLocation = file2;
    }

    @NotNull
    public final ObjectValueProperty<InstallationType> getInstallationType() {
        return this.installationType;
    }

    public final boolean getCustomInstall() {
        return this.installationType.get() == InstallationType.CUSTOM;
    }

    @NotNull
    public final Path getJdkLocation() {
        return this.jdkLocation;
    }

    public final boolean getSdkExists() {
        return this.sdkExists;
    }

    @NotNull
    public final AndroidSdkHandler getLocalHandler() {
        return this.localHandler;
    }

    public final void setLocalHandler(@NotNull AndroidSdkHandler androidSdkHandler) {
        Intrinsics.checkNotNullParameter((Object)androidSdkHandler, (String)"<set-?>");
        this.localHandler = androidSdkHandler;
    }

    @NotNull
    public final ComponentTreeNode getComponentTree() {
        return this.componentTree;
    }

    private final ComponentTreeNode createComponentTree(boolean createAvd2) {
        RepoManager repoManager;
        boolean installUpdates = true;
        Object[] objectArray = new ComponentTreeNode[]{new AndroidSdk(installUpdates)};
        List components = CollectionsKt.mutableListOf((Object[])objectArray);
        RepoManager $this$createComponentTree_u24lambda_u2d0 = repoManager = this.localHandler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        boolean bl = false;
        $this$createComponentTree_u24lambda_u2d0.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, null, null, (ProgressRunner)new StudioProgressRunner(true, false, "Finding Available SDK Components", null), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        RepoManager sdkManager = repoManager;
        Map remotePackages = sdkManager.getPackages().getRemotePackages();
        ComponentTreeNode platforms = Platform.Companion.createSubtree(remotePackages, installUpdates);
        if (platforms != null) {
            components.add(platforms);
        }
        InstallationIntention installationIntention = InstallationIntention.INSTALL_WITH_UPDATES;
        if (this.mode == FirstRunWizardMode.NEW_INSTALL && Haxm.InstallerInfo.canRun()) {
            ScopedStateStore.Key<Boolean> key = FirstRunWizard.KEY_CUSTOM_INSTALL;
            Intrinsics.checkNotNullExpressionValue(key, (String)"KEY_CUSTOM_INSTALL");
            components.add(new Haxm(installationIntention, key));
        }
        if (this.mode == FirstRunWizardMode.NEW_INSTALL && Gvm.InstallerInfo.canRun()) {
            ScopedStateStore.Key<Boolean> key = FirstRunWizard.KEY_CUSTOM_INSTALL;
            Intrinsics.checkNotNullExpressionValue(key, (String)"KEY_CUSTOM_INSTALL");
            components.add(new Gvm(installationIntention, key));
        }
        if (createAvd2) {
            Intrinsics.checkNotNullExpressionValue((Object)remotePackages, (String)"remotePackages");
            components.add(new AndroidVirtualDevice(remotePackages, installUpdates));
        }
        return new ComponentCategory("Root", "Root node that is not supposed to appear in the UI", components);
    }

    @Override
    protected void handleFinished() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/welcome/wizard/FirstRunModel$InstallationType;", "", "(Ljava/lang/String;I)V", "STANDARD", "CUSTOM", "intellij.android.core"})
    public static final class InstallationType
    extends Enum<InstallationType> {
        public static final /* enum */ InstallationType STANDARD = new InstallationType();
        public static final /* enum */ InstallationType CUSTOM = new InstallationType();
        private static final /* synthetic */ InstallationType[] $VALUES;

        public static InstallationType[] values() {
            return (InstallationType[])$VALUES.clone();
        }

        public static InstallationType valueOf(String value2) {
            return Enum.valueOf(InstallationType.class, value2);
        }

        static {
            $VALUES = installationTypeArray = new InstallationType[]{InstallationType.STANDARD, InstallationType.CUSTOM};
        }
    }
}

