/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.tools.idea.welcome.install.InstallContext;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkManagerProgressIndicatorIntegration
extends ProgressIndicatorAdapter {
    private final ProgressIndicator myIndicator;
    private final InstallContext myContext;
    private StringBuffer myErrors = new StringBuffer();

    public SdkManagerProgressIndicatorIntegration(@NotNull ProgressIndicator indicator, @NotNull InstallContext context2) {
        this.myIndicator = indicator;
        this.myContext = context2;
    }

    public boolean isCanceled() {
        return this.myIndicator.isCanceled();
    }

    public void cancel() {
        this.myIndicator.cancel();
    }

    public void setFraction(double progress2) {
        this.myIndicator.setFraction(progress2);
    }

    public void setText(@Nullable String title) {
        this.myIndicator.setText(title);
    }

    public void setSecondaryText(@Nullable String s) {
        this.myIndicator.setText2(s);
    }

    public void logInfo(String s) {
        this.myContext.print(s, ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void logError(String s, @Nullable Throwable e) {
        if (e != null) {
            String message2 = String.format("%s: %s\n", e.getClass().getName(), e.getMessage());
            this.myErrors.append(message2);
            this.myContext.print(message2, ConsoleViewContentType.ERROR_OUTPUT);
        }
        this.myContext.print(s, ConsoleViewContentType.ERROR_OUTPUT);
        this.myErrors.append(s);
    }

    public void logWarning(String s, @Nullable Throwable e) {
        String message2;
        if (e != null) {
            message2 = String.format("%s: %s\n", e.getClass().getName(), e.getMessage());
            this.myContext.print(message2, ConsoleViewContentType.LOG_WARNING_OUTPUT);
            this.myErrors.append(message2);
        }
        message2 = String.format("Warning: %s\n", s);
        this.myContext.print(message2, ConsoleViewContentType.LOG_WARNING_OUTPUT);
        this.myErrors.append(message2);
    }

    public String getErrors() {
        return this.myErrors.toString();
    }
}

